/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceData;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceSupport;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeTemplate;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DelegatedTypeSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.TypeCheckerContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\"\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"JL\u0010#\u001a\u00020\u00122\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030$26\u0010%\u001a2\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020\u00120&H\u0002J\u001c\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030$H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\n@\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/CoroutineInferenceSupport;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;)V", "getArgumentTypeResolver", "()Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "callCompleter", "Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "getCallCompleter", "()Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "setCallCompleter", "(Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;)V", "getExpressionTypingServices", "()Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "analyzeCoroutine", "", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunction;", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "lambdaExpectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "checkCoroutineCalls", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "tracingStrategy", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "overloadResults", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "forceInferenceForArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "argument", "argumentType", "getArgumentTypeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isBadCall", "", "resultingDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "CoroutineTypeCheckerContext", "kotlin-compiler"})
public final class CoroutineInferenceSupport {
    @NotNull
    public CallCompleter callCompleter;
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;

    @NotNull
    public final CallCompleter getCallCompleter() {
        CallCompleter callCompleter = this.callCompleter;
        if (callCompleter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("callCompleter");
        }
        return callCompleter;
    }

    @Inject
    public final void setCallCompleter(@NotNull CallCompleter callCompleter) {
        Intrinsics.checkParameterIsNotNull(callCompleter, "<set-?>");
        this.callCompleter = callCompleter;
    }

    /*
     * WARNING - void declaration
     */
    public final void analyzeCoroutine(@NotNull KtFunction functionLiteral, @NotNull ValueArgument valueArgument, @NotNull ConstraintSystem.Builder csBuilder, @NotNull CallCandidateResolutionContext<?> context, @NotNull KotlinType lambdaExpectedType) {
        Collection<KotlinType> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(functionLiteral, "functionLiteral");
        Intrinsics.checkParameterIsNotNull(valueArgument, "valueArgument");
        Intrinsics.checkParameterIsNotNull(csBuilder, "csBuilder");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(lambdaExpectedType, "lambdaExpectedType");
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        if (!FunctionTypesKt.isSuspendFunctionType(lambdaExpectedType)) {
            return;
        }
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(lambdaExpectedType);
        if (kotlinType == null) {
            return;
        }
        KotlinType lambdaReceiverType = kotlinType;
        CoroutineInferenceData inferenceData = new CoroutineInferenceData();
        ConstraintSystem constraintSystem = csBuilder.build();
        TypeSubstitution typeSubstitution = constraintSystem.getCurrentSubstitutor().getSubstitution();
        Intrinsics.checkExpressionValueIsNotNull(typeSubstitution, "constraintSystem.currentSubstitutor.substitution");
        DelegatedTypeSubstitution newSubstitution2 = new DelegatedTypeSubstitution(constraintSystem, inferenceData, typeSubstitution){
            final /* synthetic */ ConstraintSystem $constraintSystem;
            final /* synthetic */ CoroutineInferenceData $inferenceData;

            @Nullable
            public TypeProjection get(@NotNull KotlinType key) {
                Object v1;
                TypeProjection substitutedType;
                block3: {
                    Intrinsics.checkParameterIsNotNull(key, "key");
                    TypeProjection typeProjection = substitutedType = super.get(key);
                    if (Intrinsics.areEqual(typeProjection != null ? typeProjection.getType() : null, TypeUtils.DONT_CARE) ^ true) {
                        return substitutedType;
                    }
                    Iterable $receiver$iv = this.$constraintSystem.getTypeVariables();
                    for (T element$iv : $receiver$iv) {
                        TypeVariable it = (TypeVariable)element$iv;
                        if (!Intrinsics.areEqual(it.getOriginalTypeParameter().getDefaultType(), key)) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                TypeVariable typeVariable = v1;
                if (typeVariable == null) {
                    return substitutedType;
                }
                TypeVariable typeVariable2 = typeVariable;
                return TypeUtilsKt.asTypeProjection(this.$inferenceData.getTypeTemplate(typeVariable2));
            }

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
            {
                this.$constraintSystem = $captured_local_variable$0;
                this.$inferenceData = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        KotlinType kotlinType2 = newSubstitution2.buildSubstitutor().substitute(lambdaReceiverType, Variance.INVARIANT);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType newReceiverType = kotlinType2;
        TypeSubstitution typeSubstitution2 = constraintSystem.getCurrentSubstitutor().getSubstitution();
        Intrinsics.checkExpressionValueIsNotNull(typeSubstitution2, "constraintSystem.currentSubstitutor.substitution");
        DelegatedTypeSubstitution approximationSubstitutor2 = new DelegatedTypeSubstitution(constraintSystem, typeSubstitution2){
            final /* synthetic */ ConstraintSystem $constraintSystem;

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
            {
                this.$constraintSystem = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
        KotlinType kotlinType3 = approximationSubstitutor2.buildSubstitutor().substitute(lambdaExpectedType, Variance.IN_VARIANCE);
        if (kotlinType3 == null) {
            return;
        }
        KotlinType approximatedLambdaType = kotlinType3;
        Iterable iterable = FunctionTypesKt.getValueParameterTypesFromFunctionType(approximatedLambdaType);
        KotlinType kotlinType4 = newReceiverType;
        Annotations annotations2 = approximatedLambdaType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(newReceiverType);
        void var18_18 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            KotlinType kotlinType5 = p1.getType();
            collection.add(kotlinType5);
        }
        collection = (List)destination$iv$iv;
        SimpleType newExpectedType = FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType4, (List<? extends KotlinType>)collection, null, FunctionTypesKt.getReturnTypeFromFunctionType(approximatedLambdaType), true);
        if (CallResolverUtilKt.hasUnknownFunctionParameter(newExpectedType)) {
            return;
        }
        inferenceData.initSystem();
        TemporaryTraceAndCache temporaryForCoroutine = TemporaryTraceAndCache.create(context, "trace for type argument inference for coroutine", functionLiteral);
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context.replaceExpectedType(newExpectedType)).replaceDataFlowInfo(context.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument))).replaceContextDependency(ContextDependency.INDEPENDENT)).replaceTraceAndCache(temporaryForCoroutine);
        this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        inferenceData.reportInferenceResult(csBuilder);
    }

    public final void checkCoroutineCalls(@NotNull BasicCallResolutionContext context, @NotNull TracingStrategy tracingStrategy, @NotNull OverloadResolutionResultsImpl<?> overloadResults) {
        block5: {
            NewKotlinTypeChecker newKotlinTypeChecker;
            ReceiverValue receiverValue;
            Intrinsics.checkParameterIsNotNull(context, "context");
            Intrinsics.checkParameterIsNotNull(tracingStrategy, "tracingStrategy");
            Intrinsics.checkParameterIsNotNull(overloadResults, "overloadResults");
            CoroutineInferenceData coroutineInferenceData = CoroutineInferenceUtilKt.access$getCoroutineInferenceData(overloadResults);
            if (coroutineInferenceData == null) {
                return;
            }
            CoroutineInferenceData inferenceData = coroutineInferenceData;
            ResolvedCall resultingCall = overloadResults.getResultingCall();
            this.forceInferenceForArguments(context, checkCoroutineCalls.1.INSTANCE);
            CallCompleter callCompleter = this.callCompleter;
            if (callCompleter == null) {
                Intrinsics.throwUninitializedPropertyAccessException("callCompleter");
            }
            callCompleter.completeCall(context, overloadResults, tracingStrategy);
            if (!ArgumentMappingKt.isReallySuccess(resultingCall)) {
                return;
            }
            Object d = resultingCall.getResultingDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(d, "resultingCall.resultingDescriptor");
            if (this.isBadCall((CallableDescriptor)d)) {
                inferenceData.badCallHappened();
            }
            this.forceInferenceForArguments(context, (Function2<? super ValueArgument, ? super KotlinType, Unit>)new Function2<ValueArgument, KotlinType, Unit>((MutableResolvedCall)resultingCall){
                final /* synthetic */ MutableResolvedCall $resultingCall;

                public final void invoke(@NotNull ValueArgument valueArgument, @NotNull KotlinType kotlinType) {
                    NewKotlinTypeChecker newKotlinTypeChecker;
                    Intrinsics.checkParameterIsNotNull(valueArgument, "valueArgument");
                    Intrinsics.checkParameterIsNotNull(kotlinType, "kotlinType");
                    ArgumentMapping argumentMapping = this.$resultingCall.getArgumentMapping(valueArgument);
                    if (!(argumentMapping instanceof ArgumentMatch)) {
                        argumentMapping = null;
                    }
                    ArgumentMatch argumentMatch = (ArgumentMatch)argumentMapping;
                    if (argumentMatch == null) {
                        return;
                    }
                    ArgumentMatch argumentMatch2 = argumentMatch;
                    NewKotlinTypeChecker $receiver = newKotlinTypeChecker = NewKotlinTypeChecker.INSTANCE;
                    KotlinType parameterType = CallResolverUtilKt.getEffectiveExpectedType(argumentMatch2.getValueParameter(), valueArgument);
                    $receiver.isSubtypeOf(new CoroutineTypeCheckerContext(), kotlinType.unwrap(), parameterType.unwrap());
                }
                {
                    this.$resultingCall = mutableResolvedCall;
                    super(2);
                }
            });
            ReceiverParameterDescriptor receiverParameterDescriptor = resultingCall.getResultingDescriptor().getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                return;
            }
            ReceiverParameterDescriptor extensionReceiver = receiverParameterDescriptor;
            ReceiverValue receiverValue2 = resultingCall.getExtensionReceiver();
            if (receiverValue2 == null) break block5;
            ReceiverValue actualReceiver = receiverValue = receiverValue2;
            NewKotlinTypeChecker $receiver = newKotlinTypeChecker = NewKotlinTypeChecker.INSTANCE;
            $receiver.isSubtypeOf(new CoroutineTypeCheckerContext(), actualReceiver.getType().unwrap(), extensionReceiver.getValue().getType().unwrap());
        }
    }

    private final boolean isBadCall(CallableDescriptor resultingDescriptor) {
        isBadCall.1 containsTypeTemplate$ = isBadCall.1.INSTANCE;
        KotlinType kotlinType = resultingDescriptor.getReturnType();
        if (kotlinType == null) {
            return true;
        }
        KotlinType returnType = kotlinType;
        if (containsTypeTemplate$.invoke(returnType)) {
            return true;
        }
        if (!(resultingDescriptor instanceof FunctionDescriptor) || ((FunctionDescriptor)resultingDescriptor).isSuspend()) {
            return false;
        }
        for (ValueParameterDescriptor valueParameter : ((FunctionDescriptor)resultingDescriptor).getValueParameters()) {
            if (!containsTypeTemplate$.invoke(valueParameter.getType())) continue;
            return true;
        }
        return false;
    }

    private final void forceInferenceForArguments(CallResolutionContext<?> context, Function2<? super ValueArgument, ? super KotlinType, Unit> callback) {
        MutableDataFlowInfoForArguments infoForArguments = context.dataFlowInfoForArguments;
        Call call2 = context.call;
        CallResolutionContext baseContext = (CallResolutionContext)((CallResolutionContext)context.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        for (ValueArgument valueArgument : call2.getValueArguments()) {
            KotlinType kotlinType;
            KtExpression expression;
            if (valueArgument.getArgumentExpression() == null) {
                continue;
            }
            Object Context2 = baseContext.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            Intrinsics.checkExpressionValueIsNotNull(Context2, "baseContext.replaceDataF\u2026uments.getInfo(argument))");
            KotlinTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression, (CallResolutionContext)Context2);
            if (typeInfoForCall.getType() == null) continue;
            KotlinType it = kotlinType;
            ValueArgument valueArgument2 = valueArgument;
            Intrinsics.checkExpressionValueIsNotNull(valueArgument2, "argument");
            callback.invoke(valueArgument2, it);
        }
    }

    private final KotlinTypeInfo getArgumentTypeInfo(KtExpression expression, CallResolutionContext<?> context) {
        KtFunction ktFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression, context);
        if (ktFunction != null) {
            KtFunction ktFunction2;
            KtFunction it = ktFunction2 = ktFunction;
            KotlinTypeInfo kotlinTypeInfo = this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression, it, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "argumentTypeResolver.get\u2026SOLVE_FUNCTION_ARGUMENTS)");
            return kotlinTypeInfo;
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression, context);
        if (ktCallableReferenceExpression != null) {
            KtCallableReferenceExpression ktCallableReferenceExpression2;
            KtCallableReferenceExpression it = ktCallableReferenceExpression2 = ktCallableReferenceExpression;
            KotlinTypeInfo kotlinTypeInfo = this.argumentTypeResolver.getCallableReferenceTypeInfo(expression, it, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "argumentTypeResolver.get\u2026SOLVE_FUNCTION_ARGUMENTS)");
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression, context);
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "expressionTypingServices\u2026Info(expression, context)");
        return kotlinTypeInfo;
    }

    @NotNull
    public final ArgumentTypeResolver getArgumentTypeResolver() {
        return this.argumentTypeResolver;
    }

    @NotNull
    public final ExpressionTypingServices getExpressionTypingServices() {
        return this.expressionTypingServices;
    }

    public CoroutineInferenceSupport(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(expressionTypingServices, "expressionTypingServices");
        this.argumentTypeResolver = argumentTypeResolver;
        this.expressionTypingServices = expressionTypingServices;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/CoroutineInferenceSupport$CoroutineTypeCheckerContext;", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext;", "()V", "addSubtypeConstraint", "", "subType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "superType", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Lorg/jetbrains/kotlin/types/UnwrappedType;)Ljava/lang/Boolean;", "kotlin-compiler"})
    private static final class CoroutineTypeCheckerContext
    extends TypeCheckerContext {
        @Override
        @Nullable
        public Boolean addSubtypeConstraint(@NotNull UnwrappedType subType, @NotNull UnwrappedType superType) {
            block3: {
                Object object;
                Object object2;
                Intrinsics.checkParameterIsNotNull(subType, "subType");
                Intrinsics.checkParameterIsNotNull(superType, "superType");
                UnwrappedType unwrappedType = subType;
                if (!(unwrappedType instanceof TypeTemplate)) {
                    unwrappedType = null;
                }
                if ((object2 = (TypeTemplate)unwrappedType) == null) {
                    UnwrappedType unwrappedType2 = superType;
                    if (!(unwrappedType2 instanceof TypeTemplate)) {
                        unwrappedType2 = null;
                    }
                    object2 = object = (TypeTemplate)unwrappedType2;
                }
                if (object2 == null || (object = ((TypeTemplate)object).getCoroutineInferenceData()) == null) break block3;
                ((CoroutineInferenceData)object).addConstraint(subType, superType);
            }
            return null;
        }

        public CoroutineTypeCheckerContext() {
            super(true);
        }
    }
}

