/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChangeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class SharedImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.SharedImplUtil");
    private static final boolean CHECK_FOR_READ_ACTION = DebugUtil.DO_EXPENSIVE_CHECKS || ApplicationManager.getApplication().isInternal();

    private SharedImplUtil() {
    }

    public static PsiElement getParent(ASTNode thisElement) {
        if (CHECK_FOR_READ_ACTION && thisElement instanceof ElementBase) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreeParent());
    }

    public static PsiElement getFirstChild(ASTNode element) {
        return SourceTreeToPsiMap.treeElementToPsi(element.getFirstChildNode());
    }

    @Nullable
    public static PsiElement getLastChild(ASTNode element) {
        return SourceTreeToPsiMap.treeElementToPsi(element.getLastChildNode());
    }

    public static PsiElement getNextSibling(ASTNode thisElement) {
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreeNext());
    }

    public static PsiElement getPrevSibling(ASTNode thisElement) {
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreePrev());
    }

    public static PsiFile getContainingFile(ASTNode thisElement) {
        PsiElement psi;
        FileASTNode node = SharedImplUtil.findFileElement(thisElement);
        PsiElement psiElement = psi = node == null ? null : node.getPsi();
        if (psi == null || psi instanceof PsiFile) {
            return (PsiFile)psi;
        }
        throw new AssertionError((Object)("Invalid PSI " + psi + " of " + psi.getClass() + " for AST " + node + " of " + node.getClass()));
    }

    public static boolean isValid(ASTNode thisElement) {
        LOG.assertTrue(thisElement instanceof PsiElement);
        PsiFile file2 = SharedImplUtil.getContainingFile(thisElement);
        return file2 != null && file2.isValid();
    }

    public static boolean isWritable(ASTNode thisElement) {
        PsiFile file2 = SharedImplUtil.getContainingFile(thisElement);
        return file2 == null || file2.isWritable();
    }

    public static FileASTNode findFileElement(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/SharedImplUtil", "findFileElement"));
        }
        if (CHECK_FOR_READ_ACTION && element instanceof ElementBase) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode parent2 = element.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            element = parent2;
        }
        if (element instanceof FileASTNode) {
            return (FileASTNode)element;
        }
        return null;
    }

    @NotNull
    public static CharTable findCharTableByTree(ASTNode tree) {
        for (ASTNode o = tree; o != null; o = o.getTreeParent()) {
            CharTable charTable = o.getUserData(CharTable.CHAR_TABLE_KEY);
            if (charTable != null) {
                CharTable charTable2 = charTable;
                if (charTable2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/SharedImplUtil", "findCharTableByTree"));
                }
                return charTable2;
            }
            if (!(o instanceof FileASTNode)) continue;
            CharTable charTable3 = ((FileASTNode)o).getCharTable();
            if (charTable3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/SharedImplUtil", "findCharTableByTree"));
            }
            return charTable3;
        }
        throw new AssertionError((Object)("CharTable not found in: " + tree));
    }

    public static PsiElement addRange(PsiElement thisElement, PsiElement first, PsiElement last, ASTNode anchor2, Boolean before) throws IncorrectOperationException {
        ASTNode element;
        CheckUtil.checkWritable(thisElement);
        CharTable table = SharedImplUtil.findCharTableByTree(SourceTreeToPsiMap.psiElementToTree(thisElement));
        ASTNode copyFirst = null;
        TreeElement copyLast = null;
        ASTNode next = SourceTreeToPsiMap.psiElementToTree(last).getTreeNext();
        CompositeElement parent2 = null;
        for (element = SourceTreeToPsiMap.psiElementToTree(first); element != next; element = element.getTreeNext()) {
            TreeElement elementCopy = ChangeUtil.copyElement((TreeElement)element, table);
            if (element == first.getNode()) {
                copyFirst = elementCopy;
            }
            if (element == last.getNode()) {
                copyLast = elementCopy;
            }
            if (parent2 == null) {
                parent2 = elementCopy.getTreeParent();
                continue;
            }
            if (elementCopy.getElementType() == TokenType.WHITE_SPACE) {
                CodeEditUtil.setNodeGenerated(elementCopy, true);
            }
            parent2.addChild(elementCopy, null);
        }
        if (copyFirst == null) {
            return null;
        }
        copyFirst = ((CompositeElement)SourceTreeToPsiMap.psiElementToTree(thisElement)).addInternal((TreeElement)copyFirst, copyLast, anchor2, before);
        for (element = copyFirst; element != null; element = ((TreeElement)element).getTreeNext()) {
            if (((TreeElement)(element = ChangeUtil.decodeInformation((TreeElement)element))).getTreePrev() != null) continue;
            copyFirst = element;
        }
        return SourceTreeToPsiMap.treeElementToPsi(copyFirst);
    }

    public static PsiManager getManagerByTree(ASTNode node) {
        if (node instanceof FileElement) {
            return node.getPsi().getManager();
        }
        return node.getTreeParent().getPsi().getManager();
    }

    @NotNull
    public static ASTNode[] getChildrenOfType(@NotNull ASTNode node, @NotNull IElementType elementType) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/SharedImplUtil", "getChildrenOfType"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/SharedImplUtil", "getChildrenOfType"));
        }
        int count = SharedImplUtil.countChildrenOfType(node, elementType);
        if (count == 0) {
            if (ASTNode.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/SharedImplUtil", "getChildrenOfType"));
            }
            return ASTNode.EMPTY_ARRAY;
        }
        ASTNode[] result2 = new ASTNode[count];
        count = 0;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != elementType) continue;
            result2[count++] = child;
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/SharedImplUtil", "getChildrenOfType"));
        }
        return result2;
    }

    private static int countChildrenOfType(@NotNull ASTNode node, @NotNull IElementType elementType) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/SharedImplUtil", "countChildrenOfType"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/SharedImplUtil", "countChildrenOfType"));
        }
        int count = 0;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != elementType) continue;
            ++count;
        }
        return count;
    }

    public static void acceptChildren(PsiElementVisitor visitor2, ASTNode root) {
        for (ASTNode childNode = root.getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            PsiElement psi = childNode instanceof PsiElement ? (PsiElement)((Object)childNode) : childNode.getPsi();
            psi.accept(visitor2);
        }
    }

    public static PsiElement doReplace(PsiElement psiElement, TreeElement treeElement, PsiElement newElement) {
        CompositeElement treeParent = treeElement.getTreeParent();
        LOG.assertTrue(treeParent != null);
        CheckUtil.checkWritable(psiElement);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        treeParent.replaceChildInternal(treeElement, elementCopy);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        PsiElement result2 = SourceTreeToPsiMap.treeElementToPsi(elementCopy);
        treeElement.invalidate();
        return result2;
    }
}

