/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

public final class TemporariesUtils {
    private TemporariesUtils() {
    }

    @NotNull
    public static List<TemporaryVariable> fromExpressionList(@NotNull List<JsExpression> expressions, @NotNull TranslationContext context) {
        if (expressions == null) {
            TemporariesUtils.$$$reportNull$$$0(0);
        }
        if (context == null) {
            TemporariesUtils.$$$reportNull$$$0(1);
        }
        ArrayList<TemporaryVariable> result2 = Lists.newArrayList();
        for (JsExpression expression : expressions) {
            result2.add(context.declareTemporary(expression));
        }
        ArrayList<TemporaryVariable> arrayList = result2;
        if (arrayList == null) {
            TemporariesUtils.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static List<JsExpression> toExpressionList(@NotNull List<TemporaryVariable> temporaries) {
        if (temporaries == null) {
            TemporariesUtils.$$$reportNull$$$0(3);
        }
        ArrayList<JsExpression> result2 = Lists.newArrayList();
        for (TemporaryVariable temp : temporaries) {
            result2.add(temp.reference());
        }
        ArrayList<JsExpression> arrayList = result2;
        if (arrayList == null) {
            TemporariesUtils.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static JsExpression temporariesInitialization(TemporaryVariable ... temporaries) {
        if (temporaries == null) {
            TemporariesUtils.$$$reportNull$$$0(5);
        }
        ArrayList<JsExpression> result2 = Lists.newArrayList();
        for (TemporaryVariable temporary : temporaries) {
            result2.add(temporary.assignmentExpression());
        }
        JsExpression jsExpression = JsAstUtils.newSequence(result2);
        if (jsExpression == null) {
            TemporariesUtils.$$$reportNull$$$0(6);
        }
        return jsExpression;
    }

    @NotNull
    public static List<JsExpression> temporariesInitialization(@NotNull List<TemporaryVariable> temporaries) {
        if (temporaries == null) {
            TemporariesUtils.$$$reportNull$$$0(7);
        }
        ArrayList<JsExpression> result2 = Lists.newArrayList();
        for (TemporaryVariable temporary : temporaries) {
            result2.add(temporary.assignmentExpression());
        }
        ArrayList<JsExpression> arrayList = result2;
        if (arrayList == null) {
            TemporariesUtils.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/TemporariesUtils";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temporaries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/TemporariesUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromExpressionList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toExpressionList";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "temporariesInitialization";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromExpressionList";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toExpressionList";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "temporariesInitialization";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

