/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFunctionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public class PsiPolyExpressionUtil {
    public static boolean hasStandaloneForm(PsiExpression expression) {
        return !(expression instanceof PsiFunctionalExpression) && !(expression instanceof PsiParenthesizedExpression) && !(expression instanceof PsiConditionalExpression) && !(expression instanceof PsiCallExpression);
    }

    public static boolean isPolyExpression(PsiExpression expression) {
        ConditionalKind conditionalKind;
        if (expression instanceof PsiFunctionalExpression) {
            return true;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isPolyExpression(((PsiParenthesizedExpression)expression).getExpression());
        }
        if (expression instanceof PsiNewExpression && PsiDiamondType.hasDiamond((PsiNewExpression)expression)) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression);
        }
        if (expression instanceof PsiMethodCallExpression) {
            MethodCandidateInfo.CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(((PsiMethodCallExpression)expression).getArgumentList());
            return PsiPolyExpressionUtil.isMethodCallPolyExpression(expression, candidateProperties != null ? candidateProperties.getMethod() : ((PsiMethodCallExpression)expression).resolveMethod());
        }
        if (expression instanceof PsiConditionalExpression && (conditionalKind = PsiPolyExpressionUtil.isBooleanOrNumeric(expression)) == null) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression);
        }
        return false;
    }

    public static boolean isMethodCallPolyExpression(PsiExpression expression, PsiMethod method) {
        if (PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression) && ((PsiCallExpression)expression).getTypeArguments().length == 0) {
            if (method != null) {
                return PsiPolyExpressionUtil.isMethodCallTypeDependsOnInference(expression, method);
            }
            return true;
        }
        return false;
    }

    public static boolean isMethodCallTypeDependsOnInference(PsiExpression expression, PsiMethod method) {
        HashSet<PsiTypeParameter> typeParameters2 = new HashSet<PsiTypeParameter>(Arrays.asList(method.getTypeParameters()));
        if (!typeParameters2.isEmpty()) {
            PsiType returnType = method.getReturnType();
            if (returnType != null) {
                return PsiPolyExpressionUtil.mentionsTypeParameters(returnType, typeParameters2);
            }
        } else if (method.isConstructor() && expression instanceof PsiNewExpression && PsiDiamondType.hasDiamond((PsiNewExpression)expression)) {
            return true;
        }
        return false;
    }

    public static Boolean mentionsTypeParameters(@Nullable PsiType returnType, final Set<PsiTypeParameter> typeParameters2) {
        if (returnType == null) {
            return false;
        }
        return returnType.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitType(PsiType type2) {
                return false;
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound != null) {
                    return bound.accept(this);
                }
                return false;
            }

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                for (PsiType type2 : classType.getParameters()) {
                    if (!type2.accept(this).booleanValue()) continue;
                    return true;
                }
                PsiClass psiClass = classType.resolve();
                return psiClass instanceof PsiTypeParameter && typeParameters2.contains(psiClass);
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }
        });
    }

    private static boolean isInAssignmentOrInvocationContext(PsiExpression expr) {
        PsiElement context = PsiUtil.skipParenthesizedExprUp(expr.getParent());
        return context instanceof PsiExpressionList || context instanceof PsiArrayInitializerExpression || context instanceof PsiConditionalExpression && (expr instanceof PsiCallExpression || PsiPolyExpressionUtil.isPolyExpression((PsiExpression)context)) || PsiPolyExpressionUtil.isAssignmentContext(expr, context);
    }

    private static boolean isAssignmentContext(PsiExpression expr, PsiElement context) {
        return PsiUtil.isCondition(expr, context) || context instanceof PsiReturnStatement || context instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)context).getOperationTokenType() == JavaTokenType.EQ || context instanceof PsiVariable || context instanceof PsiLambdaExpression;
    }

    public static boolean isExpressionOfPrimitiveType(@Nullable PsiExpression arg) {
        if (arg != null && !PsiPolyExpressionUtil.isPolyExpression(arg)) {
            PsiType type2 = arg.getType();
            return type2 instanceof PsiPrimitiveType && type2 != PsiType.NULL;
        }
        if (arg instanceof PsiNewExpression || arg instanceof PsiFunctionalExpression) {
            return false;
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isExpressionOfPrimitiveType(((PsiParenthesizedExpression)arg).getExpression());
        }
        if (arg instanceof PsiConditionalExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(arg) != null;
        }
        if (arg instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)arg).resolveMethod();
            return method != null && method.getReturnType() instanceof PsiPrimitiveType;
        }
        assert (false) : arg;
        return false;
    }

    private static ConditionalKind isBooleanOrNumeric(PsiExpression expr) {
        PsiMethod method;
        if (expr instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(((PsiParenthesizedExpression)expr).getExpression());
        }
        if (expr == null) {
            return null;
        }
        PsiType type2 = null;
        if (expr instanceof PsiNewExpression && !PsiDiamondType.hasDiamond((PsiNewExpression)expr) || PsiPolyExpressionUtil.hasStandaloneForm(expr)) {
            type2 = expr.getType();
        } else if (expr instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)expr).resolveMethod()) != null) {
            type2 = method.getReturnType();
        }
        ConditionalKind kind = PsiPolyExpressionUtil.isBooleanOrNumericType(type2);
        if (kind != null) {
            return kind;
        }
        if (expr instanceof PsiConditionalExpression) {
            ConditionalKind elseKind;
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            ConditionalKind thenKind = PsiPolyExpressionUtil.isBooleanOrNumeric(thenExpression);
            if (thenKind == (elseKind = PsiPolyExpressionUtil.isBooleanOrNumeric(elseExpression)) || elseKind == ConditionalKind.NULL) {
                return thenKind;
            }
            if (thenKind == ConditionalKind.NULL) {
                return elseKind;
            }
        }
        return null;
    }

    @Nullable
    private static ConditionalKind isBooleanOrNumericType(PsiType type2) {
        if (type2 == PsiType.NULL) {
            return ConditionalKind.NULL;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type2);
        if (TypeConversionUtil.isNumericType(type2)) {
            return ConditionalKind.NUMERIC;
        }
        if (TypeConversionUtil.isBooleanType(type2)) {
            return ConditionalKind.BOOLEAN;
        }
        if (psiClass instanceof PsiTypeParameter) {
            for (PsiClassType classType : psiClass.getExtendsListTypes()) {
                ConditionalKind kind = PsiPolyExpressionUtil.isBooleanOrNumericType(classType);
                if (kind == null) continue;
                return kind;
            }
        }
        return null;
    }

    private static enum ConditionalKind {
        BOOLEAN,
        NUMERIC,
        NULL;

    }
}

