/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.util.concurrent.Atomics;
import org.jetbrains.kotlin.com.intellij.injected.editor.DocumentWindow;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.LanguageUtil;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.command.undo.UndoConstants;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.PlainTextLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.NonPhysicalFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.PersistentFSConstants;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VFileProperty;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiFileEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiBinaryFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiLargeFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.FileManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.LocalTimeCounter;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class SingleRootFileViewProvider
extends UserDataHolderBase
implements FileViewProvider {
    private static final Key<Boolean> OUR_NO_SIZE_LIMIT_KEY = Key.create("no.size.limit");
    private static final Logger LOG = Logger.getInstance("#" + SingleRootFileViewProvider.class.getCanonicalName());
    public static final Key<Object> FREE_THREADED = Key.create("FREE_THREADED");
    @NotNull
    private final PsiManager myManager;
    @NotNull
    private final VirtualFile myVirtualFile;
    private final boolean myEventSystemEnabled;
    private final boolean myPhysical;
    private final AtomicReference<PsiFile> myPsiFile;
    private volatile Content myContent;
    private volatile Reference<Document> myDocument;
    @NotNull
    private final Language myBaseLanguage;
    @NotNull
    private final FileType myFileType;

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        this(manager, file2, true);
    }

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        this(manager, virtualFile, eventSystemEnabled, virtualFile.getFileType());
    }

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull FileType fileType) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        this(manager, virtualFile, eventSystemEnabled, SingleRootFileViewProvider.calcBaseLanguage(virtualFile, manager.getProject(), fileType), fileType);
    }

    protected SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language language) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        this(manager, virtualFile, eventSystemEnabled, language, virtualFile.getFileType());
    }

    protected SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language language, @NotNull FileType type2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        this.myPsiFile = Atomics.newReference();
        this.myManager = manager;
        this.myVirtualFile = virtualFile;
        this.myEventSystemEnabled = eventSystemEnabled;
        this.myBaseLanguage = language;
        this.setContent(new VirtualFileContent());
        boolean bl = this.myPhysical = this.isEventSystemEnabled() && !(virtualFile instanceof LightVirtualFile) && !(virtualFile.getFileSystem() instanceof NonPhysicalFileSystem);
        if (virtualFile instanceof LightVirtualFile && !this.isEventSystemEnabled()) {
            virtualFile.putUserData(FREE_THREADED, true);
        }
        this.myFileType = type2;
    }

    @Override
    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myBaseLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getBaseLanguage"));
        }
        return language;
    }

    private static Language calcBaseLanguage(@NotNull VirtualFile file2, @NotNull Project project, @NotNull FileType fileType) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "calcBaseLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "calcBaseLanguage"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "calcBaseLanguage"));
        }
        if (fileType.isBinary()) {
            return Language.ANY;
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2)) {
            return PlainTextLanguage.INSTANCE;
        }
        Language language = LanguageUtil.getLanguageForPsi(project, file2);
        return language != null ? language : PlainTextLanguage.INSTANCE;
    }

    @Override
    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = Collections.singleton(this.getBaseLanguage());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getLanguages"));
        }
        return set;
    }

    @Override
    @Nullable
    public final PsiFile getPsi(@NotNull Language target) {
        VirtualFile virtualFile;
        FileManager fileManager;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getPsi"));
        }
        if (!this.isPhysical() && (fileManager = ((PsiManagerEx)this.myManager).getFileManager()).findCachedViewProvider(virtualFile = this.getVirtualFile()) == null) {
            fileManager.setViewProvider(virtualFile, this);
        }
        return this.getPsiInner(target);
    }

    @Override
    @NotNull
    public List<PsiFile> getAllFiles() {
        List<PsiFile> list2 = ContainerUtil.createMaybeSingletonList(this.getPsi(this.getBaseLanguage()));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getAllFiles"));
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected PsiFile getPsiInner(@NotNull Language target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getPsiInner"));
        }
        if (target != this.getBaseLanguage()) {
            return null;
        }
        PsiFile psiFile = this.myPsiFile.get();
        if (psiFile == null) {
            boolean set;
            psiFile = this.createFile();
            if (psiFile == null) {
                psiFile = PsiUtilCore.NULL_PSI_FILE;
            }
            if (!(set = this.myPsiFile.compareAndSet(null, psiFile)) && psiFile != PsiUtilCore.NULL_PSI_FILE) {
                PsiFile alreadyCreated = this.myPsiFile.get();
                if (alreadyCreated == psiFile) {
                    LOG.error(this + ".createFile() must create new file instance but got the same: " + psiFile);
                }
                if (psiFile instanceof PsiFileEx) {
                    DebugUtil.startPsiModification("invalidating throw-away copy");
                    try {
                        ((PsiFileEx)psiFile).markInvalidated();
                    }
                    finally {
                        DebugUtil.finishPsiModification();
                    }
                }
                psiFile = alreadyCreated;
            }
        }
        return psiFile == PsiUtilCore.NULL_PSI_FILE ? null : psiFile;
    }

    @Override
    public void beforeContentsSynchronized() {
    }

    @Override
    public void contentsSynchronized() {
        if (this.myContent instanceof PsiFileContent) {
            this.setContent(new VirtualFileContent());
        }
        this.checkLengthConsistency();
    }

    public void beforeDocumentChanged(@Nullable PsiFile psiCause) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = psiCause != null ? psiCause : this.getPsi(this.getBaseLanguage());
        if (psiFile instanceof PsiFileImpl && this.myContent instanceof VirtualFileContent) {
            this.setContent(new PsiFileContent((PsiFileImpl)psiFile, psiCause == null ? this.getModificationStamp() : LocalTimeCounter.currentTime()));
            this.checkLengthConsistency();
        }
    }

    public final void onContentReload() {
        List<PsiFile> files2 = this.getCachedPsiFiles();
        ArrayList<PsiTreeChangeEventImpl> events = ContainerUtil.newArrayList();
        ArrayList<PsiTreeChangeEventImpl> genericEvents = ContainerUtil.newArrayList();
        for (PsiFile file2 : files2) {
            genericEvents.add(this.createChildrenChangeEvent(file2, true));
            events.add(this.createChildrenChangeEvent(file2, false));
        }
        this.beforeContentsSynchronized();
        for (PsiTreeChangeEventImpl event : genericEvents) {
            ((PsiManagerImpl)this.getManager()).beforeChildrenChange(event);
        }
        for (PsiTreeChangeEventImpl event : events) {
            ((PsiManagerImpl)this.getManager()).beforeChildrenChange(event);
        }
        for (PsiFile psiFile : files2) {
            if (!(psiFile instanceof PsiFileEx)) continue;
            ((PsiFileEx)psiFile).onContentReload();
        }
        for (PsiTreeChangeEventImpl event : events) {
            ((PsiManagerImpl)this.getManager()).childrenChanged(event);
        }
        for (PsiTreeChangeEventImpl event : genericEvents) {
            ((PsiManagerImpl)this.getManager()).childrenChanged(event);
        }
        this.contentsSynchronized();
    }

    private PsiTreeChangeEventImpl createChildrenChangeEvent(PsiFile file2, boolean generic) {
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        event.setParent(file2);
        event.setFile(file2);
        event.setGenericChange(generic);
        if (file2 instanceof PsiFileImpl && ((PsiFileImpl)file2).isContentsLoaded()) {
            event.setOffset(0);
            event.setOldLength(file2.getTextLength());
        }
        return event;
    }

    @Override
    public void rootChanged(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "rootChanged"));
        }
        if (psiFile instanceof PsiFileImpl && ((PsiFileImpl)psiFile).isContentsLoaded()) {
            this.setContent(new PsiFileContent((PsiFileImpl)psiFile, LocalTimeCounter.currentTime()));
        }
    }

    @Override
    public boolean isEventSystemEnabled() {
        return this.myEventSystemEnabled;
    }

    @Override
    public boolean isPhysical() {
        return this.myPhysical;
    }

    @Override
    public long getModificationStamp() {
        return this.getContent().getModificationStamp();
    }

    @Override
    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootLanguage", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "supportsIncrementalReparse"));
        }
        return true;
    }

    public PsiFile getCachedPsi(@NotNull Language target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getCachedPsi"));
        }
        PsiFile file2 = this.myPsiFile.get();
        return file2 == PsiUtilCore.NULL_PSI_FILE ? null : file2;
    }

    public List<PsiFile> getCachedPsiFiles() {
        return ContainerUtil.createMaybeSingletonList(this.getCachedPsi(this.myBaseLanguage));
    }

    @NotNull
    public List<FileElement> getKnownTreeRoots() {
        PsiFile psiFile = this.getCachedPsi(this.myBaseLanguage);
        if (!(psiFile instanceof PsiFileImpl)) {
            List<FileElement> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getKnownTreeRoots"));
            }
            return list2;
        }
        FileElement element = ((PsiFileImpl)psiFile).getTreeElement();
        List<FileElement> list3 = ContainerUtil.createMaybeSingletonList(element);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getKnownTreeRoots"));
        }
        return list3;
    }

    private PsiFile createFile() {
        try {
            VirtualFile vFile = this.getVirtualFile();
            if (vFile.isDirectory()) {
                return null;
            }
            if (this.isIgnored()) {
                return null;
            }
            Project project = this.myManager.getProject();
            if (this.isPhysical() && vFile.isInLocalFileSystem()) {
                FileIndexFacade indexFacade;
                VirtualFile parent2 = vFile.getParent();
                if (parent2 == null) {
                    return null;
                }
                PsiDirectory psiDir = this.getManager().findDirectory(parent2);
                if (psiDir == null && !(indexFacade = FileIndexFacade.getInstance(project)).isInLibrarySource(vFile) && !indexFacade.isInLibraryClasses(vFile)) {
                    return null;
                }
            }
            return this.createFile(project, vFile, this.myFileType);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
    }

    protected boolean isIgnored() {
        VirtualFile file2 = this.getVirtualFile();
        return !(file2 instanceof LightVirtualFile) && FileTypeRegistry.getInstance().isFileIgnored(file2);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull FileType fileType) {
        PsiFile psiFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "createFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "createFile"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "createFile"));
        }
        if (fileType.isBinary() || file2.is(VFileProperty.SPECIAL)) {
            return new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        if (!SingleRootFileViewProvider.isTooLargeForIntelligence(file2) && (psiFile = this.createFile(this.getBaseLanguage())) != null) {
            return psiFile;
        }
        if (SingleRootFileViewProvider.isTooLargeForContentLoading(file2)) {
            return new PsiLargeFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        return new PsiPlainTextFileImpl(this);
    }

    @Deprecated
    public static boolean isTooLarge(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "isTooLarge"));
        }
        return SingleRootFileViewProvider.isTooLargeForIntelligence(vFile);
    }

    public static boolean isTooLargeForIntelligence(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "isTooLargeForIntelligence"));
        }
        if (!SingleRootFileViewProvider.checkFileSizeLimit(vFile)) {
            return false;
        }
        return SingleRootFileViewProvider.fileSizeIsGreaterThan(vFile, PersistentFSConstants.getMaxIntellisenseFileSize());
    }

    public static boolean isTooLargeForContentLoading(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "isTooLargeForContentLoading"));
        }
        return SingleRootFileViewProvider.fileSizeIsGreaterThan(vFile, PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD);
    }

    private static boolean checkFileSizeLimit(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "checkFileSizeLimit"));
        }
        return !Boolean.TRUE.equals(vFile.getUserData(OUR_NO_SIZE_LIMIT_KEY));
    }

    public static void doNotCheckFileSizeLimit(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "doNotCheckFileSizeLimit"));
        }
        vFile.putUserData(OUR_NO_SIZE_LIMIT_KEY, Boolean.TRUE);
    }

    public static boolean isTooLargeForIntelligence(@NotNull VirtualFile vFile, long contentSize) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "isTooLargeForIntelligence"));
        }
        if (!SingleRootFileViewProvider.checkFileSizeLimit(vFile)) {
            return false;
        }
        return contentSize > (long)PersistentFSConstants.getMaxIntellisenseFileSize();
    }

    public static boolean isTooLargeForContentLoading(@NotNull VirtualFile vFile, long contentSize) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "isTooLargeForContentLoading"));
        }
        return contentSize > PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD;
    }

    public static boolean fileSizeIsGreaterThan(@NotNull VirtualFile vFile, long maxBytes) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "fileSizeIsGreaterThan"));
        }
        if (vFile instanceof LightVirtualFile) {
            int lengthInChars = ((LightVirtualFile)vFile).getContent().length();
            if ((long)lengthInChars < maxBytes / 2L) {
                return false;
            }
            if ((long)lengthInChars > maxBytes) {
                return true;
            }
        }
        return vFile.getLength() > maxBytes;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "createFile"));
        }
        if (lang != this.getBaseLanguage()) {
            return null;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createFile(this);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myManager;
        if (psiManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getManager"));
        }
        return psiManager;
    }

    @Override
    @NotNull
    public CharSequence getContents() {
        CharSequence charSequence = this.getContent().getText();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getContents"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Nullable
    private Document getCachedDocument() {
        Document document = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(this.myDocument);
        if (document != null) {
            return document;
        }
        return FileDocumentManager.getInstance().getCachedDocument(this.getVirtualFile());
    }

    @Override
    public Document getDocument() {
        Document document = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(this.myDocument);
        if (document == null) {
            document = FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
            this.myDocument = document == null ? null : new SoftReference<Document>(document);
        }
        return document;
    }

    @Override
    public FileViewProvider clone() {
        VirtualFile origFile = this.getVirtualFile();
        LightVirtualFile copy = new LightVirtualFile(origFile.getName(), this.myFileType, this.getContents(), origFile.getCharset(), this.getModificationStamp());
        copy.setOriginalFile(origFile);
        copy.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
        copy.setCharset(origFile.getCharset());
        return this.createCopy(copy);
    }

    @Override
    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "createCopy"));
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.getManager(), copy, false, this.myBaseLanguage);
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "createCopy"));
        }
        return singleRootFileViewProvider;
    }

    @Override
    public PsiReference findReferenceAt(int offset2) {
        PsiFile psiFile = this.getPsi(this.getBaseLanguage());
        return SingleRootFileViewProvider.findReferenceAt(psiFile, offset2);
    }

    @Override
    public PsiElement findElementAt(int offset2, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "findElementAt"));
        }
        PsiFile psiFile = this.getPsi(language);
        return psiFile != null ? SingleRootFileViewProvider.findElementAt(psiFile, offset2) : null;
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset2, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "findReferenceAt"));
        }
        PsiFile psiFile = this.getPsi(language);
        return psiFile != null ? SingleRootFileViewProvider.findReferenceAt(psiFile, offset2) : null;
    }

    @Nullable
    protected static PsiReference findReferenceAt(@Nullable PsiFile psiFile, int offset2) {
        if (psiFile == null) {
            return null;
        }
        int offsetInElement = offset2;
        for (PsiElement child = psiFile.getFirstChild(); child != null; child = child.getNextSibling()) {
            int length = child.getTextLength();
            if (length <= offsetInElement) {
                offsetInElement -= length;
                continue;
            }
            return child.findReferenceAt(offsetInElement);
        }
        return null;
    }

    @Override
    public PsiElement findElementAt(int offset2) {
        return SingleRootFileViewProvider.findElementAt(this.getPsi(this.getBaseLanguage()), offset2);
    }

    @Override
    public PsiElement findElementAt(int offset2, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "findElementAt"));
        }
        if (!ReflectionUtil.isAssignable(lang, this.getBaseLanguage().getClass())) {
            return null;
        }
        return this.findElementAt(offset2);
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable PsiElement psiFile, int offset2) {
        if (psiFile == null) {
            return null;
        }
        int offsetInElement = offset2;
        for (PsiElement child = psiFile.getFirstChild(); child != null; child = child.getNextSibling()) {
            int length = child.getTextLength();
            if (length <= offsetInElement) {
                offsetInElement -= length;
                continue;
            }
            return child.findElementAt(offsetInElement);
        }
        return null;
    }

    public void forceCachedPsi(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "forceCachedPsi"));
        }
        PsiFile prev = this.myPsiFile.getAndSet(psiFile);
        if (prev != null && prev != psiFile && prev instanceof PsiFileEx) {
            ((PsiFileEx)prev).markInvalidated();
        }
        ((PsiManagerEx)this.myManager).getFileManager().setViewProvider(this.getVirtualFile(), this);
    }

    @NotNull
    private Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getContent"));
        }
        return content;
    }

    private void setContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "setContent"));
        }
        this.myContent = content;
    }

    private void checkLengthConsistency() {
        Document document = this.getCachedDocument();
        if (document instanceof DocumentWindow) {
            return;
        }
        if (document != null && ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myManager.getProject())).getSynchronizer().isInSynchronization(document)) {
            return;
        }
        List<FileElement> knownTreeRoots = this.getKnownTreeRoots();
        if (knownTreeRoots.isEmpty()) {
            return;
        }
        int fileLength = this.myContent.getTextLength();
        for (FileElement fileElement : knownTreeRoots) {
            int nodeLength = fileElement.getTextLength();
            if (nodeLength == fileLength) continue;
            LOG.error("Inconsistent " + fileElement.getElementType() + " tree in " + this + "; nodeLength=" + nodeLength + "; fileLength=" + fileLength);
        }
    }

    @NonNls
    public String toString() {
        return this.getClass().getSimpleName() + "{myVirtualFile=" + this.myVirtualFile + ", content=" + this.getContent() + '}';
    }

    public void markInvalidated() {
        PsiFile psiFile = this.getCachedPsi(this.myBaseLanguage);
        if (psiFile instanceof PsiFileEx) {
            ((PsiFileEx)psiFile).markInvalidated();
        }
    }

    private CharSequence getLastCommittedText(Document document) {
        return PsiDocumentManager.getInstance(this.myManager.getProject()).getLastCommittedText(document);
    }

    private long getLastCommittedStamp(Document document) {
        return PsiDocumentManager.getInstance(this.myManager.getProject()).getLastCommittedStamp(document);
    }

    @Override
    @NotNull
    public PsiFile getStubBindingRoot() {
        PsiFile psi = this.getPsi(this.getBaseLanguage());
        assert (psi != null);
        PsiFile psiFile = psi;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getStubBindingRoot"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    public final FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/SingleRootFileViewProvider", "getFileType"));
        }
        return fileType;
    }

    private class PsiFileContent
    implements Content {
        private final PsiFileImpl myFile;
        private volatile String myContent;
        private final long myModificationStamp;
        private final List<FileElement> myFileElementHardRefs = new SmartList<FileElement>();

        private PsiFileContent(PsiFileImpl file2, long modificationStamp) {
            this.myFile = file2;
            this.myModificationStamp = modificationStamp;
            for (PsiFile aFile : SingleRootFileViewProvider.this.getAllFiles()) {
                if (!(aFile instanceof PsiFileImpl)) continue;
                this.myFileElementHardRefs.add(((PsiFileImpl)aFile).calcTreeElement());
            }
        }

        @Override
        public CharSequence getText() {
            String content = this.myContent;
            if (content == null) {
                this.myContent = content = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

                    @Override
                    public String compute() {
                        return PsiFileContent.this.myFile.calcTreeElement().getText();
                    }
                });
            }
            return content;
        }

        @Override
        public int getTextLength() {
            String content = this.myContent;
            if (content != null) {
                return content.length();
            }
            return this.myFile.calcTreeElement().getTextLength();
        }

        @Override
        public long getModificationStamp() {
            return this.myModificationStamp;
        }
    }

    private class VirtualFileContent
    implements Content {
        private VirtualFileContent() {
        }

        @Override
        public CharSequence getText() {
            VirtualFile virtualFile = SingleRootFileViewProvider.this.getVirtualFile();
            if (virtualFile instanceof LightVirtualFile) {
                Document doc = SingleRootFileViewProvider.this.getCachedDocument();
                if (doc != null) {
                    return SingleRootFileViewProvider.this.getLastCommittedText(doc);
                }
                return ((LightVirtualFile)virtualFile).getContent();
            }
            Document document = SingleRootFileViewProvider.this.getDocument();
            if (document == null) {
                return LoadTextUtil.loadText(virtualFile);
            }
            return SingleRootFileViewProvider.this.getLastCommittedText(document);
        }

        @Override
        public int getTextLength() {
            return this.getText().length();
        }

        @Override
        public long getModificationStamp() {
            Document document = SingleRootFileViewProvider.this.getCachedDocument();
            if (document == null) {
                return SingleRootFileViewProvider.this.getVirtualFile().getModificationStamp();
            }
            return SingleRootFileViewProvider.this.getLastCommittedStamp(document);
        }

        @NonNls
        public String toString() {
            return "VirtualFileContent{size=" + SingleRootFileViewProvider.this.getVirtualFile().getLength() + "}";
        }
    }

    private static interface Content {
        public CharSequence getText();

        public int getTextLength();

        public long getModificationStamp();
    }
}

