/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "functionResolver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lkotlin/jvm/functions/Function1;)V", "getFunctionDescriptor", "findMainFunction", "declarations", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getMainFunction", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "hasMain", "", "isMain", "function", "Companion", "kotlin-compiler"})
public final class MainFunctionDetector {
    private final Function1<KtNamedFunction, FunctionDescriptor> getFunctionDescriptor;
    public static final Companion Companion = new Companion(null);

    public final boolean hasMain(@NotNull List<? extends KtDeclaration> declarations) {
        Intrinsics.checkParameterIsNotNull(declarations, "declarations");
        return this.findMainFunction(declarations) != null;
    }

    public final boolean isMain(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        if (function.isLocal()) {
            return false;
        }
        if (function.getValueParameters().size() != 1 || !function.getTypeParameters().isEmpty()) {
            return false;
        }
        if (Intrinsics.areEqual("main", function.getName()) ^ true && !MainFunctionDetector.Companion.hasAnnotationWithExactNumberOfArguments(function, 1)) {
            return false;
        }
        if (!function.isTopLevel() && !MainFunctionDetector.Companion.hasAnnotationWithExactNumberOfArguments(function, 0)) {
            return false;
        }
        return Companion.isMain(this.getFunctionDescriptor.invoke(function));
    }

    @Nullable
    public final KtNamedFunction getMainFunction(@NotNull Collection<? extends KtFile> files2) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull(files2, "files");
            Sequence $receiver$iv = SequencesKt.map(CollectionsKt.asSequence((Iterable)files2), (Function1)new Function1<KtFile, KtNamedFunction>(this){
                final /* synthetic */ MainFunctionDetector this$0;

                @Nullable
                public final KtNamedFunction invoke(@NotNull KtFile it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    List<KtDeclaration> list2 = it.getDeclarations();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "it.declarations");
                    return MainFunctionDetector.access$findMainFunction(this.this$0, list2);
                }
                {
                    this.this$0 = mainFunctionDetector;
                    super(1);
                }
            });
            Iterator iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                KtNamedFunction it = (KtNamedFunction)element$iv;
                if (!(it != null)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final KtNamedFunction findMainFunction(List<? extends KtDeclaration> declarations) {
        Iterator<Object> iterator2;
        block2: {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = declarations;
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            iterable = iterable2;
            for (Iterator<Object> iterator3 : iterable) {
                KtNamedFunction it = (KtNamedFunction)((Object)iterator3);
                if (!this.isMain(it)) continue;
                iterator2 = iterator3;
                break block2;
            }
            iterator2 = null;
        }
        return (KtNamedFunction)((Object)iterator2);
    }

    public MainFunctionDetector(final @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        this.getFunctionDescriptor = new Function1<KtNamedFunction, FunctionDescriptor>(){

            @Override
            @NotNull
            public final FunctionDescriptor invoke(@NotNull KtNamedFunction function) {
                Intrinsics.checkParameterIsNotNull(function, "function");
                SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)bindingContext.get(BindingContext.FUNCTION, function);
                if (simpleFunctionDescriptor == null) {
                    throw (Throwable)new IllegalStateException("No descriptor resolved for " + function + " " + function.getText());
                }
                return simpleFunctionDescriptor;
            }
        };
    }

    public MainFunctionDetector(@NotNull Function1<? super KtNamedFunction, ? extends FunctionDescriptor> functionResolver) {
        Intrinsics.checkParameterIsNotNull(functionResolver, "functionResolver");
        this.getFunctionDescriptor = functionResolver;
    }

    @Nullable
    public static final /* synthetic */ KtNamedFunction access$findMainFunction(MainFunctionDetector $this, @NotNull List declarations) {
        return $this.findMainFunction(declarations);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Companion;", "", "()V", "getJVMFunctionName", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "hasAnnotationWithExactNumberOfArguments", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "number", "", "isMain", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kotlin-compiler"})
    public static final class Companion {
        public final boolean isMain(@NotNull DeclarationDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            if (!(descriptor2 instanceof FunctionDescriptor)) {
                return false;
            }
            if (Intrinsics.areEqual(this.getJVMFunctionName((FunctionDescriptor)descriptor2), "main") ^ true) {
                return false;
            }
            List<ValueParameterDescriptor> parameters2 = ((FunctionDescriptor)descriptor2).getValueParameters();
            if (parameters2.size() != 1 || !((FunctionDescriptor)descriptor2).getTypeParameters().isEmpty()) {
                return false;
            }
            ValueParameterDescriptor parameter = parameters2.get(0);
            KotlinType parameterType = parameter.getType();
            if (!KotlinBuiltIns.isArray(parameterType)) {
                return false;
            }
            List<TypeProjection> typeArguments2 = parameterType.getArguments();
            if (typeArguments2.size() != 1) {
                return false;
            }
            KotlinType typeArgument = typeArguments2.get(0).getType();
            if (!KotlinBuiltIns.isString(typeArgument)) {
                return false;
            }
            if (typeArguments2.get(0).getProjectionKind() == Variance.IN_VARIANCE) {
                return false;
            }
            KotlinType returnType2 = ((FunctionDescriptor)descriptor2).getReturnType();
            if (returnType2 == null || !KotlinBuiltIns.isUnit(returnType2)) {
                return false;
            }
            if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
                return true;
            }
            DeclarationDescriptor containingDeclaration = ((FunctionDescriptor)descriptor2).getContainingDeclaration();
            return containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind().isSingleton() && AnnotationUtilKt.hasJvmStaticAnnotation(descriptor2);
        }

        private final String getJVMFunctionName(FunctionDescriptor functionDescriptor) {
            String string = DescriptorUtils.getJvmName(functionDescriptor);
            if (string == null) {
                String string2 = functionDescriptor.getName().asString();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull(string2, "functionDescriptor.name.asString()");
            }
            return string;
        }

        private final boolean hasAnnotationWithExactNumberOfArguments(KtNamedFunction function, int number) {
            boolean bl;
            block1: {
                Iterable $receiver$iv = function.getAnnotationEntries();
                for (Object element$iv : $receiver$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    if (!(it.getValueArguments().size() == number)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

