/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.BulkFileListener;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import org.jetbrains.kotlin.gnu.trove.THashSet;

public class FileContentUtilCore {
    public static void reparseFiles(VirtualFile ... files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/com/intellij/util/FileContentUtilCore", "reparseFiles"));
        }
        FileContentUtilCore.reparseFiles(Arrays.asList(files2));
    }

    public static void reparseFiles(final @NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/com/intellij/util/FileContentUtilCore", "reparseFiles"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                THashSet events = new THashSet();
                for (VirtualFile file : files2) {
                    FileContentUtilCore.saveOrReload(file, events);
                }
                BulkFileListener publisher = ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
                ArrayList eventList = new ArrayList(events);
                publisher.before(eventList);
                publisher.after(eventList);
            }
        });
    }

    private static void saveOrReload(VirtualFile file, @NotNull Collection<VFilePropertyChangeEvent> events) {
        Document document;
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/kotlin/com/intellij/util/FileContentUtilCore", "saveOrReload"));
        }
        if (file == null || file.isDirectory() || !file.isValid()) {
            return;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        if (documentManager.isFileModified(file) && (document = documentManager.getDocument(file)) != null) {
            documentManager.saveDocumentAsIs(document);
        }
        events.add(new VFilePropertyChangeEvent("FileContentUtilCore.saveOrReload", file, "name", file.getName(), file.getName(), false));
    }
}

