/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageExtension;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.LanguageSubstitutor;

public final class LanguageSubstitutors
extends LanguageExtension<LanguageSubstitutor> {
    public static final LanguageSubstitutors INSTANCE = new LanguageSubstitutors();

    private LanguageSubstitutors() {
        super("org.jetbrains.kotlin.com.intellij.lang.substitutor");
    }

    @NotNull
    public Language substituteLanguage(@NotNull Language lang, @NotNull VirtualFile file, @NotNull Project project) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        for (LanguageSubstitutor substitutor2 : this.forKey(lang)) {
            Language language = substitutor2.getLanguage(file, project);
            if (language == null) continue;
            Language language2 = language;
            if (language2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
            }
            return language2;
        }
        Language language = lang;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        return language;
    }
}

