/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.com.google.dart.compiler.util.AstUtil;

public final class JsIf
extends SourceInfoAwareJsNode
implements JsStatement {
    @NotNull
    private JsExpression ifExpression;
    @NotNull
    private JsStatement thenStatement;
    @Nullable
    private JsStatement elseStatement;

    public JsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement, @Nullable JsStatement elseStatement) {
        if (ifExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifExpression", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsIf", "<init>"));
        }
        if (thenStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenStatement", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsIf", "<init>"));
        }
        this.ifExpression = ifExpression;
        this.thenStatement = thenStatement;
        this.elseStatement = elseStatement;
    }

    public JsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement) {
        if (ifExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifExpression", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsIf", "<init>"));
        }
        if (thenStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenStatement", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsIf", "<init>"));
        }
        this(ifExpression, thenStatement, null);
    }

    @Nullable
    public JsStatement getElseStatement() {
        return this.elseStatement;
    }

    @NotNull
    public JsExpression getIfExpression() {
        JsExpression jsExpression = this.ifExpression;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsIf", "getIfExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public JsStatement getThenStatement() {
        JsStatement jsStatement = this.thenStatement;
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsIf", "getThenStatement"));
        }
        return jsStatement;
    }

    public void setElseStatement(@Nullable JsStatement elseStatement) {
        this.elseStatement = elseStatement;
    }

    public void setIfExpression(@NotNull JsExpression ifExpression) {
        if (ifExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifExpression", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsIf", "setIfExpression"));
        }
        this.ifExpression = ifExpression;
    }

    public void setThenStatement(@NotNull JsStatement thenStatement) {
        if (thenStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenStatement", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsIf", "setThenStatement"));
        }
        this.thenStatement = thenStatement;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitIf(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.ifExpression);
        visitor2.accept(this.thenStatement);
        if (this.elseStatement != null) {
            visitor2.accept(this.elseStatement);
        }
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.ifExpression = v.accept(this.ifExpression);
            this.thenStatement = v.acceptStatement(this.thenStatement);
            if (this.elseStatement != null) {
                this.elseStatement = v.acceptStatement(this.elseStatement);
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsIf deepCopy() {
        JsExpression ifCopy = AstUtil.deepCopy(this.ifExpression);
        JsStatement thenCopy = AstUtil.deepCopy(this.thenStatement);
        JsStatement elseCopy = AstUtil.deepCopy(this.elseStatement);
        JsIf jsIf = new JsIf(ifCopy, thenCopy, elseCopy).withMetadataFrom(this);
        if (jsIf == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsIf", "deepCopy"));
        }
        return jsIf;
    }
}

