/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class SamWrapperCodegen {
    private final GenerationState state;
    private final boolean isInsideInline;
    private final KotlinTypeMapper typeMapper;
    private final SamType samType;
    private final MemberCodegen<?> parentCodegen;
    private final int visibility;

    public SamWrapperCodegen(@NotNull GenerationState state2, @NotNull SamType samType, @NotNull MemberCodegen<?> parentCodegen, boolean isInsideInline) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/SamWrapperCodegen", "<init>"));
        }
        if (samType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samType", "org/jetbrains/kotlin/codegen/SamWrapperCodegen", "<init>"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/SamWrapperCodegen", "<init>"));
        }
        this.state = state2;
        this.isInsideInline = isInsideInline;
        this.typeMapper = state2.getTypeMapper();
        this.samType = samType;
        this.parentCodegen = parentCodegen;
        this.visibility = isInsideInline ? 1 : 0;
    }

    @NotNull
    public Type genWrapper(@NotNull KtFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/codegen/SamWrapperCodegen", "genWrapper"));
        }
        FqName fqName2 = this.getWrapperName(file);
        Type asmType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fqName2);
        KotlinType functionType = this.samType.getKotlinFunctionType();
        ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl(this.samType.getJavaClassDescriptor().getContainingDeclaration(), fqName2.shortName(), Modality.FINAL, ClassKind.CLASS, Collections.singleton(this.samType.getType()), SourceElement.NO_SOURCE);
        SimpleFunctionDescriptor erasedInterfaceFunction = this.samType.getAbstractMethod().getOriginal().copy(classDescriptor, Modality.FINAL, Visibilities.PUBLIC, CallableMemberDescriptor.Kind.SYNTHESIZED, false);
        ClassBuilder cv = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(erasedInterfaceFunction), asmType, file);
        cv.defineClass(file, 50, 0x30 | this.visibility, asmType.getInternalName(), null, AsmTypes.OBJECT_TYPE.getInternalName(), new String[]{this.typeMapper.mapType(this.samType.getType()).getInternalName()});
        cv.visitSource(file.getName(), null);
        WriteAnnotationUtilKt.writeSyntheticClassMetadata(cv, this.state);
        Type functionAsmType = this.typeMapper.mapType(functionType);
        cv.newField(JvmDeclarationOriginKt.OtherOrigin(erasedInterfaceFunction), 4114, "function", functionAsmType.getDescriptor(), null, null);
        this.generateConstructor(asmType, functionAsmType, cv);
        this.generateMethod(asmType, functionAsmType, cv, erasedInterfaceFunction, functionType);
        cv.done();
        Type type2 = asmType;
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/SamWrapperCodegen", "genWrapper"));
        }
        return type2;
    }

    private void generateConstructor(Type ownerType, Type functionType, ClassBuilder cv) {
        MethodVisitor mv = cv.newMethod(JvmDeclarationOriginKt.OtherOrigin(this.samType.getJavaClassDescriptor()), this.visibility, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, functionType), null, null);
        if (this.state.getClassBuilderMode().generateBodies) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, AsmTypes.OBJECT_TYPE);
            iv.invokespecial(AsmTypes.OBJECT_TYPE.getInternalName(), "<init>", "()V", false);
            iv.load(0, AsmTypes.OBJECT_TYPE);
            iv.load(1, functionType);
            iv.putfield(ownerType.getInternalName(), "function", functionType.getDescriptor());
            iv.visitInsn(177);
            FunctionCodegen.endVisit(iv, "constructor of SAM wrapper", null);
        }
    }

    private void generateMethod(Type ownerType, Type functionType, ClassBuilder cv, SimpleFunctionDescriptor erasedInterfaceFunction, KotlinType functionJetType) {
        FunctionCodegen codegen = new FunctionCodegen(this.state.getRootContext().intoClass((ClassDescriptor)erasedInterfaceFunction.getContainingDeclaration(), OwnerKind.IMPLEMENTATION, this.state), cv, this.state, this.parentCodegen);
        SimpleFunctionDescriptor invokeFunction = functionJetType.getMemberScope().getContributedFunctions(OperatorNameConventions.INVOKE, NoLookupLocation.FROM_BACKEND).iterator().next().getOriginal();
        StackValue.Field functionField = StackValue.field(functionType, ownerType, "function", false, StackValue.none());
        codegen.genSamDelegate(erasedInterfaceFunction, invokeFunction, functionField);
        SimpleFunctionDescriptor originalInterfaceErased = this.samType.getAbstractMethod().getOriginal();
        SimpleFunctionDescriptorImpl descriptorForBridges = SimpleFunctionDescriptorImpl.create(erasedInterfaceFunction.getContainingDeclaration(), erasedInterfaceFunction.getAnnotations(), originalInterfaceErased.getName(), CallableMemberDescriptor.Kind.DECLARATION, erasedInterfaceFunction.getSource());
        descriptorForBridges.initialize((KotlinType)null, originalInterfaceErased.getDispatchReceiverParameter(), originalInterfaceErased.getTypeParameters(), (List)originalInterfaceErased.getValueParameters(), originalInterfaceErased.getReturnType(), Modality.OPEN, originalInterfaceErased.getVisibility());
        DescriptorUtilsKt.setSingleOverridden(descriptorForBridges, originalInterfaceErased);
        codegen.generateBridges(descriptorForBridges);
    }

    @NotNull
    private FqName getWrapperName(@NotNull KtFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/codegen/SamWrapperCodegen", "getWrapperName"));
        }
        FqName fileClassFqName = JvmFileClassUtil.getFileClassInfoNoResolve(containingFile).getFileClassFqName();
        JavaClassDescriptor descriptor2 = this.samType.getJavaClassDescriptor();
        int hash = PackagePartClassUtils.getPathHashCode(containingFile.getVirtualFile()) * 31 + DescriptorUtils.getFqNameSafe(descriptor2).hashCode();
        String shortName = String.format("%s$sam$%s%s$%08x", fileClassFqName.shortName().asString(), descriptor2.getName().asString(), this.isInsideInline ? "$i" : "", hash);
        FqName fqName2 = fileClassFqName.parent().child(Name.identifier(shortName));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/SamWrapperCodegen", "getWrapperName"));
        }
        return fqName2;
    }
}

