/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileLock;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.LibraryDef;

public class NativeLibraryLocator {
    private final File extractDir;

    public NativeLibraryLocator(File extractDir) {
        this.extractDir = extractDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File find(LibraryDef libraryDef) throws IOException {
        block10: {
            String resourceName = String.format("net/rubygrapefruit/platform/%s/%s", libraryDef.platform, libraryDef.name);
            if (this.extractDir != null) {
                File libFile = new File(this.extractDir, String.format("%s/%s/%s", 19, libraryDef.platform, libraryDef.name));
                File lockFile = new File(libFile.getParentFile(), libFile.getName() + ".lock");
                lockFile.getParentFile().mkdirs();
                lockFile.createNewFile();
                RandomAccessFile lockFileAccess = new RandomAccessFile(lockFile, "rw");
                try {
                    FileLock lock = lockFileAccess.getChannel().lock();
                    if (lockFile.length() > 0L && lockFileAccess.readBoolean()) {
                        File file = libFile;
                        return file;
                    }
                    URL resource = this.getClass().getClassLoader().getResource(resourceName);
                    if (resource != null) {
                        libFile.getParentFile().mkdirs();
                        NativeLibraryLocator.copy(resource, libFile);
                        lockFileAccess.seek(0L);
                        lockFileAccess.writeBoolean(true);
                        File file = libFile;
                        return file;
                    }
                    break block10;
                }
                finally {
                    lockFileAccess.close();
                }
            }
            URL resource = this.getClass().getClassLoader().getResource(resourceName);
            if (resource != null) {
                File libDir = File.createTempFile("native-platform", "dir");
                libDir.delete();
                libDir.mkdirs();
                File libFile = new File(libDir, libraryDef.name);
                libFile.deleteOnExit();
                NativeLibraryLocator.copy(resource, libFile);
                return libFile;
            }
        }
        String componentName = libraryDef.name.replaceFirst("^lib", "").replaceFirst("\\.\\w+$", "");
        int pos = componentName.indexOf("-");
        while (pos >= 0) {
            componentName = componentName.substring(0, pos) + Character.toUpperCase(componentName.charAt(pos + 1)) + componentName.substring(pos + 2);
            pos = componentName.indexOf("-", pos);
        }
        File libFile = new File(String.format("build/binaries/%sSharedLibrary/%s/%s", componentName, libraryDef.platform.replace("-", "_"), libraryDef.name));
        if (libFile.isFile()) {
            return libFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(URL source, File dest) {
        try {
            InputStream inputStream = source.openStream();
            try {
                FileOutputStream outputStream2 = new FileOutputStream(dest);
                try {
                    int nread;
                    byte[] buffer = new byte[4096];
                    while ((nread = inputStream.read(buffer)) >= 0) {
                        ((OutputStream)outputStream2).write(buffer, 0, nread);
                    }
                }
                finally {
                    ((OutputStream)outputStream2).close();
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not extract native JNI library.", new Object[0]), e);
        }
    }
}

