/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FunctionAnalyzerExtension;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00122\b\u0010\t\u001a\u0004\u0018\u00010\nJ \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension;", "Lorg/jetbrains/kotlin/resolve/FunctionAnalyzerExtension$AnalyzerExtension;", "()V", "checkDefaults", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkHasInlinableAndNullability", "checkInlinableParameter", "", "parameter", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkModalityAndOverrides", "process", "descriptor", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "kotlin-compiler"})
public final class InlineAnalyzerExtension
implements FunctionAnalyzerExtension.AnalyzerExtension {
    public static final InlineAnalyzerExtension INSTANCE;

    @Override
    public void process(@NotNull FunctionDescriptor descriptor2, @NotNull KtNamedFunction function, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        boolean bl = InlineUtil.isInline(descriptor2);
        if (_Assertions.ENABLED && !bl) {
            String string = "This method should be invoked on inline function: " + descriptor2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.checkDefaults(descriptor2, function, trace);
        this.checkModalityAndOverrides(descriptor2, function, trace);
        this.checkHasInlinableAndNullability(descriptor2, function, trace);
        KtVisitorVoid visitor2 = new KtVisitorVoid(trace, descriptor2){
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ FunctionDescriptor $descriptor;

            public void visitKtElement(@NotNull KtElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                super.visitKtElement(element);
                element.acceptChildren(this);
            }

            public void visitClass(@NotNull KtClass klass) {
                Intrinsics.checkParameterIsNotNull(klass, "klass");
                this.$trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtElement)((PsiElement)klass), klass, this.$descriptor));
            }

            public void visitNamedFunction(@NotNull KtNamedFunction function) {
                Intrinsics.checkParameterIsNotNull(function, "function");
                if (function.getParent().getParent() instanceof KtObjectDeclaration) {
                    super.visitNamedFunction(function);
                } else {
                    this.$trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtElement)((PsiElement)function), function, this.$descriptor));
                }
            }
            {
                this.$trace = $captured_local_variable$0;
                this.$descriptor = $captured_local_variable$1;
            }
        };
        function.acceptChildren(visitor2);
    }

    private final void checkDefaults(FunctionDescriptor functionDescriptor, KtFunction function, BindingTrace trace) {
        List<KtParameter> ktParameters = function.getValueParameters();
        for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
            if (!DescriptorUtilsKt.hasDefaultValue(parameter)) continue;
            KtParameter ktParameter = ktParameters.get(parameter.getIndex());
            ParameterDescriptor parameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull(parameterDescriptor, "parameter");
            KtElement ktElement = ktParameter;
            Intrinsics.checkExpressionValueIsNotNull(ktElement, "ktParameter");
            if (!this.checkInlinableParameter(parameterDescriptor, ktElement, functionDescriptor, null) && parameter.declaresDefaultValue()) continue;
            trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtElement)((PsiElement)ktParameter), ktParameter, functionDescriptor));
        }
    }

    private final void checkModalityAndOverrides(FunctionDescriptor functionDescriptor, KtFunction function, BindingTrace trace) {
        boolean overridesAnything;
        if (functionDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            return;
        }
        if (Visibilities.isPrivate(functionDescriptor.getVisibility())) {
            return;
        }
        Collection<? extends FunctionDescriptor> collection = functionDescriptor.getOverriddenDescriptors();
        boolean bl = overridesAnything = !collection.isEmpty();
        if (overridesAnything) {
            List<KtTypeParameter> ktTypeParameters = function.getTypeParameters();
            for (TypeParameterDescriptor typeParameter : functionDescriptor.getTypeParameters()) {
                if (!typeParameter.isReified()) continue;
                KtTypeParameter ktTypeParameter = ktTypeParameters.get(typeParameter.getIndex());
                PsiElement psiElement = ktTypeParameter.getModifierList();
                if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.REIFIED_KEYWORD)) == null) {
                    psiElement = ktTypeParameter;
                }
                PsiElement reportOn = psiElement;
                trace.report(Errors.REIFIED_TYPE_PARAMETER_IN_OVERRIDE.on(reportOn));
            }
        }
        if (Intrinsics.areEqual((Object)functionDescriptor.getModality(), (Object)Modality.FINAL)) {
            if (overridesAnything) {
                trace.report(Errors.OVERRIDE_BY_INLINE.on((KtDeclaration)((PsiElement)function)));
            }
            return;
        }
        trace.report(Errors.DECLARATION_CANT_BE_INLINED.on((KtDeclaration)((PsiElement)function)));
    }

    private final void checkHasInlinableAndNullability(FunctionDescriptor functionDescriptor, KtFunction function, BindingTrace trace) {
        boolean hasInlinable = false;
        List<ValueParameterDescriptor> parameters2 = functionDescriptor.getValueParameters();
        int index2 = 0;
        for (ValueParameterDescriptor parameter : parameters2) {
            ParameterDescriptor parameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull(parameterDescriptor, "parameter");
            KtElement ktElement = function.getValueParameters().get(index2++);
            Intrinsics.checkExpressionValueIsNotNull(ktElement, "function.valueParameters[index++]");
            hasInlinable |= this.checkInlinableParameter(parameterDescriptor, ktElement, functionDescriptor, trace);
        }
        if (!(hasInlinable |= InlineUtil.containsReifiedTypeParameters(functionDescriptor)) && !AnnotationUtilKt.isInlineOnlyOrReified(functionDescriptor)) {
            KtModifierList modifierList;
            KtModifierList ktModifierList = modifierList = function.getModifierList();
            PsiElement inlineModifier = ktModifierList != null ? ktModifierList.getModifier(KtTokens.INLINE_KEYWORD) : null;
            PsiElement psiElement = inlineModifier;
            if (psiElement == null) {
                psiElement = function;
            }
            PsiElement reportOn = psiElement;
            trace.report(Errors.NOTHING_TO_INLINE.on(reportOn, functionDescriptor));
        }
    }

    public final boolean checkInlinableParameter(@NotNull ParameterDescriptor parameter, @NotNull KtElement expression, @NotNull CallableDescriptor functionDescriptor, @Nullable BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        if (InlineUtil.isInlineLambdaParameter(parameter)) {
            if (parameter.getType().isMarkedNullable()) {
                BindingTrace bindingTrace = trace;
                if (bindingTrace != null) {
                    bindingTrace.report(Errors.NULLABLE_INLINE_PARAMETER.on((KtElement)((PsiElement)expression), expression, functionDescriptor));
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private InlineAnalyzerExtension() {
        INSTANCE = this;
    }

    static {
        new InlineAnalyzerExtension();
    }
}

