/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public abstract class AbstractTracingStrategy
implements TracingStrategy {
    protected final KtExpression reference;
    protected final Call call;

    protected AbstractTracingStrategy(@NotNull KtExpression reference, @NotNull Call call) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "<init>"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "<init>"));
        }
        this.reference = reference;
        this.call = call;
    }

    @Override
    public <D extends CallableDescriptor> void recordAmbiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "recordAmbiguity"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "recordAmbiguity"));
        }
        HashSet<D> descriptors = Sets.newHashSet();
        for (ResolvedCall<D> candidate : candidates) {
            descriptors.add(candidate.getCandidateDescriptor());
        }
        trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, this.reference, descriptors);
    }

    @Override
    public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "noValueForParameter"));
        }
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "noValueForParameter"));
        }
        KtElement reportOn = CallUtilKt.getValueArgumentListOrElement(this.call);
        trace.report(Errors.NO_VALUE_FOR_PARAMETER.on(reportOn, valueParameter));
    }

    @Override
    public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor expectedReceiver) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "missingReceiver"));
        }
        if (expectedReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedReceiver", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "missingReceiver"));
        }
        trace.report(Errors.MISSING_RECEIVER.on(this.reference, expectedReceiver.getType()));
    }

    @Override
    public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, @NotNull ResolutionContext<?> c) {
        KtExpression reportOn;
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "wrongReceiverType"));
        }
        if (receiverParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "wrongReceiverType"));
        }
        if (receiverArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "wrongReceiverType"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "wrongReceiverType"));
        }
        KtExpression ktExpression = reportOn = receiverArgument instanceof ExpressionReceiver ? ((ExpressionReceiver)receiverArgument).getExpression() : this.reference;
        if (!DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(c, reportOn, receiverParameter.getType(), receiverArgument.getType())) {
            trace.report(Errors.TYPE_MISMATCH.on(reportOn, receiverParameter.getType(), receiverArgument.getType()));
        }
    }

    @Override
    public void noReceiverAllowed(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "noReceiverAllowed"));
        }
        trace.report(Errors.NO_RECEIVER_ALLOWED.on(this.reference));
    }

    @Override
    public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount, @NotNull CallableDescriptor descriptor2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "wrongNumberOfTypeArguments"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "wrongNumberOfTypeArguments"));
        }
        KtTypeArgumentList typeArgumentList = this.call.getTypeArgumentList();
        trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(typeArgumentList != null ? typeArgumentList : this.reference, expectedTypeArgumentCount, descriptor2));
    }

    @Override
    public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "ambiguity"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "ambiguity"));
        }
        trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(this.reference, descriptors));
    }

    @Override
    public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "noneApplicable"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "noneApplicable"));
        }
        trace.report(Errors.NONE_APPLICABLE.on(this.reference, descriptors));
    }

    @Override
    public <D extends CallableDescriptor> void cannotCompleteResolve(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "cannotCompleteResolve"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "cannotCompleteResolve"));
        }
        trace.report(Errors.CANNOT_COMPLETE_RESOLVE.on(this.reference, descriptors));
    }

    @Override
    public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "instantiationOfAbstractClass"));
        }
        trace.report(Errors.CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS.on(this.call.getCallElement()));
    }

    @Override
    public void abstractSuperCall(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "abstractSuperCall"));
        }
        trace.report(Errors.ABSTRACT_SUPER_CALL.on(this.reference));
    }

    @Override
    public void nestedClassAccessViaInstanceReference(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @NotNull ExplicitReceiverKind explicitReceiverKind) {
        DeclarationDescriptor importableDescriptor;
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "nestedClassAccessViaInstanceReference"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "nestedClassAccessViaInstanceReference"));
        }
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "nestedClassAccessViaInstanceReference"));
        }
        if (explicitReceiverKind == ExplicitReceiverKind.NO_EXPLICIT_RECEIVER && DescriptorUtils.getFqName(importableDescriptor = DescriptorUtilsKt.getImportableDescriptor(classDescriptor)).isSafe()) {
            FqName fqName2 = DescriptorUtils.getFqNameFromTopLevelClass(importableDescriptor);
            String qualifiedName = this.reference.getParent() instanceof KtCallableReferenceExpression ? fqName2.parent() + "::" + classDescriptor.getName() : fqName2.asString();
            trace.report(Errors.NESTED_CLASS_SHOULD_BE_QUALIFIED.on(this.reference, classDescriptor, qualifiedName));
            return;
        }
        trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on(this.reference, classDescriptor));
    }

    @Override
    public void unsafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, boolean isCallForImplicitInvoke) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "unsafeCall"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "unsafeCall"));
        }
        ASTNode callOperationNode = this.call.getCallOperationNode();
        if (callOperationNode != null && !isCallForImplicitInvoke) {
            trace.report(Errors.UNSAFE_CALL.on(callOperationNode.getPsi(), type2));
        } else {
            KtElement callElement = this.call.getCallElement();
            if (callElement instanceof KtBinaryExpression) {
                KtBinaryExpression binaryExpression = (KtBinaryExpression)callElement;
                KtOperationReferenceExpression operationReference = binaryExpression.getOperationReference();
                Name operationString = operationReference.getReferencedNameElementType() == KtTokens.IDENTIFIER ? Name.identifier(operationReference.getText()) : OperatorConventions.getNameForOperationSymbol((KtToken)operationReference.getReferencedNameElementType());
                KtExpression left = binaryExpression.getLeft();
                KtExpression right = binaryExpression.getRight();
                if (left != null && right != null) {
                    trace.report(Errors.UNSAFE_INFIX_CALL.on(this.reference, left.getText(), operationString.asString(), right.getText()));
                }
            } else if (isCallForImplicitInvoke) {
                trace.report(Errors.UNSAFE_IMPLICIT_INVOKE_CALL.on(this.reference, type2));
            } else {
                trace.report(Errors.UNSAFE_CALL.on(this.reference, type2));
            }
        }
    }

    @Override
    public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptorWithVisibility descriptor2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "invisibleMember"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "invisibleMember"));
        }
        trace.report(Errors.INVISIBLE_MEMBER.on(this.call.getCallElement(), descriptor2, descriptor2.getVisibility(), descriptor2));
    }

    @Override
    public void typeInferenceFailed(@NotNull ResolutionContext<?> context, @NotNull InferenceErrorData data) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "typeInferenceFailed"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy", "typeInferenceFailed"));
        }
        ConstraintSystem constraintSystem = data.constraintSystem;
        ConstraintSystemStatus status2 = constraintSystem.getStatus();
        assert (!status2.isSuccessful()) : "Report error only for not successful constraint system";
        if (status2.hasErrorInConstrainingTypes()) {
            return;
        }
        BindingTrace trace = context.trace;
        if (status2.hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION)) {
            KotlinType declaredReturnType = data.descriptor.getReturnType();
            if (declaredReturnType == null) {
                return;
            }
            ConstraintSystem systemWithoutExpectedTypeConstraint = ConstraintSystemUtilsKt.filterConstraintsOut(constraintSystem, ConstraintPositionKind.EXPECTED_TYPE_POSITION);
            KotlinType substitutedReturnType = systemWithoutExpectedTypeConstraint.getResultingSubstitutor().substitute(declaredReturnType, Variance.OUT_VARIANCE);
            assert (substitutedReturnType != null);
            assert (!TypeUtils.noExpectedType(data.expectedType)) : "Expected type doesn't exist, but there is an expected type mismatch error";
            if (!DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(context, this.call.getCallElement(), data.expectedType, substitutedReturnType)) {
                trace.report(Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH.on(this.call.getCallElement(), data.expectedType, substitutedReturnType));
            }
        } else if (status2.hasCannotCaptureTypesError()) {
            trace.report(Errors.TYPE_INFERENCE_CANNOT_CAPTURE_TYPES.on(this.reference, data));
        } else if (status2.hasViolatedUpperBound()) {
            trace.report(Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED.on(this.reference, data));
        } else if (status2.hasParameterConstraintError()) {
            trace.report(Errors.TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR.on(this.reference, data));
        } else if (status2.hasConflictingConstraints()) {
            trace.report(Errors.TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS.on(this.reference, data));
        } else if (status2.hasTypeInferenceIncorporationError()) {
            trace.report(Errors.TYPE_INFERENCE_INCORPORATION_ERROR.on(this.reference));
        } else if (status2.hasTypeParameterWithUnsatisfiedOnlyInputTypesError()) {
            trace.report(Errors.TYPE_INFERENCE_ONLY_INPUT_TYPES.on(this.reference, data.descriptor.getTypeParameters().get(0)));
        } else {
            assert (status2.hasUnknownParameters());
            trace.report(Errors.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER.on(this.reference, data));
        }
    }
}

