/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public abstract class MethodSignatureBase
implements MethodSignature {
    private final PsiSubstitutor mySubstitutor;
    private final PsiType[] myParameterTypes;
    private volatile PsiType[] myErasedParameterTypes;
    protected final PsiTypeParameter[] myTypeParameters;

    protected MethodSignatureBase(@NotNull PsiSubstitutor substitutor2, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameters) {
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/util/MethodSignatureBase", "<init>"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "org/jetbrains/kotlin/com/intellij/psi/util/MethodSignatureBase", "<init>"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/com/intellij/psi/util/MethodSignatureBase", "<init>"));
        }
        this.mySubstitutor = substitutor2;
        assert (substitutor2.isValid());
        this.myParameterTypes = PsiType.createArray(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            PsiType type2 = parameterTypes[i];
            if (type2 != null) {
                PsiUtil.ensureValidType(type2);
            }
            if (type2 instanceof PsiEllipsisType) {
                type2 = ((PsiEllipsisType)type2).toArrayType();
            }
            this.myParameterTypes[i] = substitutor2.substitute(type2);
        }
        this.myTypeParameters = typeParameters;
    }

    protected MethodSignatureBase(@NotNull PsiSubstitutor substitutor2, @Nullable PsiParameterList parameterList, @Nullable PsiTypeParameterList typeParameterList) {
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/util/MethodSignatureBase", "<init>"));
        }
        this.mySubstitutor = substitutor2;
        if (parameterList == null) {
            this.myParameterTypes = PsiType.EMPTY_ARRAY;
        } else {
            PsiParameter[] parameters2 = parameterList.getParameters();
            this.myParameterTypes = PsiType.createArray(parameters2.length);
            for (int i = 0; i < parameters2.length; ++i) {
                PsiType type2 = parameters2[i].getType();
                if (type2 instanceof PsiEllipsisType) {
                    type2 = ((PsiEllipsisType)type2).toArrayType();
                }
                this.myParameterTypes[i] = substitutor2.substitute(type2);
            }
        }
        this.myTypeParameters = typeParameterList == null ? PsiTypeParameter.EMPTY_ARRAY : typeParameterList.getTypeParameters();
    }

    @Override
    @NotNull
    public PsiType[] getParameterTypes() {
        if (this.myParameterTypes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/MethodSignatureBase", "getParameterTypes"));
        }
        return this.myParameterTypes;
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        if (this.myTypeParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/MethodSignatureBase", "getTypeParameters"));
        }
        return this.myTypeParameters;
    }

    @NotNull
    public PsiType[] getErasedParameterTypes() {
        PsiType[] result2 = this.myErasedParameterTypes;
        if (result2 == null) {
            result2 = MethodSignatureUtil.calcErasedParameterTypes(this);
            this.myErasedParameterTypes = result2;
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/MethodSignatureBase", "getErasedParameterTypes"));
        }
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature methodSignature = (MethodSignature)o;
        return MethodSignatureUtil.areSignaturesEqual(methodSignature, this);
    }

    public int hashCode() {
        int result2 = this.getName().hashCode();
        PsiType[] parameterTypes = this.getErasedParameterTypes();
        result2 = 31 * result2 + parameterTypes.length;
        int length = Math.min(3, parameterTypes.length);
        for (int i = 0; i < length; ++i) {
            PsiType type2 = parameterTypes[i];
            if (type2 == null) continue;
            result2 = 31 * result2 + type2.hashCode();
        }
        return result2;
    }

    public String toString() {
        String s = this.getClass().getSimpleName() + ": ";
        PsiTypeParameter[] typeParameters = this.getTypeParameters();
        if (typeParameters.length != 0) {
            String sep = "<";
            for (PsiTypeParameter typeParameter : typeParameters) {
                s = s + sep + typeParameter.getName();
                sep = ", ";
            }
            s = s + ">";
        }
        s = s + this.getName() + "(" + Arrays.asList(this.getParameterTypes()) + ")";
        return s;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/MethodSignatureBase", "getSubstitutor"));
        }
        return psiSubstitutor;
    }
}

