/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.FrozenDocument;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.NullableComputable;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UnfairTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.SmartPointerManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.AnchorTypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.MarkerCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

public class SelfElementInfo
extends SmartPointerElementInfo {
    private static final FileDocumentManager ourFileDocManager = FileDocumentManager.getInstance();
    protected volatile AnchorTypeInfo myType;
    protected final SmartPointerManagerImpl myManager;
    private final VirtualFile myFile;
    private final boolean myForInjected;
    private int myStartOffset;
    private int myEndOffset;

    SelfElementInfo(@NotNull Project project, @Nullable ProperTextRange range, @NotNull AnchorTypeInfo info, @NotNull PsiFile containingFile, boolean forInjected) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        this.myForInjected = forInjected;
        this.myType = info;
        this.myManager = (SmartPointerManagerImpl)SmartPointerManager.getInstance(project);
        this.myFile = containingFile.getViewProvider().getVirtualFile();
        this.setRange(range);
    }

    void setRange(@Nullable Segment range) {
        if (range != null) {
            this.myStartOffset = range.getStartOffset();
            this.myEndOffset = range.getEndOffset();
        } else {
            this.myStartOffset = -1;
            this.myEndOffset = -1;
        }
    }

    boolean hasRange() {
        return this.myStartOffset >= 0;
    }

    int getPsiStartOffset() {
        return this.myStartOffset;
    }

    int getPsiEndOffset() {
        return this.myEndOffset;
    }

    boolean isForInjected() {
        return this.myForInjected;
    }

    @Override
    public Document getDocumentToSynchronize() {
        return ourFileDocManager.getCachedDocument(this.getVirtualFile());
    }

    @Override
    public PsiElement restoreElement() {
        TextRange segment = this.getPsiRange();
        if (segment == null) {
            return null;
        }
        PsiFile file = this.restoreFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        return SelfElementInfo.findElementInside(file, segment.getStartOffset(), segment.getEndOffset(), this.myType);
    }

    @Override
    @Nullable
    public TextRange getPsiRange() {
        return this.calcPsiRange();
    }

    @Nullable
    private TextRange calcPsiRange() {
        return this.hasRange() ? new UnfairTextRange(this.myStartOffset, this.myEndOffset) : null;
    }

    @Override
    public PsiFile restoreFile() {
        return SelfElementInfo.restoreFileFromVirtual(this.getVirtualFile(), this.getProject(), this.myType.getFileLanguage());
    }

    public static PsiElement findElementInside(@NotNull PsiFile file, int syncStartOffset, int syncEndOffset, @NotNull AnchorTypeInfo type2) {
        PsiElement lastChild;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        PsiElement anchor2 = file.getViewProvider().findElementAt(syncStartOffset, type2.getFileLanguage());
        if (anchor2 == null && syncStartOffset == file.getTextLength() && (lastChild = file.getViewProvider().getPsi(type2.getFileLanguage()).getLastChild()) != null) {
            anchor2 = PsiTreeUtil.getDeepestLast(lastChild);
        }
        if (anchor2 == null) {
            return null;
        }
        PsiElement result2 = SelfElementInfo.findParent(syncStartOffset, syncEndOffset, type2, anchor2);
        if (syncEndOffset == syncStartOffset) {
            while (result2 == null && anchor2.getTextRange().getStartOffset() == syncEndOffset && (anchor2 = PsiTreeUtil.prevLeaf(anchor2, false)) != null) {
                result2 = SelfElementInfo.findParent(syncStartOffset, syncEndOffset, type2, anchor2);
            }
        }
        return result2;
    }

    @Nullable
    private static PsiElement findParent(int syncStartOffset, int syncEndOffset, @NotNull AnchorTypeInfo type2, PsiElement anchor2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "findParent"));
        }
        TextRange range = anchor2.getTextRange();
        if (range.getStartOffset() != syncStartOffset) {
            return null;
        }
        while (range.getEndOffset() < syncEndOffset) {
            if ((anchor2 = anchor2.getParent()) == null || anchor2.getTextRange() == null) {
                return null;
            }
            range = anchor2.getTextRange();
        }
        while (range.getEndOffset() == syncEndOffset) {
            if (type2.isAcceptable(anchor2)) {
                return anchor2;
            }
            if ((anchor2 = anchor2.getParent()) == null || anchor2.getTextRange() == null) break;
            range = anchor2.getTextRange();
        }
        return null;
    }

    @Override
    public void cleanup() {
        this.setRange(null);
    }

    @Nullable
    public static PsiFile restoreFileFromVirtual(final @NotNull VirtualFile virtualFile, final @NotNull Project project, final @Nullable Language language) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        return (PsiFile)ApplicationManager.getApplication().runReadAction(new NullableComputable<PsiFile>(){

            public PsiFile compute() {
                if (project.isDisposed()) {
                    return null;
                }
                VirtualFile child = SelfElementInfo.restoreVFile(virtualFile);
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiFile file = PsiManager.getInstance(project).findFile(child);
                if (file != null && language != null) {
                    return file.getViewProvider().getPsi(language);
                }
                return file;
            }
        });
    }

    @Nullable
    public static PsiDirectory restoreDirectoryFromVirtual(final VirtualFile virtualFile, final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreDirectoryFromVirtual"));
        }
        if (virtualFile == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<PsiDirectory>(){

            @Override
            public PsiDirectory compute() {
                VirtualFile child = SelfElementInfo.restoreVFile(virtualFile);
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiDirectory file = PsiManager.getInstance(project).findDirectory(child);
                if (file == null || !file.isValid()) {
                    return null;
                }
                return file;
            }
        });
    }

    @Nullable
    private static VirtualFile restoreVFile(VirtualFile virtualFile) {
        VirtualFile child;
        if (virtualFile.isValid()) {
            child = virtualFile;
        } else {
            VirtualFile vParent = virtualFile.getParent();
            if (vParent == null || !vParent.isValid()) {
                return null;
            }
            String name = virtualFile.getName();
            child = vParent.findChild(name);
        }
        return child;
    }

    @Override
    public int elementHashCode() {
        return this.getVirtualFile().hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof SelfElementInfo) {
            final SelfElementInfo otherInfo = (SelfElementInfo)other;
            if (!this.getVirtualFile().equals(other.getVirtualFile()) || this.myType != otherInfo.myType) {
                return false;
            }
            return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                @Override
                public Boolean compute() {
                    TextRange range1 = SelfElementInfo.this.getPsiRange();
                    TextRange range2 = otherInfo.getPsiRange();
                    return range1 != null && range2 != null && range1.getStartOffset() == range2.getStartOffset() && range1.getEndOffset() == range2.getEndOffset();
                }
            });
        }
        return this.areRestoredElementsEqual(other);
    }

    protected boolean areRestoredElementsEqual(final @NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "areRestoredElementsEqual"));
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return Comparing.equal(SelfElementInfo.this.restoreElement(), other.restoreElement());
            }
        });
    }

    @Override
    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public Segment getRange() {
        MarkerCache markerCache;
        PsiDocumentManagerBase documentManager;
        List<DocumentEvent> events;
        Document document;
        if (this.hasRange() && (document = this.getDocumentToSynchronize()) != null && !(events = (documentManager = this.myManager.getPsiDocumentManager()).getEventsSinceCommit(document)).isEmpty() && (markerCache = this.myManager.getMarkerCache(this.getVirtualFile())) != null) {
            return markerCache.getUpdatedRange(this, (FrozenDocument)documentManager.getLastCommittedDocument(document), events);
        }
        return this.calcPsiRange();
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project = this.myManager.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SelfElementInfo", "getProject"));
        }
        return project;
    }

    public String toString() {
        return "psi:range=" + this.calcPsiRange() + ",type=" + this.myType;
    }
}

