/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.Commenter;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageCommenters;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.GeneratedMarkerVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiParserFacadeImpl
implements PsiParserFacade {
    protected final PsiManagerEx myManager;

    public PsiParserFacadeImpl(PsiManagerEx manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public PsiElement createWhiteSpaceFromText(@NotNull @NonNls String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiParserFacadeImpl", "createWhiteSpaceFromText"));
        }
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, null).getTreeElement();
        LeafElement newElement = ASTFactory.leaf(TokenType.WHITE_SPACE, holderElement.getCharTable().intern(text));
        holderElement.rawAddChildren(newElement);
        GeneratedMarkerVisitor.markGenerated(newElement.getPsi());
        PsiElement psiElement = newElement.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiParserFacadeImpl", "createWhiteSpaceFromText"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiComment createLineCommentFromText(@NotNull LanguageFileType fileType, @NotNull String text) throws IncorrectOperationException {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiParserFacadeImpl", "createLineCommentFromText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiParserFacadeImpl", "createLineCommentFromText"));
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(fileType.getLanguage());
        assert (commenter != null);
        String prefix = commenter.getLineCommentPrefix();
        if (prefix == null) {
            throw new IncorrectOperationException("No line comment prefix defined for language " + fileType.getLanguage().getID());
        }
        PsiFile aFile = this.createDummyFile(prefix + text, fileType);
        PsiComment psiComment = this.findPsiCommentChild(aFile);
        if (psiComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiParserFacadeImpl", "createLineCommentFromText"));
        }
        return psiComment;
    }

    @Override
    @NotNull
    public PsiComment createBlockCommentFromText(@NotNull Language language, @NotNull String text) throws IncorrectOperationException {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiParserFacadeImpl", "createBlockCommentFromText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiParserFacadeImpl", "createBlockCommentFromText"));
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        assert (commenter != null) : language;
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        PsiFile aFile = PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText("_Dummy_", language, (CharSequence)(blockCommentPrefix + text + blockCommentSuffix));
        PsiComment psiComment = this.findPsiCommentChild(aFile);
        if (psiComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiParserFacadeImpl", "createBlockCommentFromText"));
        }
        return psiComment;
    }

    @Override
    @NotNull
    public PsiComment createLineOrBlockCommentFromText(@NotNull Language lang, @NotNull String text) throws IncorrectOperationException {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiParserFacadeImpl", "createLineOrBlockCommentFromText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiParserFacadeImpl", "createLineOrBlockCommentFromText"));
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(lang);
        assert (commenter != null) : lang;
        String prefix = commenter.getLineCommentPrefix();
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        assert (prefix != null || blockCommentPrefix != null && blockCommentSuffix != null);
        PsiFile aFile = PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText("_Dummy_", lang, (CharSequence)(prefix != null ? prefix + text : blockCommentPrefix + text + blockCommentSuffix));
        PsiComment psiComment = this.findPsiCommentChild(aFile);
        if (psiComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiParserFacadeImpl", "createLineOrBlockCommentFromText"));
        }
        return psiComment;
    }

    private PsiComment findPsiCommentChild(PsiFile aFile) {
        PsiElement[] children;
        for (PsiElement aChildren : children = aFile.getChildren()) {
            if (!(aChildren instanceof PsiComment)) continue;
            PsiComment comment = (PsiComment)aChildren;
            DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)SourceTreeToPsiMap.psiElementToTree(comment), null);
            return comment;
        }
        throw new IncorrectOperationException("Incorrect comment \"" + aFile.getText() + "\".");
    }

    protected PsiFile createDummyFile(String text, LanguageFileType fileType) {
        String ext = fileType.getDefaultExtension();
        String fileName = "_Dummy_." + ext;
        return PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText(fileType, fileName, (CharSequence)text, 0, text.length());
    }
}

