/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializerUtil;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002\u001a%\u0010\u0005\u001a\n \u0007*\u0004\u0018\u0001H\u0006H\u0006\"\b\b\u0000\u0010\u0006*\u00020\b2\u0006\u0010\t\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\n\u001a;\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\r*\u00020\b\"\b\b\u0001\u0010\f*\u0002H\r2\u0006\u0010\u000e\u001a\u0002H\r2\u0006\u0010\u000f\u001a\u0002H\f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012\u001a/\u0010\u0013\u001a\u0002H\f\"\b\b\u0000\u0010\r*\u00020\b\"\b\b\u0001\u0010\f*\u0002H\r2\u0006\u0010\u000e\u001a\u0002H\r2\u0006\u0010\u000f\u001a\u0002H\f\u00a2\u0006\u0002\u0010\u0014\u001a\f\u0010\u0015\u001a\u00020\b*\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"collectFieldsToCopy", "", "Ljava/lang/reflect/Field;", "clazz", "Ljava/lang/Class;", "copyBean", "T", "kotlin.jvm.PlatformType", "", "bean", "(Ljava/lang/Object;)Ljava/lang/Object;", "copyFields", "To", "From", "from", "to", "deepCopyWhenNeeded", "", "(Ljava/lang/Object;Ljava/lang/Object;Z)Ljava/lang/Object;", "mergeBeans", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "copyValueIfNeeded", "kotlin-compiler"})
public final class ArgumentUtilsKt {
    public static final <T> T copyBean(@NotNull T bean) {
        Intrinsics.checkParameterIsNotNull(bean, "bean");
        return (T)ArgumentUtilsKt.copyFields(bean, bean.getClass().newInstance(), true);
    }

    @NotNull
    public static final <From, To extends From> To mergeBeans(@NotNull From from, @NotNull To to) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        To To = ArgumentUtilsKt.copyFields(from, XmlSerializerUtil.createCopy(to), false);
        Intrinsics.checkExpressionValueIsNotNull(To, "copyFields(from, XmlSeri\u2026il.createCopy(to), false)");
        return To;
    }

    private static final <From, To extends From> To copyFields(From from, To to, boolean deepCopyWhenNeeded) {
        List<Field> fromFields = ArgumentUtilsKt.collectFieldsToCopy(from.getClass());
        for (Field fromField : fromFields) {
            Object object;
            Field toField = to.getClass().getField(fromField.getName());
            Object fromValue = fromField.get(from);
            if (deepCopyWhenNeeded) {
                Object object2 = fromValue;
                object = object2 != null ? ArgumentUtilsKt.copyValueIfNeeded(object2) : null;
            } else {
                object = fromValue;
            }
            toField.set(to, object);
        }
        return to;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object copyValueIfNeeded(@NotNull Object $receiver) {
        Object object;
        Object object2 = $receiver;
        if (object2 instanceof byte[]) {
            object = Arrays.copyOf((byte[])$receiver, ((byte[])$receiver).length);
        } else if (object2 instanceof char[]) {
            object = Arrays.copyOf((char[])$receiver, ((char[])$receiver).length);
        } else if (object2 instanceof short[]) {
            object = Arrays.copyOf((short[])$receiver, ((short[])$receiver).length);
        } else if (object2 instanceof int[]) {
            object = Arrays.copyOf((int[])$receiver, ((int[])$receiver).length);
        } else if (object2 instanceof long[]) {
            object = Arrays.copyOf((long[])$receiver, ((long[])$receiver).length);
        } else if (object2 instanceof float[]) {
            object = Arrays.copyOf((float[])$receiver, ((float[])$receiver).length);
        } else if (object2 instanceof double[]) {
            object = Arrays.copyOf((double[])$receiver, ((double[])$receiver).length);
        } else if (object2 instanceof boolean[]) {
            object = Arrays.copyOf((boolean[])$receiver, ((boolean[])$receiver).length);
        } else if (object2 instanceof Object[]) {
            int size$iv = ((Object[])$receiver).length;
            Object[] result$iv = new Object[size$iv];
            int n = 0;
            int n2 = size$iv - 1;
            if (n <= n2) {
                void i$iv;
                do {
                    Object object3;
                    void it;
                    void var6_14 = ++i$iv;
                    void var7_17 = i$iv;
                    Object[] objectArray = result$iv;
                    Object object4 = ((Object[])$receiver)[it];
                    objectArray[var7_17] = object3 = object4 != null ? ArgumentUtilsKt.copyValueIfNeeded(object4) : null;
                } while (i$iv != n2);
            }
            object = result$iv;
        } else if (TypeIntrinsics.isMutableCollection(object2)) {
            void $receiver$iv;
            Object object5 = $receiver;
            if (object5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<kotlin.Any?>");
            }
            Iterable size$iv = (Collection)object5;
            Object obj = $receiver.getClass().newInstance();
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<kotlin.Any?>");
            }
            Collection destination$iv = TypeIntrinsics.asMutableCollection(obj);
            Iterator iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv;
                Object it = item$iv = iterator2.next();
                Collection collection = destination$iv;
                Object t = it;
                Object object6 = t != null ? ArgumentUtilsKt.copyValueIfNeeded(t) : null;
                collection.add(object6);
            }
            object = destination$iv;
        } else if (TypeIntrinsics.isMutableMap(object2)) {
            Object obj = $receiver.getClass().newInstance();
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.Any?, kotlin.Any?>");
            }
            Map map2 = TypeIntrinsics.asMutableMap(obj);
            Map $receiver2 = map2;
            Iterator iterator3 = ((Map)$receiver).entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry entry;
                Map.Entry it = entry = iterator3.next();
                Object k = it.getKey();
                Map.Entry entry2 = entry;
                Object v = entry2.getValue();
                Object k2 = k;
                Object v2 = v;
                $receiver2.put(k2 != null ? ArgumentUtilsKt.copyValueIfNeeded(k2) : null, v2 != null ? ArgumentUtilsKt.copyValueIfNeeded(v2) : null);
            }
            object = map2;
        } else {
            object = $receiver;
        }
        Intrinsics.checkExpressionValueIsNotNull(object, "when (this) {\n        is\u2026       else -> this\n    }");
        return object;
    }

    private static final List<Field> collectFieldsToCopy(Class<?> clazz) {
        ArrayList<Field> fromFields = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] fieldArray = currentClass.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                fromFields.add(field);
            }
        }
        return fromFields;
    }
}

