/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.tower.TowerLevelsKt;
import org.jetbrains.kotlin.resolve.diagnostics.MutableDiagnosticsWithSuppression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BindingContextUtils {
    private BindingContextUtils() {
    }

    @Nullable
    public static VariableDescriptor extractVariableFromResolvedCall(@NotNull BindingContext bindingContext, @Nullable KtElement callElement) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "extractVariableFromResolvedCall"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callElement, bindingContext);
        if (resolvedCall2 == null || !(resolvedCall2.getResultingDescriptor() instanceof VariableDescriptor)) {
            return null;
        }
        return (VariableDescriptor)resolvedCall2.getResultingDescriptor();
    }

    @Nullable
    public static VariableDescriptor variableDescriptorForDeclaration(@Nullable DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof VariableDescriptor) {
            return (VariableDescriptor)descriptor2;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            return TowerLevelsKt.getFakeDescriptorForObject((ClassDescriptor)descriptor2);
        }
        return null;
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorFromReference(@NotNull BindingContext bindingContext, @Nullable KtElement element) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "extractVariableDescriptorFromReference"));
        }
        if (element instanceof KtSimpleNameExpression) {
            return BindingContextUtils.variableDescriptorForDeclaration(bindingContext.get(BindingContext.REFERENCE_TARGET, (KtSimpleNameExpression)element));
        }
        if (element instanceof KtQualifiedExpression) {
            return BindingContextUtils.extractVariableDescriptorFromReference(bindingContext, ((KtQualifiedExpression)element).getSelectorExpression());
        }
        return null;
    }

    public static void recordFunctionDeclarationToDescriptor(@NotNull BindingTrace trace, @NotNull PsiElement psiElement, @NotNull SimpleFunctionDescriptor function) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingContextUtils", "recordFunctionDeclarationToDescriptor"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/resolve/BindingContextUtils", "recordFunctionDeclarationToDescriptor"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/BindingContextUtils", "recordFunctionDeclarationToDescriptor"));
        }
        trace.record(BindingContext.FUNCTION, psiElement, function);
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (slice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        V v = BindingContextUtils.getNotNull(bindingContext, slice, key, "Value at " + slice + " must not be null for " + key);
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        return v;
    }

    @NotNull
    public static KotlinType getTypeNotNull(@NotNull BindingContext bindingContext, @NotNull KtExpression expression) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getTypeNotNull"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getTypeNotNull"));
        }
        KotlinType result2 = bindingContext.getType(expression);
        if (result2 == null) {
            throw new IllegalStateException("Type must be not null for " + expression);
        }
        KotlinType kotlinType = result2;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getTypeNotNull"));
        }
        return kotlinType;
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key, @NotNull String messageIfNull) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (slice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (messageIfNull == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageIfNull", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        V value = bindingContext.get(slice, key);
        if (value == null) {
            throw new IllegalStateException(messageIfNull);
        }
        V v = value;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        return v;
    }

    @NotNull
    public static DeclarationDescriptor getEnclosingDescriptor(@NotNull BindingContext context, @NotNull KtElement element) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingDescriptor"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingDescriptor"));
        }
        KtNamedDeclaration declaration = PsiTreeUtil.getParentOfType((PsiElement)element, KtNamedDeclaration.class);
        if (declaration instanceof KtFunctionLiteral) {
            DeclarationDescriptor declarationDescriptor = BindingContextUtils.getEnclosingDescriptor(context, declaration);
            if (declarationDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingDescriptor"));
            }
            return declarationDescriptor;
        }
        DeclarationDescriptor descriptor2 = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
        assert (descriptor2 != null) : "No descriptor for named declaration: " + declaration.getText() + "\n(of type " + declaration.getClass() + ")";
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingDescriptor"));
        }
        return declarationDescriptor;
    }

    @Nullable
    public static FunctionDescriptor getEnclosingFunctionDescriptor(@NotNull BindingContext context, @NotNull KtElement element) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingFunctionDescriptor"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingFunctionDescriptor"));
        }
        KtElement functionOrClass = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)element, KtFunction.class, KtClassOrObject.class);
        DeclarationDescriptor descriptor2 = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionOrClass);
        if (functionOrClass instanceof KtFunction) {
            if (descriptor2 instanceof FunctionDescriptor) {
                return (FunctionDescriptor)descriptor2;
            }
            return null;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            return ((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor();
        }
        return null;
    }

    public static void reportAmbiguousLabel(@NotNull BindingTrace trace, @NotNull KtSimpleNameExpression targetLabel, @NotNull Collection<DeclarationDescriptor> declarationsByLabel) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingContextUtils", "reportAmbiguousLabel"));
        }
        if (targetLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetLabel", "org/jetbrains/kotlin/resolve/BindingContextUtils", "reportAmbiguousLabel"));
        }
        if (declarationsByLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationsByLabel", "org/jetbrains/kotlin/resolve/BindingContextUtils", "reportAmbiguousLabel"));
        }
        ArrayList<PsiElement> targets = Lists.newArrayList();
        for (DeclarationDescriptor descriptor2 : declarationsByLabel) {
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            assert (element != null) : "Label can only point to something in the same lexical scope";
            targets.add(element);
        }
        if (!targets.isEmpty()) {
            trace.record(BindingContext.AMBIGUOUS_LABEL_TARGET, targetLabel, targets);
        }
        trace.report(Errors.AMBIGUOUS_LABEL.on(targetLabel));
    }

    @Nullable
    public static KotlinType updateRecordedType(@Nullable KotlinType type2, @NotNull KtExpression expression, @NotNull BindingTrace trace, boolean shouldBeMadeNullable) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingContextUtils", "updateRecordedType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingContextUtils", "updateRecordedType"));
        }
        if (type2 == null) {
            return null;
        }
        if (shouldBeMadeNullable) {
            type2 = TypeUtils.makeNullable(type2);
        }
        trace.recordType(expression, type2);
        return type2;
    }

    @Nullable
    public static KotlinTypeInfo getRecordedTypeInfo(@NotNull KtExpression expression, @NotNull BindingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getRecordedTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getRecordedTypeInfo"));
        }
        if (context.get(BindingContext.PROCESSED, expression) != Boolean.TRUE) {
            return null;
        }
        KotlinTypeInfo result2 = context.get(BindingContext.EXPRESSION_TYPE_INFO, expression);
        return result2 != null ? result2 : TypeInfoFactoryKt.noTypeInfo(DataFlowInfoFactory.EMPTY);
    }

    public static boolean isExpressionWithValidReference(@NotNull KtExpression expression, @NotNull BindingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingContextUtils", "isExpressionWithValidReference"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/BindingContextUtils", "isExpressionWithValidReference"));
        }
        if (expression instanceof KtCallExpression) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression, context);
            return resolvedCall2 instanceof VariableAsFunctionResolvedCall;
        }
        return expression instanceof KtReferenceExpression;
    }

    public static boolean isVarCapturedInClosure(BindingContext bindingContext, DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof VariableDescriptor) || descriptor2 instanceof PropertyDescriptor) {
            return false;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
        return bindingContext.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) != null && variableDescriptor.isVar();
    }

    @NotNull
    public static Pair<FunctionDescriptor, PsiElement> getContainingFunctionSkipFunctionLiterals(@Nullable DeclarationDescriptor startDescriptor, boolean strict) {
        PsiElement containingFunction;
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(startDescriptor, FunctionDescriptor.class, strict);
        PsiElement psiElement = containingFunction = containingFunctionDescriptor != null ? DescriptorToSourceUtils.getSourceFromDescriptor(containingFunctionDescriptor) : null;
        while (containingFunction instanceof KtFunctionLiteral) {
            containingFunction = (containingFunctionDescriptor = DescriptorUtils.getParentOfType(containingFunctionDescriptor, FunctionDescriptor.class)) != null ? DescriptorToSourceUtils.getSourceFromDescriptor(containingFunctionDescriptor) : null;
        }
        Pair<FunctionDescriptor, PsiElement> pair = new Pair<FunctionDescriptor, PsiElement>(containingFunctionDescriptor, containingFunction);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getContainingFunctionSkipFunctionLiterals"));
        }
        return pair;
    }

    @Nullable
    public static ResolvedCall<ConstructorDescriptor> getDelegationConstructorCall(@NotNull BindingContext bindingContext, @NotNull ConstructorDescriptor constructorDescriptor) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getDelegationConstructorCall"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getDelegationConstructorCall"));
        }
        return bindingContext.get(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructorDescriptor);
    }

    static void addOwnDataTo(final @NotNull BindingTrace trace, final @Nullable TraceEntryFilter filter2, boolean commitDiagnostics, @NotNull MutableSlicedMap map2, MutableDiagnosticsWithSuppression diagnostics2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingContextUtils", "addOwnDataTo"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/resolve/BindingContextUtils", "addOwnDataTo"));
        }
        map2.forEach(new Function3<WritableSlice, Object, Object, Void>(){

            @Override
            public Void invoke(WritableSlice slice, Object key, Object value) {
                if (filter2 == null || filter2.accept(slice, key)) {
                    trace.record(slice, key, value);
                }
                return null;
            }
        });
        if (!commitDiagnostics) {
            return;
        }
        for (Diagnostic diagnostic : diagnostics2.getOwnDiagnostics()) {
            if (filter2 != null && !filter2.accept(null, diagnostic.getPsiElement())) continue;
            trace.report(diagnostic);
        }
    }
}

