/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Conditions;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.Functions;
import org.jetbrains.kotlin.com.intellij.util.PairFunction;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.Convertor;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterator;

public abstract class JBIterable<E>
implements Iterable<E> {
    final Iterable<E> myIterable;
    private static final JBIterable EMPTY = new JBIterable(){

        @Override
        public Iterator iterator() {
            return ContainerUtil.emptyIterator();
        }
    };

    protected JBIterable() {
        this.myIterable = this;
    }

    JBIterable(@NotNull Iterable<E> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "<init>"));
        }
        this.myIterable = iterable;
    }

    @NotNull
    public static <E> JBIterable<E> from(@Nullable Iterable<? extends E> iterable) {
        if (iterable == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "from"));
            }
            return jBIterable;
        }
        if (iterable instanceof JBIterable) {
            JBIterable jBIterable = (JBIterable)iterable;
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "from"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(iterable){

            @Override
            public Iterator<E> iterator() {
                return this.myIterable.iterator();
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "from"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first, final @NotNull Function<? super E, ? extends E> generator) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "generate"));
        }
        if (first == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "generate"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                final Function fun = Stateful.copy(generator);
                return new JBIterator<E>(){
                    E cur;
                    {
                        this.cur = first;
                    }

                    @Override
                    public E nextImpl() {
                        Object result2 = this.cur;
                        if (result2 == null) {
                            return this.stop();
                        }
                        this.cur = fun.fun(this.cur);
                        return result2;
                    }
                };
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "generate"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first1, final @Nullable E first2, final @NotNull PairFunction<? super E, ? super E, ? extends E> generator) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "generate"));
        }
        if (first1 == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "generate"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new JBIterator<E>(){
                    E cur1;
                    E cur2;
                    {
                        this.cur1 = first1;
                        this.cur2 = first2;
                    }

                    @Override
                    public E nextImpl() {
                        Object result2 = this.cur1;
                        this.cur1 = this.cur2;
                        this.cur2 = generator.fun(result2, this.cur2);
                        if (result2 == null) {
                            return this.stop();
                        }
                        return result2;
                    }
                };
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "generate"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> of(@Nullable E element) {
        JBIterable<E> jBIterable = element == null ? JBIterable.empty() : JBIterable.from(Collections.singletonList(element));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "of"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> of(E ... elements) {
        JBIterable<E> jBIterable = elements == null ? JBIterable.empty() : JBIterable.from(ContainerUtil.newArrayList(elements));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "of"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> empty() {
        JBIterable jBIterable = EMPTY;
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "empty"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> once(@NotNull Iterator<E> iterator2) {
        if (iterator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "once"));
        }
        JBIterable jBIterable = JBIterable.of(Ref.create(iterator2)).intercept(new Function<Iterator<Ref<Iterator<E>>>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<Ref<Iterator<E>>> iterator2) {
                Ref ref = iterator2.next();
                Iterator result2 = ref.get();
                if (result2 == null) {
                    throw new UnsupportedOperationException();
                }
                ref.set(null);
                return result2;
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "once"));
        }
        return jBIterable;
    }

    @NotNull
    public <T extends Iterator<E>> T typedIterator() {
        Iterator iterator2 = this.iterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "typedIterator"));
        }
        return (T)iterator2;
    }

    @NotNull
    public String toString() {
        String string = this.myIterable == this ? super.toString() : String.valueOf(this.myIterable);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "toString"));
        }
        return string;
    }

    public final int size() {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).size();
        }
        int count = 0;
        for (E ignored : this.myIterable) {
            ++count;
        }
        return count;
    }

    public final boolean contains(@Nullable Object element) {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).contains(element);
        }
        for (E e : this.myIterable) {
            if (!Comparing.equal(e, element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final E get(int index2) {
        if (this.myIterable instanceof List) {
            return index2 >= ((List)this.myIterable).size() ? null : (E)((List)this.myIterable).get(index2);
        }
        return this.skip(index2).first();
    }

    @NotNull
    public final JBIterable<E> append(@Nullable Iterable<? extends E> other) {
        JBIterable<Object> jBIterable = other == null ? this : (this == EMPTY ? JBIterable.from(other) : JBIterable.of(this.myIterable, other).flatten(Functions.identity()));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "append"));
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<E> append(@Nullable Iterable<T> other, @NotNull Function<? super T, ? extends Iterable<? extends E>> fun) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "append"));
        }
        JBIterable<Object> jBIterable = other == null ? this : (this == EMPTY ? JBIterable.from(other).flatten(fun) : this.append((T)JBIterable.from(other).flatten(fun)));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "append"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> repeat(int count) {
        Function fun = Functions.identity();
        JBIterable jBIterable = JBIterable.generate(this, fun).take(count).flatten(fun);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "repeat"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> append(@NotNull E[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "append"));
        }
        JBIterable<Object> jBIterable = this == EMPTY ? JBIterable.of(elements) : this.append((E)Arrays.asList(elements));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "append"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> append(@Nullable E e) {
        JBIterable<Set<E>> jBIterable = e == null ? this : (this == EMPTY ? JBIterable.of(e) : this.append(Collections.singleton(e)));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "append"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> filter(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "filter"));
        }
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator2) {
                return JBIterator.from(iterator2).filter(Stateful.copy(condition));
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "filter"));
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> filter(@NotNull Class<T> type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "filter"));
        }
        JBIterable jBIterable = this.filter(Conditions.instanceOf(type2));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "filter"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> take(final int count) {
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator2) {
                return JBIterator.from(iterator2).take(count);
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "take"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> takeWhile(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "takeWhile"));
        }
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator2) {
                return JBIterator.from(iterator2).takeWhile(Stateful.copy(condition));
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "takeWhile"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> skip(final int count) {
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator2) {
                return JBIterator.from(iterator2).skip(count);
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "skip"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> skipWhile(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "skipWhile"));
        }
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator2) {
                return JBIterator.from(iterator2).skipWhile(Stateful.copy(condition));
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "skipWhile"));
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> transform(final @NotNull Function<? super E, T> function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "transform"));
        }
        JBIterable<T> jBIterable = this.intercept(new Function<Iterator<E>, Iterator<T>>(){

            @Override
            public Iterator<T> fun(Iterator<E> iterator2) {
                return JBIterator.from(iterator2).transform(Stateful.copy(function));
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "transform"));
        }
        return jBIterable;
    }

    @NotNull
    public <T> JBIterable<T> flatten(final Function<? super E, ? extends Iterable<? extends T>> function) {
        JBIterable<T> jBIterable = this.intercept(new Function<Iterator<E>, Iterator<T>>(){

            @Override
            public Iterator<T> fun(final Iterator<E> iterator2) {
                final Function fun = Stateful.copy(function);
                return new JBIterator<T>(){
                    Iterator<? extends T> cur;

                    @Override
                    public T nextImpl() {
                        if (this.cur != null && this.cur.hasNext()) {
                            return this.cur.next();
                        }
                        if (!iterator2.hasNext()) {
                            return this.stop();
                        }
                        this.cur = ((Iterable)fun.fun(iterator2.next())).iterator();
                        return this.skip();
                    }
                };
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "flatten"));
        }
        return jBIterable;
    }

    @NotNull
    public final <T, X extends Iterator<E>> JBIterable<T> intercept(final @NotNull Function<X, ? extends Iterator<T>> function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "intercept"));
        }
        if (this == EMPTY) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "intercept"));
            }
            return jBIterable;
        }
        final JBIterable thisIterable = this;
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return (Iterator)function.fun(thisIterable.iterator());
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "intercept"));
        }
        return jBIterable;
    }

    @Nullable
    public final E first() {
        Iterator<E> iterator2 = this.myIterable.iterator();
        return iterator2.hasNext() ? (E)iterator2.next() : null;
    }

    @Nullable
    public final E last() {
        if (this.myIterable instanceof List) {
            return (E)ContainerUtil.getLastItem((List)this.myIterable);
        }
        Iterator<E> iterator2 = this.myIterable.iterator();
        E cur = null;
        while (iterator2.hasNext()) {
            cur = iterator2.next();
        }
        return cur;
    }

    public final <T> T reduce(@Nullable T first, @NotNull PairFunction<T, ? super E, T> function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "reduce"));
        }
        T cur = first;
        for (Object e : this) {
            cur = function.fun(cur, e);
        }
        return cur;
    }

    public final E find(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "find"));
        }
        return this.filter(condition).first();
    }

    public final int indexOf(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "indexOf"));
        }
        int index2 = 0;
        for (Object e : this) {
            if (condition.value(e)) {
                return index2;
            }
            ++index2;
        }
        return -1;
    }

    @NotNull
    public final <T> JBIterable<T> map(@NotNull Function<? super E, T> function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "map"));
        }
        JBIterable<T> jBIterable = this.transform(function);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "map"));
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> flatMap(Function<? super E, ? extends Iterable<? extends T>> function) {
        JBIterable<T> jBIterable = this.map(function).flatten(Function.ID);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "flatMap"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<List<E>> partition(final int n, final boolean strict) {
        if (n <= 0) {
            throw new IllegalArgumentException(n + " <= 0");
        }
        JBIterable<List<E>> jBIterable = this.intercept(new Function<Iterator<E>, Iterator<List<E>>>(){

            @Override
            public Iterator<List<E>> fun(Iterator<E> iterator2) {
                final Iterator orig = iterator2;
                return new JBIterator<List<E>>(){

                    @Override
                    protected List<E> nextImpl() {
                        ArrayList next = ContainerUtil.newArrayListWithCapacity(n);
                        for (Object e : JBIterable.once(orig).take(n)) {
                            next.add(e);
                        }
                        return next.isEmpty() || strict && next.size() < n ? (ArrayList)this.stop() : next;
                    }
                };
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "partition"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<JBIterable<E>> partition(final SeparatorOption option, final Condition<? super E> separatorCondition) {
        JBIterable<JBIterable<E>> jBIterable = this.intercept(new Function<Iterator<E>, Iterator<JBIterable<E>>>(){

            @Override
            public Iterator<JBIterable<E>> fun(Iterator<E> iterator2) {
                final Iterator orig = iterator2;
                return new JBIterator<JBIterable<E>>(){
                    List<E> stored;
                    JBIterator<E> it;

                    @Override
                    protected JBIterable<E> nextImpl() {
                        if (this.it != null && this.it.hasNext()) {
                            JBIterable.once(this.it).size();
                        }
                        this.it = null;
                        List sep = this.stored;
                        this.stored = null;
                        if (option == SeparatorOption.EXTRACT && sep != null) {
                            return JBIterable.from(sep);
                        }
                        if (!orig.hasNext()) {
                            return option == SeparatorOption.TAIL && sep != null ? JBIterable.from(sep) : (JBIterable)this.stop();
                        }
                        this.it = JBIterator.wrap(orig);
                        JBIterable<2> next = JBIterable.once(this.it.takeWhile(new Condition<E>(){

                            @Override
                            public boolean value(E e) {
                                if (!separatorCondition.value(e)) {
                                    return true;
                                }
                                stored = Collections.singletonList(e);
                                return false;
                            }
                        }));
                        switch (option) {
                            case HEAD: {
                                return next.append(new JBIterable<E>(){

                                    @Override
                                    public Iterator<E> iterator() {
                                        return stored != null ? stored.iterator() : JBIterable.empty().iterator();
                                    }
                                });
                            }
                            case TAIL: {
                                return sep != null ? JBIterable.from(sep).append(next) : next;
                            }
                            case EXTRACT: 
                            case SKIP: {
                                return next;
                            }
                        }
                        throw new AssertionError((Object)option);
                    }
                };
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "partition"));
        }
        return jBIterable;
    }

    public final boolean isEmpty() {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).isEmpty();
        }
        return !this.myIterable.iterator().hasNext();
    }

    @NotNull
    public final List<E> toList() {
        List<E> list2 = Collections.unmodifiableList(ContainerUtil.newArrayList(this.myIterable));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "toList"));
        }
        return list2;
    }

    @NotNull
    public final Set<E> toSet() {
        Set<E> set = Collections.unmodifiableSet(ContainerUtil.newLinkedHashSet(this.myIterable));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "toSet"));
        }
        return set;
    }

    @NotNull
    public final <V> Map<E, V> toMap(Convertor<E, V> valueFunction) {
        Map map2 = Collections.unmodifiableMap(ContainerUtil.newMapFromKeys(this.iterator(), valueFunction));
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "toMap"));
        }
        return map2;
    }

    @NotNull
    public final <C extends Collection<? super E>> C addAllTo(@NotNull C collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "addAllTo"));
        }
        if (this.myIterable instanceof Collection) {
            collection.addAll((Collection)this.myIterable);
        } else {
            for (E item : this.myIterable) {
                collection.add(item);
            }
        }
        C c = collection;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable", "addAllTo"));
        }
        return c;
    }

    public static abstract class StatefulFilter<T>
    extends Stateful<StatefulFilter>
    implements Condition<T> {
    }

    public static abstract class Stateful<Self extends Stateful>
    implements Cloneable {
        @NotNull
        static <T> T copy(@NotNull T o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable$Stateful", "copy"));
            }
            if (!(o instanceof Stateful)) {
                T t = o;
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable$Stateful", "copy"));
                }
                return t;
            }
            Object object = ((Stateful)o).clone();
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable$Stateful", "copy"));
            }
            return (T)object;
        }

        public Self clone() {
            try {
                return (Self)((Stateful)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static enum SeparatorOption {
        HEAD,
        TAIL,
        EXTRACT,
        SKIP;

    }
}

