/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.markup;

import java.awt.Color;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.editor.markup.EffectType;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class AttributesFlyweight {
    private static final ConcurrentMap<FlyweightKey, AttributesFlyweight> entries = ContainerUtil.newConcurrentMap();
    private static final ThreadLocal<FlyweightKey> ourKey = new ThreadLocal();
    private final int myHashCode;
    private final Color myForeground;
    private final Color myBackground;
    private final int myFontType;
    private final Color myEffectColor;
    private final EffectType myEffectType;
    private final Color myErrorStripeColor;

    @NotNull
    public static AttributesFlyweight create(Color foreground, Color background, int fontType, Color effectColor, EffectType effectType, Color errorStripeColor) {
        FlyweightKey key = ourKey.get();
        if (key == null) {
            key = new FlyweightKey();
            ourKey.set(key);
        }
        key.foreground = foreground;
        key.background = background;
        key.fontType = fontType;
        key.effectColor = effectColor;
        key.effectType = effectType;
        key.errorStripeColor = errorStripeColor;
        AttributesFlyweight flyweight = (AttributesFlyweight)entries.get(key);
        if (flyweight != null) {
            AttributesFlyweight attributesFlyweight = flyweight;
            if (attributesFlyweight == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/markup/AttributesFlyweight", "create"));
            }
            return attributesFlyweight;
        }
        AttributesFlyweight newValue = new AttributesFlyweight(foreground, background, fontType, effectColor, effectType, errorStripeColor);
        AttributesFlyweight attributesFlyweight = ConcurrencyUtil.cacheOrGet(entries, key.clone(), newValue);
        if (attributesFlyweight == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/markup/AttributesFlyweight", "create"));
        }
        return attributesFlyweight;
    }

    private AttributesFlyweight(Color foreground, Color background, int fontType, Color effectColor, EffectType effectType, Color errorStripeColor) {
        this.myForeground = foreground;
        this.myBackground = background;
        this.myFontType = fontType;
        this.myEffectColor = effectColor;
        this.myEffectType = effectType;
        this.myErrorStripeColor = errorStripeColor;
        this.myHashCode = AttributesFlyweight.calcHashCode(foreground, background, fontType, effectColor, effectType, errorStripeColor);
    }

    private static int calcHashCode(Color foreground, Color background, int fontType, Color effectColor, EffectType effectType, Color errorStripeColor) {
        int result2 = foreground != null ? foreground.hashCode() : 0;
        result2 = 31 * result2 + (background != null ? background.hashCode() : 0);
        result2 = 31 * result2 + fontType;
        result2 = 31 * result2 + (effectColor != null ? effectColor.hashCode() : 0);
        result2 = 31 * result2 + (effectType != null ? effectType.hashCode() : 0);
        result2 = 31 * result2 + (errorStripeColor != null ? errorStripeColor.hashCode() : 0);
        return result2;
    }

    public Color getForeground() {
        return this.myForeground;
    }

    public Color getBackground() {
        return this.myBackground;
    }

    public int getFontType() {
        return this.myFontType;
    }

    public Color getEffectColor() {
        return this.myEffectColor;
    }

    public EffectType getEffectType() {
        return this.myEffectType;
    }

    public Color getErrorStripeColor() {
        return this.myErrorStripeColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributesFlyweight that = (AttributesFlyweight)o;
        if (this.myFontType != that.myFontType) {
            return false;
        }
        if (this.myBackground != null ? !this.myBackground.equals(that.myBackground) : that.myBackground != null) {
            return false;
        }
        if (this.myEffectColor != null ? !this.myEffectColor.equals(that.myEffectColor) : that.myEffectColor != null) {
            return false;
        }
        if (this.myEffectType != that.myEffectType) {
            return false;
        }
        if (this.myErrorStripeColor != null ? !this.myErrorStripeColor.equals(that.myErrorStripeColor) : that.myErrorStripeColor != null) {
            return false;
        }
        return !(this.myForeground != null ? !this.myForeground.equals(that.myForeground) : that.myForeground != null);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    @NonNls
    public String toString() {
        return "AttributesFlyweight{myForeground=" + this.myForeground + ", myBackground=" + this.myBackground + ", myFontType=" + this.myFontType + ", myEffectColor=" + this.myEffectColor + ", myEffectType=" + (Object)((Object)this.myEffectType) + ", myErrorStripeColor=" + this.myErrorStripeColor + '}';
    }

    private static class FlyweightKey
    implements Cloneable {
        private Color foreground;
        private Color background;
        private int fontType;
        private Color effectColor;
        private EffectType effectType;
        private Color errorStripeColor;

        private FlyweightKey() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FlyweightKey)) {
                return false;
            }
            FlyweightKey key = (FlyweightKey)o;
            if (this.fontType != key.fontType) {
                return false;
            }
            if (this.background != null ? !this.background.equals(key.background) : key.background != null) {
                return false;
            }
            if (this.effectColor != null ? !this.effectColor.equals(key.effectColor) : key.effectColor != null) {
                return false;
            }
            if (this.effectType != key.effectType) {
                return false;
            }
            if (this.errorStripeColor != null ? !this.errorStripeColor.equals(key.errorStripeColor) : key.errorStripeColor != null) {
                return false;
            }
            return !(this.foreground != null ? !this.foreground.equals(key.foreground) : key.foreground != null);
        }

        public int hashCode() {
            return AttributesFlyweight.calcHashCode(this.foreground, this.background, this.fontType, this.effectColor, this.effectType, this.errorStripeColor);
        }

        protected FlyweightKey clone() {
            try {
                return (FlyweightKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

