/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiNameValuePairStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.NameValuePairElement;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiNameValuePairImpl
extends JavaStubPsiElement<PsiNameValuePairStub>
implements PsiNameValuePair.Detachable {
    private volatile Reference<PsiAnnotationMemberValue> myDetachedValue;
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl");

    public PsiNameValuePairImpl(@NotNull PsiNameValuePairStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "<init>"));
        }
        super(stub, JavaStubElementTypes.NAME_VALUE_PAIR);
    }

    public PsiNameValuePairImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public NameValuePairElement getNode() {
        NameValuePairElement nameValuePairElement = (NameValuePairElement)super.getNode();
        if (nameValuePairElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "getNode"));
        }
        return nameValuePairElement;
    }

    @Override
    public String getName() {
        PsiNameValuePairStub stub = (PsiNameValuePairStub)this.getStub();
        if (stub == null) {
            PsiIdentifier nameIdentifier = this.getNameIdentifier();
            return nameIdentifier == null ? null : nameIdentifier.getText();
        }
        return stub.getName();
    }

    @Override
    public String getLiteralValue() {
        PsiAnnotationMemberValue value = this.getValue();
        return value instanceof PsiLiteralExpression ? StringUtil.unquoteString(value.getText()) : null;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        ASTNode node = this.getNode().findChildByRole(9);
        return node == null ? null : (PsiIdentifier)node.getPsi();
    }

    @Override
    public PsiAnnotationMemberValue getValue() {
        PsiLiteralExpression child = this.getStubOrPsiChild(JavaStubElementTypes.LITERAL_EXPRESSION);
        if (child != null) {
            return child;
        }
        ASTNode node = this.getNode().findChildByRole(249);
        return node == null ? null : (PsiAnnotationMemberValue)node.getPsi();
    }

    @Override
    @NotNull
    public PsiAnnotationMemberValue setValue(@NotNull PsiAnnotationMemberValue newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "setValue"));
        }
        this.getValue().replace(newValue);
        PsiAnnotationMemberValue psiAnnotationMemberValue = this.getValue();
        if (psiAnnotationMemberValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "setValue"));
        }
        return psiAnnotationMemberValue;
    }

    @Override
    @Nullable
    public PsiAnnotationMemberValue getDetachedValue() {
        PsiNameValuePairStub stub = (PsiNameValuePairStub)this.getStub();
        if (stub != null) {
            String text = stub.getValue();
            PsiAnnotationMemberValue result2 = SoftReference.dereference(this.myDetachedValue);
            if (result2 == null) {
                PsiAnnotation anno = JavaPsiFacade.getElementFactory(this.getProject()).createAnnotationFromText("@F(" + text + ")", this);
                ((LightVirtualFile)anno.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
                result2 = anno.findAttributeValue(null);
                this.myDetachedValue = new SoftReference<PsiAnnotationMemberValue>(result2);
            }
            return result2;
        }
        return this.getValue();
    }

    @Override
    public void subtreeChanged() {
        this.myDetachedValue = null;
        super.subtreeChanged();
    }

    @Override
    public PsiReference getReference() {
        return new PsiReference(){

            @Nullable
            private PsiClass getReferencedClass() {
                LOG.assertTrue(PsiNameValuePairImpl.this.getParent() instanceof PsiAnnotationParameterList && PsiNameValuePairImpl.this.getParent().getParent() instanceof PsiAnnotation);
                PsiAnnotation annotation2 = (PsiAnnotation)PsiNameValuePairImpl.this.getParent().getParent();
                PsiJavaCodeReferenceElement nameRef = annotation2.getNameReferenceElement();
                if (nameRef == null) {
                    return null;
                }
                PsiElement target = nameRef.resolve();
                return target instanceof PsiClass ? (PsiClass)target : null;
            }

            @Override
            public PsiElement getElement() {
                PsiIdentifier nameIdentifier = PsiNameValuePairImpl.this.getNameIdentifier();
                if (nameIdentifier != null) {
                    return nameIdentifier;
                }
                return PsiNameValuePairImpl.this;
            }

            @Override
            public TextRange getRangeInElement() {
                PsiIdentifier id = PsiNameValuePairImpl.this.getNameIdentifier();
                if (id != null) {
                    return new TextRange(0, id.getTextLength());
                }
                return TextRange.EMPTY_RANGE;
            }

            @Override
            public PsiElement resolve() {
                PsiClass refClass = this.getReferencedClass();
                if (refClass == null) {
                    return null;
                }
                String name = PsiNameValuePairImpl.this.getName();
                if (name == null) {
                    name = "value";
                }
                MethodSignature signature2 = MethodSignatureUtil.createMethodSignature(name, PsiType.EMPTY_ARRAY, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
                return MethodSignatureUtil.findMethodBySignature(refClass, signature2, false);
            }

            @Override
            @NotNull
            public String getCanonicalText() {
                String name = PsiNameValuePairImpl.this.getName();
                String string = name != null ? name : "value";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1", "getCanonicalText"));
                }
                return string;
            }

            @Override
            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                PsiIdentifier nameIdentifier = PsiNameValuePairImpl.this.getNameIdentifier();
                if (nameIdentifier != null) {
                    PsiImplUtil.setName(nameIdentifier, newElementName);
                } else if (ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(PsiNameValuePairImpl.this.getNode().getFirstChildNode().getElementType())) {
                    PsiElementFactory factory = JavaPsiFacade.getInstance(PsiNameValuePairImpl.this.getProject()).getElementFactory();
                    nameIdentifier = factory.createIdentifier(newElementName);
                    PsiNameValuePairImpl.this.addBefore(nameIdentifier, SourceTreeToPsiMap.treeElementToPsi(PsiNameValuePairImpl.this.getNode().getFirstChildNode()));
                }
                return PsiNameValuePairImpl.this;
            }

            @Override
            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1", "bindToElement"));
                }
                throw new IncorrectOperationException("Not implemented");
            }

            @Override
            public boolean isReferenceTo(PsiElement element) {
                return element instanceof PsiMethod && element.equals(this.resolve());
            }

            @Override
            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            @Override
            public boolean isSoft() {
                return false;
            }
        };
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitNameValuePair(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiNameValuePair";
    }
}

