/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.pom.PomManager;
import org.jetbrains.kotlin.com.intellij.pom.PomModel;
import org.jetbrains.kotlin.com.intellij.pom.event.PomModelEvent;
import org.jetbrains.kotlin.com.intellij.pom.impl.PomTransactionBase;
import org.jetbrains.kotlin.com.intellij.pom.tree.TreeAspect;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.TreeChangeEvent;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeCopyHandler;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeGenerator;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.containers.HashMap;

public class ChangeUtil {
    public static void encodeInformation(TreeElement element) {
        ChangeUtil.encodeInformation(element, element);
    }

    private static void encodeInformation(TreeElement element, ASTNode original) {
        DebugUtil.startPsiModification(null);
        try {
            ChangeUtil.encodeInformation(element, original, new HashMap<Object, Object>());
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    private static void encodeInformation(TreeElement element, ASTNode original, Map<Object, Object> state2) {
        for (TreeCopyHandler handler2 : Extensions.getExtensions(TreeCopyHandler.EP_NAME)) {
            handler2.encodeInformation(element, original, state2);
        }
        if (original instanceof CompositeElement) {
            TreeElement child = element.getFirstChildNode();
            ASTNode child1 = original.getFirstChildNode();
            while (child != null) {
                ChangeUtil.encodeInformation(child, child1, state2);
                child = child.getTreeNext();
                child1 = child1.getTreeNext();
            }
        }
    }

    public static TreeElement decodeInformation(TreeElement element) {
        DebugUtil.startPsiModification(null);
        try {
            TreeElement treeElement = ChangeUtil.decodeInformation(element, new HashMap<Object, Object>());
            return treeElement;
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    private static TreeElement decodeInformation(TreeElement element, Map<Object, Object> state2) {
        for (TreeElement child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            child = ChangeUtil.decodeInformation(child, state2);
        }
        for (TreeCopyHandler handler2 : Extensions.getExtensions(TreeCopyHandler.EP_NAME)) {
            TreeElement handled = handler2.decodeInformation(element, state2);
            if (handled == null) continue;
            return handled;
        }
        return element;
    }

    @NotNull
    public static LeafElement copyLeafWithText(@NotNull LeafElement original, @NotNull String text) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ChangeUtil", "copyLeafWithText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ChangeUtil", "copyLeafWithText"));
        }
        LeafElement element = ASTFactory.leaf(original.getElementType(), text);
        original.copyCopyableDataTo(element);
        ChangeUtil.encodeInformation(element, original);
        TreeUtil.clearCaches(element);
        ChangeUtil.saveIndentationToCopy(original, element);
        LeafElement leafElement = element;
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ChangeUtil", "copyLeafWithText"));
        }
        return leafElement;
    }

    public static TreeElement copyElement(@NotNull TreeElement original, CharTable table) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ChangeUtil", "copyElement"));
        }
        CompositeElement treeParent = original.getTreeParent();
        return ChangeUtil.copyElement(original, treeParent == null ? null : treeParent.getPsi(), table);
    }

    public static TreeElement copyElement(TreeElement original, PsiElement context, CharTable table) {
        TreeElement element = (TreeElement)original.clone();
        PsiManagerEx manager = original.getManager();
        DummyHolderFactory.createHolder(manager, element, context, table).getTreeElement();
        ChangeUtil.encodeInformation(element, original);
        TreeUtil.clearCaches(element);
        ChangeUtil.saveIndentationToCopy(original, element);
        return element;
    }

    private static void saveIndentationToCopy(TreeElement original, TreeElement element) {
        if (original == null || element == null || CodeEditUtil.isNodeGenerated(original)) {
            return;
        }
        int indentation = CodeEditUtil.getOldIndentation(original);
        if (indentation < 0) {
            CodeEditUtil.saveWhitespacesInfo(original);
        }
        CodeEditUtil.setOldIndentation(element, CodeEditUtil.getOldIndentation(original));
        if (indentation < 0) {
            CodeEditUtil.setOldIndentation(original, -1);
        }
    }

    public static TreeElement copyToElement(PsiElement original) {
        DummyHolder holder = DummyHolderFactory.createHolder(original.getManager(), null, original.getLanguage());
        FileElement holderElement = holder.getTreeElement();
        TreeElement treeElement = ChangeUtil.generateTreeElement(original, holderElement.getCharTable(), original.getManager());
        holderElement.rawAddChildren(treeElement);
        TreeUtil.clearCaches(holderElement);
        ChangeUtil.saveIndentationToCopy((TreeElement)original.getNode(), treeElement);
        return treeElement;
    }

    @Nullable
    public static TreeElement generateTreeElement(@Nullable PsiElement original, @NotNull CharTable table, @NotNull PsiManager manager) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ChangeUtil", "generateTreeElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ChangeUtil", "generateTreeElement"));
        }
        if (original == null) {
            return null;
        }
        PsiUtilCore.ensureValid(original);
        if (SourceTreeToPsiMap.hasTreeElement(original)) {
            return ChangeUtil.copyElement((TreeElement)SourceTreeToPsiMap.psiElementToTree(original), table);
        }
        for (TreeGenerator generator : Extensions.getExtensions(TreeGenerator.EP_NAME)) {
            TreeElement element = generator.generateTreeFor(original, table, manager);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public static void prepareAndRunChangeAction(final ChangeAction action, final TreeElement changedElement) {
        final FileElement changedFile = TreeUtil.getFileElement(changedElement);
        PsiManagerEx manager = changedFile.getManager();
        final PomModel model = PomManager.getModel(manager.getProject());
        final TreeAspect treeAspect = model.getModelAspect(TreeAspect.class);
        model.runTransaction(new PomTransactionBase(changedElement.getPsi(), treeAspect){

            @Override
            public PomModelEvent runInner() {
                PomModelEvent event = new PomModelEvent(model);
                TreeChangeEventImpl destinationTreeChange = new TreeChangeEventImpl(treeAspect, changedFile);
                event.registerChangeSet(treeAspect, destinationTreeChange);
                action.makeChange(destinationTreeChange);
                changedElement.clearCaches();
                if (changedElement instanceof CompositeElement) {
                    ((CompositeElement)changedElement).subtreeChanged();
                }
                return event;
            }
        });
    }

    public static interface ChangeAction {
        public void makeChange(TreeChangeEvent var1);
    }
}

