/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.Deprecation;
import org.jetbrains.kotlin.resolve.DeprecationUtilKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/DeprecatedClassifierUsageChecker;", "Lorg/jetbrains/kotlin/resolve/ClassifierUsageChecker;", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "kotlin-compiler"})
public final class DeprecatedClassifierUsageChecker
implements ClassifierUsageChecker {
    @Override
    public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        KtSuperTypeCallEntry superExpression;
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        KtAnnotationEntry annotationEntry = KtStubbedPsiUtil.getPsiOrStubParent(element, KtAnnotationEntry.class, true);
        if (annotationEntry != null) {
            KtConstructorCalleeExpression ktConstructorCalleeExpression = annotationEntry.getCalleeExpression();
            if (ktConstructorCalleeExpression == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual(ktConstructorCalleeExpression.getConstructorReferenceExpression(), element)) {
                return;
            }
        }
        if ((superExpression = KtStubbedPsiUtil.getPsiOrStubParent(element, KtSuperTypeCallEntry.class, true)) != null && Intrinsics.areEqual(superExpression.getCalleeExpression().getConstructorReferenceExpression(), element)) {
            return;
        }
        Deprecation deprecation = DeprecationUtilKt.getDeprecation(targetDescriptor);
        if (deprecation != null) {
            trace.report(DeprecationUtilKt.createDeprecationDiagnostic(element, deprecation));
        }
    }
}

