/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.util.NotNullFunction;

public class NotNullLazyKey<T, H extends UserDataHolder>
extends Key<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("NotNullLazyKey");
    private final NotNullFunction<H, T> myFunction;

    private NotNullLazyKey(@NotNull @NonNls String name, @NotNull NotNullFunction<H, T> function) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/openapi/util/NotNullLazyKey", "<init>"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/com/intellij/openapi/util/NotNullLazyKey", "<init>"));
        }
        super(name);
        this.myFunction = function;
    }

    @NotNull
    public final T getValue(@NotNull H h) {
        if (h == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "h", "org/jetbrains/kotlin/com/intellij/openapi/util/NotNullLazyKey", "getValue"));
        }
        Object data = h.getUserData(this);
        if (data == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            data = this.myFunction.fun(h);
            if (stamp.mayCacheNow()) {
                h.putUserData(this, data);
            }
        }
        Object t = data;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/NotNullLazyKey", "getValue"));
        }
        return t;
    }

    public static <T, H extends UserDataHolder> NotNullLazyKey<T, H> create(@NonNls @NotNull String name, @NotNull NotNullFunction<H, T> function) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/openapi/util/NotNullLazyKey", "create"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/com/intellij/openapi/util/NotNullLazyKey", "create"));
        }
        return new NotNullLazyKey<T, H>(name, function);
    }
}

