/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.CompositePackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.DeclarationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.LazyPackageViewDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependencies;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependenciesImpl;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.platform.PlatformToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.resolve.ImportPath;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleDescriptorImpl
extends DeclarationDescriptorImpl
implements ModuleDescriptor,
ModuleParameters {
    private ModuleDependencies dependencies;
    private PackageFragmentProvider packageFragmentProviderForModuleContent;
    private final MemoizedFunctionToNotNull<FqName, PackageViewDescriptor> packages;
    private final Lazy packageFragmentProviderForWholeModuleWithDependencies$delegate;
    private final LinkedHashSet<ModuleDescriptor> friendModules;
    private final StorageManager storageManager;
    private final ModuleParameters moduleParameters;
    @NotNull
    private final KotlinBuiltIns builtIns;
    private final Map<ModuleDescriptor.Capability<?>, Object> capabilities;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @Override
    @NotNull
    public PackageViewDescriptor getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return (PackageViewDescriptor)this.packages.invoke(fqName2);
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(nameFilter, "nameFilter");
        return this.getPackageFragmentProvider().getSubPackagesOf(fqName2, nameFilter);
    }

    private final CompositePackageFragmentProvider getPackageFragmentProviderForWholeModuleWithDependencies() {
        Lazy lazy = this.packageFragmentProviderForWholeModuleWithDependencies$delegate;
        ModuleDescriptorImpl moduleDescriptorImpl = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (CompositePackageFragmentProvider)lazy.getValue();
    }

    private final boolean isInitialized() {
        return this.packageFragmentProviderForModuleContent != null;
    }

    public final void setDependencies(@NotNull ModuleDependencies dependencies) {
        Intrinsics.checkParameterIsNotNull(dependencies, "dependencies");
        boolean bl = this.dependencies == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Dependencies of " + this.getId() + " were already set";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.dependencies = dependencies;
    }

    public final void setDependencies(ModuleDescriptorImpl ... descriptors) {
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        this.setDependencies(ArraysKt.toList((Object[])descriptors));
    }

    public final void setDependencies(@NotNull List<ModuleDescriptorImpl> descriptors) {
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        this.setDependencies(new ModuleDependenciesImpl(descriptors));
    }

    private final String getId() {
        String string = this.getName().toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "name.toString()");
        return string;
    }

    public final void initialize(@NotNull PackageFragmentProvider providerForModuleContent) {
        Intrinsics.checkParameterIsNotNull(providerForModuleContent, "providerForModuleContent");
        boolean bl = !this.isInitialized();
        if (_Assertions.ENABLED && !bl) {
            String string = "Attempt to initialize module " + this.getId() + " twice";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.packageFragmentProviderForModuleContent = providerForModuleContent;
    }

    @NotNull
    public final PackageFragmentProvider getPackageFragmentProvider() {
        return this.getPackageFragmentProviderForWholeModuleWithDependencies();
    }

    @Override
    public boolean isFriend(@NotNull ModuleDescriptor other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return Intrinsics.areEqual(other, this) || this.friendModules.contains(other);
    }

    public final void addFriend(@NotNull ModuleDescriptorImpl friend) {
        Intrinsics.checkParameterIsNotNull(friend, "friend");
        boolean bl = Intrinsics.areEqual(friend, this) ^ true;
        if (_Assertions.ENABLED && !bl) {
            String string = "Attempt to make module " + this.getId() + " a friend to itself";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.friendModules.add(friend);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull ModuleDescriptor.Capability<T> capability) {
        Intrinsics.checkParameterIsNotNull(capability, "capability");
        Object object = this.capabilities.get(capability);
        if (!(object instanceof Object)) {
            object = null;
        }
        return (T)object;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @JvmOverloads
    public ModuleDescriptorImpl(@NotNull Name moduleName, @NotNull StorageManager storageManager, @NotNull ModuleParameters moduleParameters, @NotNull KotlinBuiltIns builtIns, @NotNull Map<ModuleDescriptor.Capability<?>, ? extends Object> capabilities) {
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(moduleParameters, "moduleParameters");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        Intrinsics.checkParameterIsNotNull(capabilities, "capabilities");
        super(Annotations.Companion.getEMPTY(), moduleName);
        this.storageManager = storageManager;
        this.moduleParameters = moduleParameters;
        this.builtIns = builtIns;
        this.capabilities = capabilities;
        if (!moduleName.isSpecial()) {
            throw (Throwable)new IllegalArgumentException("Module name must be special: " + moduleName);
        }
        this.packages = this.storageManager.createMemoizedFunction((Function1)new Function1<FqName, LazyPackageViewDescriptorImpl>(this){
            final /* synthetic */ ModuleDescriptorImpl this$0;

            @NotNull
            public final LazyPackageViewDescriptorImpl invoke(@NotNull FqName fqName2) {
                Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
                return new LazyPackageViewDescriptorImpl(this.this$0, fqName2, ModuleDescriptorImpl.access$getStorageManager$p(this.this$0));
            }
            {
                this.this$0 = moduleDescriptorImpl;
                super(1);
            }
        });
        this.packageFragmentProviderForWholeModuleWithDependencies$delegate = LazyKt.lazy((Function0)new Function0<CompositePackageFragmentProvider>(this){
            final /* synthetic */ ModuleDescriptorImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CompositePackageFragmentProvider invoke() {
                List list2;
                void destination$iv$iv;
                void $receiver$iv$iv;
                CompositePackageFragmentProvider compositePackageFragmentProvider;
                Object element$iv2;
                Iterable $receiver$iv;
                ModuleDependencies $receiver$iv2 = ModuleDescriptorImpl.access$getDependencies$p(this.this$0);
                ModuleDependencies moduleDependencies = $receiver$iv2;
                if (moduleDependencies == null) {
                    AssertionError assertionError;
                    AssertionError assertionError2 = assertionError;
                    AssertionError assertionError3 = assertionError;
                    String string = "Dependencies of module " + ModuleDescriptorImpl.access$getId$p(this.this$0) + " were not set before querying module content";
                    assertionError2((Object)string);
                    throw (Throwable)((Object)assertionError3);
                }
                ModuleDependencies moduleDependencies2 = moduleDependencies;
                List<ModuleDescriptorImpl> dependenciesDescriptors = moduleDependencies2.getDescriptors();
                boolean $i$a$1$sure22 = dependenciesDescriptors.contains(this.this$0);
                if (_Assertions.ENABLED && !$i$a$1$sure22) {
                    String string = "Module " + ModuleDescriptorImpl.access$getId$p(this.this$0) + " is not contained in his own dependencies, this is probably a misconfiguration";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Iterable $i$a$1$sure22 = dependenciesDescriptors;
                for (Object element$iv2 : $receiver$iv) {
                    ModuleDescriptorImpl dependency = (ModuleDescriptorImpl)element$iv2;
                    boolean bl = ModuleDescriptorImpl.access$isInitialized$p(dependency);
                    if (!_Assertions.ENABLED || bl) continue;
                    String string = "Dependency module " + ModuleDescriptorImpl.access$getId$p(dependency) + " was not initialized by the time contents of dependent module " + ModuleDescriptorImpl.access$getId$p(this.this$0) + " were queried";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                $receiver$iv = dependenciesDescriptors;
                CompositePackageFragmentProvider compositePackageFragmentProvider2 = compositePackageFragmentProvider;
                CompositePackageFragmentProvider compositePackageFragmentProvider3 = compositePackageFragmentProvider;
                Iterable $i$a$1$assert = $receiver$iv;
                element$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    PackageFragmentProvider packageFragmentProvider;
                    void it;
                    ModuleDescriptorImpl moduleDescriptorImpl = (ModuleDescriptorImpl)item$iv$iv;
                    list2 = destination$iv$iv;
                    if (ModuleDescriptorImpl.access$getPackageFragmentProviderForModuleContent$p((ModuleDescriptorImpl)it) == null) {
                        Intrinsics.throwNpe();
                    }
                    list2.add(packageFragmentProvider);
                }
                list2 = (List)destination$iv$iv;
                compositePackageFragmentProvider2(list2);
                return compositePackageFragmentProvider3;
            }
            {
                this.this$0 = moduleDescriptorImpl;
                super(0);
            }
        });
        this.friendModules = new LinkedHashSet();
    }

    @JvmOverloads
    public /* synthetic */ ModuleDescriptorImpl(Name name, StorageManager storageManager, ModuleParameters moduleParameters, KotlinBuiltIns kotlinBuiltIns, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(name, storageManager, moduleParameters, kotlinBuiltIns, map2);
    }

    @JvmOverloads
    public ModuleDescriptorImpl(@NotNull Name moduleName, @NotNull StorageManager storageManager, @NotNull ModuleParameters moduleParameters, @NotNull KotlinBuiltIns builtIns) {
        this(moduleName, storageManager, moduleParameters, builtIns, null, 16, null);
    }

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(ModuleDescriptorImpl.class), "packageFragmentProviderForWholeModuleWithDependencies", "getPackageFragmentProviderForWholeModuleWithDependencies()Lorg/jetbrains/kotlin/descriptors/impl/CompositePackageFragmentProvider;"))};
    }

    @Override
    @Nullable
    public DeclarationDescriptor getContainingDeclaration() {
        return ModuleDescriptor.DefaultImpls.getContainingDeclaration(this);
    }

    @Override
    public <R, D> R accept(@NotNull DeclarationDescriptorVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return ModuleDescriptor.DefaultImpls.accept(this, visitor2, data);
    }

    @Override
    @NotNull
    public ModuleDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
        Intrinsics.checkParameterIsNotNull(substitutor2, "substitutor");
        return ModuleDescriptor.DefaultImpls.substitute(this, substitutor2);
    }

    @Override
    @NotNull
    public List<ImportPath> getDefaultImports() {
        return this.moduleParameters.getDefaultImports();
    }

    @Override
    @NotNull
    public PlatformToKotlinClassMap getPlatformToKotlinClassMap() {
        return this.moduleParameters.getPlatformToKotlinClassMap();
    }

    @NotNull
    public static final /* synthetic */ StorageManager access$getStorageManager$p(ModuleDescriptorImpl $this) {
        return $this.storageManager;
    }

    @Nullable
    public static final /* synthetic */ ModuleDependencies access$getDependencies$p(ModuleDescriptorImpl $this) {
        return $this.dependencies;
    }

    public static final /* synthetic */ void access$setDependencies$p(ModuleDescriptorImpl $this, @Nullable ModuleDependencies moduleDependencies) {
        $this.dependencies = moduleDependencies;
    }

    @NotNull
    public static final /* synthetic */ String access$getId$p(ModuleDescriptorImpl $this) {
        return $this.getId();
    }

    public static final /* synthetic */ boolean access$isInitialized$p(ModuleDescriptorImpl $this) {
        return $this.isInitialized();
    }

    @Nullable
    public static final /* synthetic */ PackageFragmentProvider access$getPackageFragmentProviderForModuleContent$p(ModuleDescriptorImpl $this) {
        return $this.packageFragmentProviderForModuleContent;
    }

    public static final /* synthetic */ void access$setPackageFragmentProviderForModuleContent$p(ModuleDescriptorImpl $this, @Nullable PackageFragmentProvider packageFragmentProvider) {
        $this.packageFragmentProviderForModuleContent = packageFragmentProvider;
    }
}

