/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolveUtilKt;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallExpressionElement;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 H2\u00020\u0001:\u0001HB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u0019J4\u0010!\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\"2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J@\u0010'\u001a\u0016\u0012\u0004\u0012\u00020)\u0012\f\u0012\n\u0012\u0004\u0012\u00020+\u0018\u00010*0(2\u0006\u0010,\u001a\u00020-2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030.2\u0006\u0010/\u001a\u0002002\u0006\u0010#\u001a\u00020$H\u0002J \u00101\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\"2\u0006\u00102\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u0002062\b\u0010\u001d\u001a\u0004\u0018\u00010\"2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u0019J4\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u0002062\b\u0010\u001d\u001a\u0004\u0018\u00010\"2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J4\u00107\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\"2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J:\u0010:\u001a\u0010\u0012\u0004\u0012\u00020)\u0012\u0006\u0012\u0004\u0018\u00010;0(2\u0006\u00105\u001a\u0002062\b\u0010\u001d\u001a\u0004\u0018\u00010\"2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010<\u001a\u00020=2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010>\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010?\u001a\u00020=2\u0006\u0010@\u001a\u00020A2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u000206J\u0010\u0010E\u001a\u00020=2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001a\u0010F\u001a\b\u0012\u0004\u0012\u0002030G*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver;", "", "callResolver", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "symbolUsageValidator", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "(Lorg/jetbrains/kotlin/resolve/calls/CallResolver;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;)V", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "checkSelectorTypeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "qualified", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "selectorTypeInfo", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getCallExpressionTypeInfo", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "callOperationNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "getCallExpressionTypeInfoWithoutFinalTypeCheck", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "initialDataFlowInfoForArguments", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getQualifiedExpressionTypeInfo", "expression", "getResolvedCallForFunction", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CheckArgumentTypesMode;", "getSafeOrUnsafeSelectorTypeInfo", "element", "Lorg/jetbrains/kotlin/resolve/calls/CallExpressionElement;", "getSimpleNameExpressionTypeInfo", "nameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getUnsafeSelectorTypeInfo", "selectorExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getVariableType", "Lorg/jetbrains/kotlin/types/KotlinType;", "recordResultTypeInfo", "", "resultTypeInfo", "resolveDeferredReceiverInQualifiedExpression", "qualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "resolveSimpleName", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "setExpressionTypingServices", "elementChain", "", "Companion", "kotlin-compiler"})
public final class CallExpressionResolver {
    private ExpressionTypingServices expressionTypingServices;
    private final CallResolver callResolver;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final ArgumentTypeResolver argumentTypeResolver;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final KotlinBuiltIns builtIns;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final SymbolUsageValidator symbolUsageValidator;
    public static final Companion Companion = new Companion(null);

    @Inject
    public final void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkParameterIsNotNull(expressionTypingServices, "expressionTypingServices");
        this.expressionTypingServices = expressionTypingServices;
    }

    private final Pair<Boolean, ResolvedCall<FunctionDescriptor>> getResolvedCallForFunction(Call call, ResolutionContext<?> context, CheckArgumentTypesMode checkArguments, DataFlowInfo initialDataFlowInfoForArguments) {
        OverloadResolutionResults<FunctionDescriptor> results = this.callResolver.resolveFunctionCall(BasicCallResolutionContext.create(context, call, checkArguments, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call)));
        return !results.isNothing() ? new Pair<Boolean, ResolvedCall<FunctionDescriptor>>(true, OverloadResolutionResultsUtil.getResultingCall(results, context.contextDependency)) : new Pair<Boolean, Object>(false, null);
    }

    private final Pair<Boolean, KotlinType> getVariableType(KtSimpleNameExpression nameExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context) {
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as local variable or property", nameExpression);
        Call call = CallMaker.makePropertyCall(receiver, callOperationNode, nameExpression);
        BasicCallResolutionContext contextForVariable = BasicCallResolutionContext.create(context.replaceTraceAndCache(temporaryForVariable), call, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        OverloadResolutionResults<VariableDescriptor> resolutionResult = this.callResolver.resolveSimpleProperty(contextForVariable);
        boolean isLHSOfDot = KtPsiUtil.isLHSOfDot(nameExpression);
        if (!resolutionResult.isNothing() && Intrinsics.areEqual((Object)resolutionResult.getResultCode(), (Object)OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER) ^ true) {
            boolean isQualifier;
            boolean bl = isQualifier = isLHSOfDot && resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject;
            if (!isQualifier) {
                temporaryForVariable.commit();
                return new Pair<Boolean, KotlinType>(true, resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : (KotlinType)null);
            }
        }
        temporaryForVariable.commit();
        return new Pair<Boolean, KotlinType>(!resolutionResult.isNothing(), resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : (KotlinType)null);
    }

    @NotNull
    public final KotlinTypeInfo getSimpleNameExpressionTypeInfo(@NotNull KtSimpleNameExpression nameExpression, @Nullable Receiver receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(nameExpression, "nameExpression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        return this.getSimpleNameExpressionTypeInfo(nameExpression, receiver, callOperationNode, context, dataFlowInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeInfo getSimpleNameExpressionTypeInfo(KtSimpleNameExpression nameExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context, DataFlowInfo initialDataFlowInfoForArguments) {
        block7: {
            Object object;
            TemporaryTraceAndCache temporaryForVariable;
            block6: {
                ExpressionTypingContext contextForQualifier;
                void resolveResult;
                void notNothing;
                temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable", nameExpression);
                ExpressionTypingContext expressionTypingContext = (ExpressionTypingContext)context.replaceTraceAndCache(temporaryForVariable);
                Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext, "context.replaceTraceAndCache(temporaryForVariable)");
                Pair<Boolean, KotlinType> pair = this.getVariableType(nameExpression, receiver, callOperationNode, expressionTypingContext);
                boolean bl = pair.component1();
                KotlinType kotlinType = pair.component2();
                pair = null;
                if (notNothing != false) {
                    void type2;
                    temporaryForVariable.commit();
                    return TypeInfoFactoryKt.createTypeInfo((KotlinType)type2, initialDataFlowInfoForArguments);
                }
                Call call = CallMaker.makeCall(nameExpression, receiver, callOperationNode, nameExpression, CollectionsKt.emptyList());
                TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function", nameExpression);
                ExpressionTypingContext newContext = (ExpressionTypingContext)context.replaceTraceAndCache(temporaryForFunction);
                Call call2 = call;
                Intrinsics.checkExpressionValueIsNotNull(call2, "call");
                ResolutionContext resolutionContext = newContext;
                Intrinsics.checkExpressionValueIsNotNull(resolutionContext, "newContext");
                Pair<Boolean, ResolvedCall<FunctionDescriptor>> pair2 = this.getResolvedCallForFunction(call2, resolutionContext, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
                boolean bl2 = pair2.component1();
                ResolvedCall<FunctionDescriptor> resolvedCall2 = pair2.component2();
                pair2 = null;
                if (resolveResult != false) {
                    FunctionDescriptor functionDescriptor;
                    void resolvedCall3;
                    void v3 = resolvedCall3;
                    FunctionDescriptor functionDescriptor2 = functionDescriptor = v3 != null ? (FunctionDescriptor)v3.getResultingDescriptor() : null;
                    if (!(functionDescriptor instanceof ConstructorDescriptor)) {
                        temporaryForFunction.commit();
                        boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                        context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)nameExpression), nameExpression, hasValueParameters));
                        FunctionDescriptor functionDescriptor3 = functionDescriptor;
                        return TypeInfoFactoryKt.createTypeInfo(functionDescriptor3 != null ? functionDescriptor3.getReturnType() : null, context);
                    }
                }
                TemporaryTraceAndCache temporaryForQualifier = TemporaryTraceAndCache.create(context, "trace to resolve as qualifier", nameExpression);
                ExpressionTypingContext expressionTypingContext2 = contextForQualifier = (ExpressionTypingContext)context.replaceTraceAndCache(temporaryForQualifier);
                Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext2, "contextForQualifier");
                object = this.qualifiedExpressionResolver.resolveNameExpressionAsQualifierForDiagnostics(nameExpression, receiver, expressionTypingContext2);
                if (object == null) break block6;
                Qualifier qualifier = object;
                Qualifier it = qualifier;
                ExpressionTypingContext expressionTypingContext3 = contextForQualifier;
                Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext3, "contextForQualifier");
                QualifiedExpressionResolveUtilKt.resolveQualifierAsStandaloneExpression(it, expressionTypingContext3, this.symbolUsageValidator);
                temporaryForQualifier.commit();
                object = Unit.INSTANCE;
                if (object != null) break block7;
            }
            temporaryForVariable.commit();
            object = Unit.INSTANCE;
        }
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    @NotNull
    public final KotlinTypeInfo getCallExpressionTypeInfo(@NotNull KtCallExpression callExpression, @Nullable ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(callExpression, "callExpression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Receiver receiver2 = receiver;
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        KotlinTypeInfo typeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck(callExpression, receiver2, callOperationNode, context, dataFlowInfo);
        if (Intrinsics.areEqual((Object)context.contextDependency, (Object)ContextDependency.INDEPENDENT)) {
            this.dataFlowAnalyzer.checkType(typeInfo.getType(), (KtExpression)callExpression, (ResolutionContext)context);
        }
        return typeInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeInfo getCallExpressionTypeInfoWithoutFinalTypeCheck(KtCallExpression callExpression, Receiver receiver, ASTNode callOperationNode, ExpressionTypingContext context, DataFlowInfo initialDataFlowInfoForArguments) {
        void resolveResult;
        Call call = CallMaker.makeCall(receiver, callOperationNode, callExpression);
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function call", callExpression);
        Call call2 = call;
        Intrinsics.checkExpressionValueIsNotNull(call2, "call");
        Object Context2 = context.replaceTraceAndCache(temporaryForFunction);
        Intrinsics.checkExpressionValueIsNotNull(Context2, "context.replaceTraceAndCache(temporaryForFunction)");
        Pair<Boolean, ResolvedCall<FunctionDescriptor>> pair = this.getResolvedCallForFunction(call2, (ResolutionContext<?>)Context2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
        boolean bl = pair.component1();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = pair.component2();
        pair = null;
        if (resolveResult != false) {
            DataFlowInfo resultFlowInfo;
            void resolvedCall3;
            void v2 = resolvedCall3;
            FunctionDescriptor functionDescriptor = v2 != null ? (FunctionDescriptor)v2.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            if (callExpression.getValueArgumentList() == null && callExpression.getLambdaArguments().isEmpty()) {
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)callExpression), callExpression, hasValueParameters));
            }
            if (functionDescriptor == null) {
                return TypeInfoFactoryKt.noTypeInfo(context);
            }
            if (functionDescriptor instanceof ConstructorDescriptor) {
                ClassDescriptor containingDescriptor = ((ConstructorDescriptor)functionDescriptor).getContainingDeclaration();
                if (DescriptorUtils.isAnnotationClass(containingDescriptor)) {
                    BindingTrace bindingTrace = context.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
                    if (!CallExpressionResolver.Companion.canInstantiateAnnotationClass(callExpression, bindingTrace)) {
                        context.trace.report(Errors.ANNOTATION_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                    }
                }
                if (DescriptorUtils.isEnumClass(containingDescriptor)) {
                    context.trace.report(Errors.ENUM_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
                if (containingDescriptor instanceof ClassDescriptor && containingDescriptor.getModality() == Modality.SEALED) {
                    context.trace.report(Errors.SEALED_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
            }
            KotlinType type2 = functionDescriptor.getReturnType();
            List<KtValueArgument> arguments2 = callExpression.getValueArguments();
            void v4 = resolvedCall3;
            if (v4 == null) {
                Intrinsics.throwNpe();
            }
            DataFlowInfo jumpFlowInfo = resultFlowInfo = v4.getDataFlowInfoForArguments().getResultInfo();
            boolean jumpOutPossible = false;
            for (KtValueArgument argument : arguments2) {
                KotlinTypeInfo argTypeInfo = (KotlinTypeInfo)context.trace.get(BindingContext.EXPRESSION_TYPE_INFO, argument.getArgumentExpression());
                if (argTypeInfo == null || !argTypeInfo.getJumpOutPossible()) continue;
                jumpOutPossible = true;
                jumpFlowInfo = argTypeInfo.getJumpFlowInfo();
                break;
            }
            DataFlowInfo dataFlowInfo = resultFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "resultFlowInfo");
            DataFlowInfo dataFlowInfo2 = jumpFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo2, "jumpFlowInfo");
            return TypeInfoFactoryKt.createTypeInfo(type2, dataFlowInfo, jumpOutPossible, dataFlowInfo2);
        }
        KtExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression && callExpression.getTypeArgumentList() == null) {
            void notNothing;
            TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable with 'invoke' call", callExpression);
            KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)calleeExpression;
            ExpressionTypingContext expressionTypingContext = (ExpressionTypingContext)context.replaceTraceAndCache(temporaryForVariable);
            Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext, "context.replaceTraceAndCache(temporaryForVariable)");
            Pair<Boolean, KotlinType> jumpFlowInfo = this.getVariableType(ktSimpleNameExpression, receiver, callOperationNode, expressionTypingContext);
            boolean arguments2 = jumpFlowInfo.component1();
            KotlinType resultFlowInfo = jumpFlowInfo.component2();
            jumpFlowInfo = null;
            Qualifier qualifier = (Qualifier)temporaryForVariable.trace.get(BindingContext.QUALIFIER, calleeExpression);
            if (!(notNothing == false || qualifier != null && qualifier instanceof PackageQualifier)) {
                void type3;
                KtElement ktElement = callExpression;
                BindingContext bindingContext = temporaryForVariable.trace.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull(bindingContext, "temporaryForVariable.trace.bindingContext");
                ResolvedCall<? extends CallableDescriptor> resolvedCall4 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
                ResolvedCall<? extends CallableDescriptor> it = resolvedCall4;
                ResolvedCall<? extends CallableDescriptor> resolvedCall5 = it;
                if (!(resolvedCall5 instanceof ResolvedCallImpl)) {
                    resolvedCall5 = null;
                }
                ResolvedCallImpl resolvedCallImpl = (ResolvedCallImpl)resolvedCall5;
                if (resolvedCallImpl != null) {
                    resolvedCallImpl.addStatus(ResolutionStatus.OTHER_ERROR);
                }
                temporaryForVariable.commit();
                BindingTrace bindingTrace = context.trace;
                PsiElement psiElement = calleeExpression;
                KotlinType kotlinType = type3;
                if (kotlinType == null) {
                    kotlinType = ErrorUtils.createErrorType("");
                }
                bindingTrace.report(Errors.FUNCTION_EXPECTED.on((KtExpression)psiElement, calleeExpression, kotlinType));
                this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(BasicCallResolutionContext.create(context, call, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call)), ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
                return TypeInfoFactoryKt.noTypeInfo(context);
            }
        }
        temporaryForFunction.commit();
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    private final List<CallExpressionElement> elementChain(@NotNull KtQualifiedExpression $receiver, ExpressionTypingContext context) {
        return this.qualifiedExpressionResolver.resolveQualifierInExpressionAndUnroll($receiver, context, (Function1<? super KtSimpleNameExpression, Boolean>)new Function1<KtSimpleNameExpression, Boolean>(this, context){
            final /* synthetic */ CallExpressionResolver this$0;
            final /* synthetic */ ExpressionTypingContext $context;

            public final boolean invoke(@NotNull KtSimpleNameExpression nameExpression) {
                OverloadResolutionResults.Code code;
                Intrinsics.checkParameterIsNotNull(nameExpression, "nameExpression");
                OverloadResolutionResults<VariableDescriptor> resolutionResult = this.this$0.resolveSimpleName(this.$context, nameExpression);
                return resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject ? false : !Intrinsics.areEqual((Object)((Object)(code = resolutionResult.getResultCode())), (Object)((Object)OverloadResolutionResults.Code.NAME_NOT_FOUND)) && !Intrinsics.areEqual((Object)((Object)code), (Object)((Object)OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER));
            }
            {
                this.this$0 = callExpressionResolver;
                this.$context = expressionTypingContext;
                super(1);
            }
        });
    }

    @NotNull
    public final OverloadResolutionResults<VariableDescriptor> resolveSimpleName(@NotNull ExpressionTypingContext context, @NotNull KtSimpleNameExpression expression) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as local variable or property", expression);
        Call call = CallMaker.makePropertyCall(null, null, expression);
        BasicCallResolutionContext contextForVariable = BasicCallResolutionContext.create(context.replaceTraceAndCache(temporaryForVariable), call, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.callResolver.resolveSimpleProperty(contextForVariable);
        Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResults, "callResolver.resolveSimp\u2026perty(contextForVariable)");
        return overloadResolutionResults;
    }

    private final KotlinTypeInfo getUnsafeSelectorTypeInfo(Receiver receiver, ASTNode callOperationNode, KtExpression selectorExpression, ExpressionTypingContext context, DataFlowInfo initialDataFlowInfoForArguments) {
        KotlinTypeInfo kotlinTypeInfo;
        KtExpression ktExpression = selectorExpression;
        if (ktExpression instanceof KtCallExpression) {
            kotlinTypeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck((KtCallExpression)selectorExpression, receiver, callOperationNode, context, initialDataFlowInfoForArguments);
        } else if (ktExpression instanceof KtSimpleNameExpression) {
            kotlinTypeInfo = this.getSimpleNameExpressionTypeInfo((KtSimpleNameExpression)selectorExpression, receiver, callOperationNode, context, initialDataFlowInfoForArguments);
        } else if (ktExpression instanceof KtExpression) {
            ExpressionTypingServices expressionTypingServices = this.expressionTypingServices;
            if (expressionTypingServices == null) {
                Intrinsics.throwUninitializedPropertyAccessException("expressionTypingServices");
            }
            expressionTypingServices.getTypeInfo(selectorExpression, context);
            context.trace.report(Errors.ILLEGAL_SELECTOR.on((KtExpression)((PsiElement)selectorExpression), selectorExpression.getText()));
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        } else {
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        }
        return kotlinTypeInfo;
    }

    private final KotlinTypeInfo getSafeOrUnsafeSelectorTypeInfo(Receiver receiver, CallExpressionElement element, ExpressionTypingContext context) {
        KotlinType selectorType;
        boolean receiverCanBeNull;
        DataFlowValue dataFlowValue;
        DataFlowInfo initialDataFlowInfoForArguments = context.dataFlowInfo;
        Receiver receiver2 = receiver;
        if (!(receiver2 instanceof ReceiverValue)) {
            receiver2 = null;
        }
        ReceiverValue receiverValue = (ReceiverValue)receiver2;
        if (receiverValue != null) {
            ReceiverValue receiverValue2 = receiverValue;
            ReceiverValue it = receiverValue2;
            dataFlowValue = DataFlowValueFactory.createDataFlowValue(it, context);
        } else {
            dataFlowValue = null;
        }
        DataFlowValue receiverDataFlowValue = dataFlowValue;
        boolean bl = receiverCanBeNull = receiverDataFlowValue != null && initialDataFlowInfoForArguments.getPredictableNullability(receiverDataFlowValue).canBeNull();
        if (receiverDataFlowValue != null && element.getSafe()) {
            if (receiverCanBeNull) {
                initialDataFlowInfoForArguments = initialDataFlowInfoForArguments.disequate(receiverDataFlowValue, DataFlowValue.Companion.nullValue(this.builtIns));
            } else if (receiver instanceof ReceiverValue) {
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
                KotlinType kotlinType = ((ReceiverValue)receiver).getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiver.type");
                Companion.reportUnnecessarySafeCall(bindingTrace, kotlinType, element.getNode(), receiver);
            }
        }
        KtExpression selector = element.getSelector();
        ASTNode aSTNode = element.getNode();
        DataFlowInfo dataFlowInfo = initialDataFlowInfoForArguments;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "initialDataFlowInfoForArguments");
        KotlinTypeInfo selectorTypeInfo = this.getUnsafeSelectorTypeInfo(receiver, aSTNode, selector, context, dataFlowInfo);
        if (receiver instanceof Qualifier) {
            this.resolveDeferredReceiverInQualifiedExpression((Qualifier)receiver, selector, context);
        }
        if ((selectorType = selectorTypeInfo.getType()) != null) {
            if (element.getSafe() && receiverCanBeNull) {
                selectorTypeInfo = selectorTypeInfo.replaceType(TypeUtils.makeNullable(selectorType));
            }
            if (selector != null) {
                context.trace.recordType(selector, selectorTypeInfo.getType());
            }
        }
        return selectorTypeInfo;
    }

    private final KotlinTypeInfo checkSelectorTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo selectorTypeInfo, ExpressionTypingContext context) {
        KotlinTypeInfo kotlinTypeInfo;
        CallExpressionResolver.Companion.checkNestedClassAccess(qualified, context);
        KtExpression ktExpression = qualified;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        CompileTimeConstant<?> value = this.constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, context.expectedType);
        if (value != null && value.isPure()) {
            KotlinTypeInfo kotlinTypeInfo2 = this.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value, qualified, context);
            kotlinTypeInfo = kotlinTypeInfo2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo2, "dataFlowAnalyzer.createC\u2026alue, qualified, context)");
        } else {
            if (Intrinsics.areEqual((Object)context.contextDependency, (Object)ContextDependency.INDEPENDENT)) {
                this.dataFlowAnalyzer.checkType(selectorTypeInfo.getType(), (KtExpression)qualified, (ResolutionContext)context);
            }
            kotlinTypeInfo = selectorTypeInfo;
        }
        return kotlinTypeInfo;
    }

    private final void recordResultTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo resultTypeInfo, ExpressionTypingContext context) {
        BindingTrace trace = context.trace;
        if (Intrinsics.areEqual((Boolean)trace.get(BindingContext.PROCESSED, qualified), true) ^ true) {
            trace.record(BindingContext.PROCESSED, qualified);
            trace.record(BindingContext.EXPRESSION_TYPE_INFO, qualified, resultTypeInfo);
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
            BindingContextUtilsKt.recordScope(trace, lexicalScope, qualified);
            BindingContextUtilsKt.recordDataFlowInfo(context.replaceDataFlowInfo(resultTypeInfo.getDataFlowInfo()), qualified);
        }
    }

    @NotNull
    public final KotlinTypeInfo getQualifiedExpressionTypeInfo(@NotNull KtQualifiedExpression expression, @NotNull ExpressionTypingContext context) {
        KotlinTypeInfo receiverTypeInfo;
        KotlinTypeInfo kotlinTypeInfo;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ExpressionTypingContext currentContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        BindingTrace trace = currentContext.trace;
        List<CallExpressionElement> elementChain2 = this.elementChain(expression, context);
        KtExpression firstReceiver = CollectionsKt.first(elementChain2).getReceiver();
        Qualifier qualifier = (Qualifier)trace.get(BindingContext.QUALIFIER, firstReceiver);
        if (Intrinsics.areEqual(qualifier, null)) {
            ExpressionTypingServices expressionTypingServices = this.expressionTypingServices;
            if (expressionTypingServices == null) {
                Intrinsics.throwUninitializedPropertyAccessException("expressionTypingServices");
            }
            kotlinTypeInfo = expressionTypingServices.getTypeInfo(firstReceiver, currentContext);
        } else {
            KotlinType kotlinType = null;
            DataFlowInfo dataFlowInfo = currentContext.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "currentContext.dataFlowInfo");
            kotlinTypeInfo = new KotlinTypeInfo(kotlinType, dataFlowInfo, false, null, 12, null);
        }
        KotlinTypeInfo resultTypeInfo = receiverTypeInfo = kotlinTypeInfo;
        boolean allUnsafe = true;
        DataFlowInfo branchPointDataFlowInfo = receiverTypeInfo.getDataFlowInfo();
        for (CallExpressionElement element : elementChain2) {
            ExpressionTypingContext contextForSelector;
            ExpressionTypingContext expressionTypingContext;
            boolean lastStage;
            Receiver receiver;
            KotlinType kotlinType = receiverTypeInfo.getType();
            if (kotlinType == null) {
                KotlinType kotlinType2 = ErrorUtils.createErrorType("Type for " + element.getReceiver().getText());
                kotlinType = kotlinType2;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "ErrorUtils.createErrorTy\u2026 + element.receiver.text)");
            }
            KotlinType receiverType = kotlinType;
            Qualifier qualifier2 = (Qualifier)trace.get(BindingContext.QUALIFIER, element.getReceiver());
            if (qualifier2 != null) {
                receiver = qualifier2;
            } else {
                KtExpression ktExpression = element.getReceiver();
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
                receiver = ExpressionReceiver.Companion.create(ktExpression, receiverType, bindingContext);
            }
            Receiver receiver2 = receiver;
            KtQualifiedExpression qualifiedExpression = element.getQualified();
            boolean bl = lastStage = qualifiedExpression == expression;
            if (lastStage) {
                expressionTypingContext = context;
            } else {
                ExpressionTypingContext expressionTypingContext2 = currentContext;
                expressionTypingContext = expressionTypingContext2;
                Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext2, "currentContext");
            }
            ExpressionTypingContext expressionTypingContext3 = contextForSelector = (ExpressionTypingContext)expressionTypingContext.replaceDataFlowInfo(receiver2 instanceof ReceiverValue && TypeUtils.isNullableType(((ReceiverValue)receiver2).getType()) && !element.getSafe() ? branchPointDataFlowInfo : receiverTypeInfo.getDataFlowInfo());
            Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext3, "contextForSelector");
            KotlinTypeInfo selectorTypeInfo = this.getSafeOrUnsafeSelectorTypeInfo(receiver2, element, expressionTypingContext3);
            boolean bl2 = allUnsafe = allUnsafe && !element.getSafe();
            if (allUnsafe) {
                branchPointDataFlowInfo = selectorTypeInfo.getDataFlowInfo();
            }
            ExpressionTypingContext expressionTypingContext4 = contextForSelector;
            Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext4, "contextForSelector");
            resultTypeInfo = this.checkSelectorTypeInfo(qualifiedExpression, selectorTypeInfo, expressionTypingContext4).replaceDataFlowInfo(branchPointDataFlowInfo);
            if (!lastStage) {
                KotlinTypeInfo kotlinTypeInfo2 = resultTypeInfo;
                Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo2, "resultTypeInfo");
                ExpressionTypingContext expressionTypingContext5 = contextForSelector;
                Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext5, "contextForSelector");
                this.recordResultTypeInfo(qualifiedExpression, kotlinTypeInfo2, expressionTypingContext5);
            }
            receiverTypeInfo = selectorTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo3 = resultTypeInfo;
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo3, "resultTypeInfo");
        return kotlinTypeInfo3;
    }

    private final void resolveDeferredReceiverInQualifiedExpression(Qualifier qualifier, KtExpression selectorExpression, ExpressionTypingContext context) {
        DeclarationDescriptor declarationDescriptor;
        KtExpression calleeExpression = KtPsiUtil.deparenthesize(CallUtilKt.getCalleeExpressionIfAny(selectorExpression));
        KtExpression ktExpression = calleeExpression;
        if (!(ktExpression instanceof KtReferenceExpression)) {
            ktExpression = null;
        }
        KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)ktExpression;
        if (ktReferenceExpression != null) {
            KtReferenceExpression ktReferenceExpression2 = ktReferenceExpression;
            KtReferenceExpression it = ktReferenceExpression2;
            declarationDescriptor = (DeclarationDescriptor)context.trace.get(BindingContext.REFERENCE_TARGET, it);
        } else {
            declarationDescriptor = null;
        }
        DeclarationDescriptor selectorDescriptor = declarationDescriptor;
        QualifiedExpressionResolveUtilKt.resolveQualifierAsReceiverInExpression(qualifier, selectorDescriptor, context, this.symbolUsageValidator);
    }

    public CallExpressionResolver(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull KotlinBuiltIns builtIns, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull SymbolUsageValidator symbolUsageValidator) {
        Intrinsics.checkParameterIsNotNull(callResolver, "callResolver");
        Intrinsics.checkParameterIsNotNull(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(dataFlowAnalyzer, "dataFlowAnalyzer");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        Intrinsics.checkParameterIsNotNull(qualifiedExpressionResolver, "qualifiedExpressionResolver");
        Intrinsics.checkParameterIsNotNull(symbolUsageValidator, "symbolUsageValidator");
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.argumentTypeResolver = argumentTypeResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.builtIns = builtIns;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.symbolUsageValidator = symbolUsageValidator;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver$Companion;", "", "()V", "canInstantiateAnnotationClass", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkNestedClassAccess", "", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "isUnderAnnotationClassDeclaration", "parent", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "reportUnnecessarySafeCall", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "callOperationNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "kotlin-compiler"})
    public static final class Companion {
        private final boolean canInstantiateAnnotationClass(KtCallExpression expression, BindingTrace trace) {
            Object parent2 = PsiTreeUtil.getParentOfType((PsiElement)expression, KtValueArgument.class, KtParameter.class);
            if (parent2 instanceof KtValueArgument) {
                boolean strict$iv;
                Object $receiver$iv;
                Object t = parent2;
                boolean bl = true;
                if (PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtAnnotationEntry.class, strict$iv) != null) {
                    return true;
                }
                $receiver$iv = parent2;
                strict$iv = true;
                parent2 = PsiTreeUtil.getParentOfType($receiver$iv, KtParameter.class, strict$iv);
                if (parent2 != null) {
                    return this.isUnderAnnotationClassDeclaration(trace, (PsiElement)parent2);
                }
            } else if (parent2 instanceof KtParameter) {
                return this.isUnderAnnotationClassDeclaration(trace, (PsiElement)parent2);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isUnderAnnotationClassDeclaration(BindingTrace trace, PsiElement parent2) {
            boolean bl;
            void strict$iv;
            void $receiver$iv;
            PsiElement psiElement = parent2;
            boolean bl2 = true;
            KtClass ktClass = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClass.class, (boolean)strict$iv);
            if (ktClass != null) {
                psiElement = ktClass;
                KtClass it = (KtClass)psiElement;
                bl = DescriptorUtils.isAnnotationClass(trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, it));
            } else {
                bl = false;
            }
            return bl;
        }

        public final void reportUnnecessarySafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, @NotNull ASTNode callOperationNode, @Nullable Receiver explicitReceiver) {
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            Intrinsics.checkParameterIsNotNull(type2, "type");
            Intrinsics.checkParameterIsNotNull(callOperationNode, "callOperationNode");
            trace.report(explicitReceiver instanceof ExpressionReceiver && ((ExpressionReceiver)explicitReceiver).getExpression() instanceof KtSuperExpression ? (ParametrizedDiagnostic)Errors.UNEXPECTED_SAFE_CALL.on(callOperationNode.getPsi()) : Errors.UNNECESSARY_SAFE_CALL.on(callOperationNode.getPsi(), type2));
        }

        private final void checkNestedClassAccess(KtQualifiedExpression expression, ExpressionTypingContext context) {
            KtExpression ktExpression = expression.getSelectorExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression selectorExpression = ktExpression;
            Qualifier expressionQualifier = (Qualifier)context.trace.get(BindingContext.QUALIFIER, expression);
            Qualifier receiverQualifier = (Qualifier)context.trace.get(BindingContext.QUALIFIER, expression.getReceiverExpression());
            if (receiverQualifier == null && expressionQualifier != null) {
                boolean bl = expressionQualifier instanceof ClassQualifier;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Only class can (package cannot) be accessed by instance reference: " + expressionQualifier;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Qualifier qualifier = expressionQualifier;
                if (qualifier == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier");
                }
                context.trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on((KtExpression)((PsiElement)selectorExpression), ((ClassQualifier)qualifier).getDescriptor()));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

