/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.com.google.dart.compiler.util.AstUtil;

public final class JsReturn
extends SourceInfoAwareJsNode
implements JsStatement {
    private JsExpression expression;

    public JsReturn() {
    }

    public JsReturn(JsExpression expression) {
        this.expression = expression;
    }

    public JsExpression getExpression() {
        return this.expression;
    }

    public void setExpression(JsExpression expression) {
        this.expression = expression;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitReturn(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        if (this.expression != null) {
            visitor2.accept(this.expression);
        }
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx) && this.expression != null) {
            this.expression = v.accept(this.expression);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsReturn deepCopy() {
        JsReturn jsReturn = new JsReturn(AstUtil.deepCopy(this.expression)).withMetadataFrom(this);
        if (jsReturn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsReturn", "deepCopy"));
        }
        return jsReturn;
    }
}

