/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.asJava.FilteredJvmDiagnostics;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.output.outputUtils.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.ModuleNameKt;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.GenerationStateEventCallback;
import org.jetbrains.kotlin.codegen.state.GenerationStateKt;
import org.jetbrains.kotlin.codegen.state.Progress;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.JarUtil;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.JavaRootPath;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.modules.TargetIdKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001dJ8\u0010\u001e\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\u0006\u0010#\u001a\u00020\u0012JL\u0010$\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001d2\u0006\u0010'\u001a\u00020 2\b\u0010(\u001a\u0004\u0018\u00010 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\u0006\u0010)\u001a\u00020\u0012J$\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010+2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u0005J$\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001d2\u0006\u0010'\u001a\u00020 J$\u0010.\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010 2\b\u0010(\u001a\u0004\u0018\u00010 H\u0002J \u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u001dH\u0002JL\u00102\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u00103\u001a\u00020\t2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\b\u00105\u001a\u0004\u0018\u00010&2\b\u00106\u001a\u0004\u0018\u00010 2\b\u00107\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u00108\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\u0006\u0010'\u001a\u00020 2\u0006\u00105\u001a\u00020&H\u0002J\u0018\u00109\u001a\u0006\u0012\u0002\b\u00030:2\n\u0010;\u001a\u0006\u0012\u0002\b\u00030+H\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\u001e\u0010@\u001a\u00020=2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010A\u001a\b\u0012\u0004\u0012\u00020 0\u001dH\u0002J>\u0010B\u001a\u00020=2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010C\u001a\u00020D2\b\u0010!\u001a\u0004\u0018\u00010 2\b\u0010(\u001a\u0004\u0018\u00010 2\u0006\u0010)\u001a\u00020\u00122\b\u0010E\u001a\u0004\u0018\u000100H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler;", "", "()V", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getMessageCollector", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "analyze", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "environment", "targetDescription", "", "analyzeAndGenerate", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "onIndependentPartCompilationEnd", "Lorg/jetbrains/kotlin/codegen/state/GenerationStateEventCallback;", "checkKotlinPackageUsage", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "compileAndExecuteScript", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "scriptArgs", "", "compileBunchOfSources", "jar", "Ljava/io/File;", "outputDir", "friendPaths", "includeRuntime", "compileModules", "chunk", "Lorg/jetbrains/kotlin/modules/Module;", "directory", "jarPath", "jarRuntime", "compileScript", "Ljava/lang/Class;", "createCompilerConfiguration", "base", "createOutputFilesFlushingCallbackIfPossible", "findMainClass", "Lorg/jetbrains/kotlin/name/FqName;", "generationState", "generate", "result", "sourceFiles", "module", "outputDirectory", "moduleName", "getAbsolutePaths", "getScriptConstructor", "Ljava/lang/reflect/Constructor;", "scriptClass", "reportExceptionFromScript", "", "exception", "", "reportRuntimeConflicts", "jvmClasspathRoots", "writeOutput", "outputFiles", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "mainClass", "kotlin-compiler"})
public final class KotlinToJVMBytecodeCompiler {
    public static final KotlinToJVMBytecodeCompiler INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final List<String> getAbsolutePaths(File directory, Module module) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = module.getSourceFiles();
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void sourceFile;
            String string = (String)item$iv$iv;
            void var9_9 = destination$iv$iv;
            File source = new File((String)sourceFile);
            if (!source.isAbsolute()) {
                source = new File(directory, (String)sourceFile);
            }
            String string2 = source.getAbsolutePath();
            var9_9.add(string2);
        }
        return (List)destination$iv$iv;
    }

    private final void writeOutput(CompilerConfiguration configuration, OutputFileCollection outputFiles, File outputDir2, File jarPath, boolean jarRuntime, FqName mainClass) {
        if (jarPath != null) {
            CompileEnvironmentUtil.writeToJar(jarPath, jarRuntime, mainClass, outputFiles);
        } else {
            MessageCollector messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
            File file = outputDir2;
            if (file == null) {
                file = new File(".");
            }
            MessageCollector messageCollector2 = messageCollector;
            Intrinsics.checkExpressionValueIsNotNull(messageCollector2, "messageCollector");
            OutputUtilsKt.writeAll(outputFiles, file, messageCollector2);
        }
    }

    private final GenerationStateEventCallback createOutputFilesFlushingCallbackIfPossible(CompilerConfiguration configuration, File outputDir2, File jarPath) {
        if (jarPath != null) {
            return GenerationStateEventCallback.Companion.getDO_NOTHING();
        }
        return GenerationStateKt.GenerationStateEventCallback((Function1<? super GenerationState, Unit>)new Function1<GenerationState, Unit>(configuration, outputDir2){
            final /* synthetic */ CompilerConfiguration $configuration;
            final /* synthetic */ File $outputDir;

            public final void invoke(@NotNull GenerationState state2) {
                Intrinsics.checkParameterIsNotNull(state2, "state");
                List<OutputFile> list2 = state2.getFactory().getCurrentOutput();
                Intrinsics.checkExpressionValueIsNotNull(list2, "state.factory.currentOutput");
                SimpleOutputFileCollection currentOutput = new SimpleOutputFileCollection(list2);
                KotlinToJVMBytecodeCompiler.access$writeOutput(KotlinToJVMBytecodeCompiler.INSTANCE, this.$configuration, currentOutput, this.$outputDir, null, false, null);
                state2.getFactory().releaseGeneratedOutput();
            }
            {
                this.$configuration = compilerConfiguration;
                this.$outputDir = file;
                super(1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compileModules(@NotNull KotlinCoreEnvironment environment2, @NotNull CompilerConfiguration configuration, @NotNull List<? extends Module> chunk, @NotNull File directory, @Nullable File jarPath, @NotNull List<String> friendPaths, boolean jarRuntime) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(chunk, "chunk");
        Intrinsics.checkParameterIsNotNull(directory, "directory");
        Intrinsics.checkParameterIsNotNull(friendPaths, "friendPaths");
        HashMap<Module, ClassFileFactory> outputFiles = MapsKt.hashMapOf(new Pair[0]);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        ModuleVisibilityManager moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance(environment2.getProject());
        for (Module module : chunk) {
            moduleVisibilityManager.addModule(module);
        }
        for (String string : friendPaths) {
            moduleVisibilityManager.addFriendPath(string);
        }
        String string = "in targets [" + CollectionsKt.joinToString$default(chunk, null, null, null, 0, null, compileModules.targetDescription.1.INSTANCE, 31, null) + "]";
        AnalysisResult result2 = this.analyze(environment2, string);
        if (result2 == null || !result2.getShouldGenerateCode()) {
            return false;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        result2.throwIfError();
        ArrayList<GenerationState> generationStates = new ArrayList<GenerationState>();
        for (Module module : chunk) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            List<KtFile> ktFiles2 = CompileEnvironmentUtil.getKtFiles(environment2.getProject(), (Collection<String>)this.getAbsolutePaths(directory, module), configuration, compileModules.ktFiles.1.INSTANCE);
            Collection collection = ktFiles2;
            Intrinsics.checkExpressionValueIsNotNull(collection, "ktFiles");
            if (!this.checkKotlinPackageUsage(environment2, collection)) {
                return false;
            }
            File moduleOutputDirectory = new File(module.getOutputDirectory());
            GenerationStateEventCallback onIndependentPartCompilationEnd = this.createOutputFilesFlushingCallbackIfPossible(configuration, new File(module.getOutputDirectory()), jarPath);
            List<KtFile> list2 = ktFiles2;
            Intrinsics.checkExpressionValueIsNotNull(list2, "ktFiles");
            GenerationState generationState = this.generate(environment2, result2, list2, module, moduleOutputDirectory, module.getModuleName(), onIndependentPartCompilationEnd);
            outputFiles.put(module, generationState.getFactory());
            generationStates.add(generationState);
        }
        try {
            for (Module module : chunk) {
                ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
                Object v = outputFiles.get(module);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                OutputFileCollection outputFileCollection = (OutputFileCollection)v;
                Intrinsics.checkExpressionValueIsNotNull(outputFileCollection, "outputFiles[module]!!");
                this.writeOutput(configuration, outputFileCollection, new File(module.getOutputDirectory()), jarPath, jarRuntime, null);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            for (GenerationState generationState : generationStates) {
                generationState.destroy();
            }
        }
    }

    @NotNull
    public final CompilerConfiguration createCompilerConfiguration(@NotNull CompilerConfiguration base, @NotNull List<? extends Module> chunk, @NotNull File directory) {
        Intrinsics.checkParameterIsNotNull(base, "base");
        Intrinsics.checkParameterIsNotNull(chunk, "chunk");
        Intrinsics.checkParameterIsNotNull(directory, "directory");
        CompilerConfiguration configuration = base.copy();
        for (Module module : chunk) {
            ContentRootsKt.addKotlinSourceRoots(configuration, this.getAbsolutePaths(directory, module));
        }
        for (Module module : chunk) {
            for (JavaRootPath javaRootPath : module.getJavaSourceRoots()) {
                JvmContentRootsKt.addJavaSourceRoot(configuration, new File(javaRootPath.getPath()), javaRootPath.getPackagePrefix());
            }
        }
        for (Module module : chunk) {
            for (String classpathRoot : module.getClasspathRoots()) {
                JvmContentRootsKt.addJvmClasspathRoot(configuration, new File(classpathRoot));
            }
        }
        configuration.addAll(JVMConfigurationKeys.MODULES, (Collection)chunk);
        CompilerConfiguration compilerConfiguration = configuration;
        Intrinsics.checkExpressionValueIsNotNull(compilerConfiguration, "configuration");
        return compilerConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    private final FqName findMainClass(GenerationState generationState, List<? extends KtFile> files) {
        Object v0;
        block2: {
            void $receiver$iv;
            MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(generationState.getBindingContext());
            Sequence sequence2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)files), (Function1)new Function1<KtFile, FqName>(mainFunctionDetector){
                final /* synthetic */ MainFunctionDetector $mainFunctionDetector;

                @Nullable
                public final FqName invoke(@NotNull KtFile file) {
                    Intrinsics.checkParameterIsNotNull(file, "file");
                    return this.$mainFunctionDetector.hasMain(file.getDeclarations()) ? JvmFileClassUtil.getFileClassInfoNoResolve(file).getFacadeClassFqName() : (FqName)null;
                }
                {
                    this.$mainFunctionDetector = mainFunctionDetector;
                    super(1);
                }
            });
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                FqName it = (FqName)element$iv;
                if (!(it != null)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compileBunchOfSources(@NotNull KotlinCoreEnvironment environment2, @Nullable File jar, @Nullable File outputDir2, @NotNull List<String> friendPaths, boolean includeRuntime) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(friendPaths, "friendPaths");
        ModuleVisibilityManager moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance(environment2.getProject());
        for (String path : friendPaths) {
            moduleVisibilityManager.addFriendPath(path);
        }
        if (!this.checkKotlinPackageUsage(environment2, (Collection<? extends KtFile>)environment2.getSourceFiles())) {
            return false;
        }
        GenerationStateEventCallback onIndependentPartCompilationEnd = this.createOutputFilesFlushingCallbackIfPossible(environment2.getConfiguration(), outputDir2, jar);
        GenerationState generationState = this.analyzeAndGenerate(environment2, onIndependentPartCompilationEnd);
        if (generationState == null) {
            return false;
        }
        GenerationState generationState2 = generationState;
        FqName mainClass = this.findMainClass(generationState2, environment2.getSourceFiles());
        try {
            this.writeOutput(environment2.getConfiguration(), generationState2.getFactory(), outputDir2, jar, includeRuntime, mainClass);
            boolean bl = true;
            return bl;
        }
        finally {
            generationState2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final ExitCode compileAndExecuteScript(@NotNull CompilerConfiguration configuration, @NotNull KotlinPaths paths, @NotNull KotlinCoreEnvironment environment2, @NotNull List<String> scriptArgs) {
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(paths, "paths");
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(scriptArgs, "scriptArgs");
        Class<?> clazz = this.compileScript(configuration, paths, environment2);
        if (clazz == null) {
            return ExitCode.COMPILATION_ERROR;
        }
        Class<?> scriptClass = clazz;
        Constructor<?> scriptConstructor = this.getScriptConstructor(scriptClass);
        try {
            try {
                void elements$iv;
                Object[] objectArray;
                Object[] $receiver$iv;
                Object[] objectArray2;
                Collection collection = scriptArgs;
                int n = 0;
                Object[] objectArray3 = objectArray2 = new Object[1];
                Constructor<?> constructor = scriptConstructor;
                void v1 = $receiver$iv;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = (Collection)v1;
                String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                objectArray2[n] = objectArray = (Object[])stringArray;
                $receiver$iv = objectArray3;
                objectArray3 = (Object[])elements$iv;
                constructor.newInstance(Arrays.copyOf(objectArray3, objectArray3.length));
            }
            finally {
                System.out.flush();
                System.err.flush();
            }
        }
        catch (Throwable e) {
            this.reportExceptionFromScript(e);
            return ExitCode.SCRIPT_EXECUTION_ERROR;
        }
        return ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportExceptionFromScript(Throwable exception) {
        PrintStream stream2 = System.err;
        Throwable cause = exception.getCause();
        if (!(exception instanceof InvocationTargetException) || cause == null) {
            Throwable throwable = exception;
            PrintStream printStream = stream2;
            Intrinsics.checkExpressionValueIsNotNull(printStream, "stream");
            PrintStream printStream2 = printStream;
            Throwable throwable2 = throwable;
            if (throwable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
            }
            throwable2.printStackTrace(printStream2);
            return;
        }
        stream2.println(cause);
        StackTraceElement[] fullTrace = ExceptionsKt.getStackTrace(cause);
        int relevantEntries = ((Object[])fullTrace).length - ((Object[])ExceptionsKt.getStackTrace(exception)).length;
        int n = 0;
        int n2 = relevantEntries - 1;
        if (n <= n2) {
            while (true) {
                void i;
                stream2.println("\tat " + fullTrace[i]);
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final Constructor<?> getScriptConstructor(Class<?> scriptClass) {
        Constructor<?> constructor = scriptClass.getConstructor(String[].class);
        Intrinsics.checkExpressionValueIsNotNull(constructor, "scriptClass.getConstruct\u2026rray<String>::class.java)");
        return constructor;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Class<?> compileScript(@NotNull CompilerConfiguration configuration, @NotNull KotlinPaths paths, @NotNull KotlinCoreEnvironment environment2) {
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(paths, "paths");
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        GenerationState generationState = this.analyzeAndGenerate(environment2, GenerationStateEventCallback.Companion.getDO_NOTHING());
        if (generationState == null) {
            return null;
        }
        GenerationState state2 = generationState;
        try {
            GeneratedClassLoader generatedClassLoader;
            URLClassLoader uRLClassLoader;
            Object object;
            Object object2;
            Collection $receiver$iv;
            ArrayList<URL> classPaths = CollectionsKt.arrayListOf(paths.getRuntimePath().toURI().toURL());
            Iterable iterable = JvmContentRootsKt.getJvmClasspathRoots(configuration);
            for (Object item$iv : $receiver$iv) {
                void it;
                File file = (File)item$iv;
                object2 = classPaths;
                object = it.toURI().toURL();
                object2.add(object);
            }
            $receiver$iv = classPaths;
            URLClassLoader uRLClassLoader2 = uRLClassLoader;
            URLClassLoader uRLClassLoader3 = uRLClassLoader;
            ClassFileFactory classFileFactory = state2.getFactory();
            object = generatedClassLoader;
            object2 = generatedClassLoader;
            Collection collection = $receiver$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            URL[] uRLArray = thisCollection$iv.toArray(new URL[thisCollection$iv.size()]);
            if (uRLArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray = uRLArray;
            uRLClassLoader2((URL[])objectArray, (ClassLoader)null);
            ((GeneratedClassLoader)object)(classFileFactory, (ClassLoader)uRLClassLoader3, new URL[0]);
            Object classLoader = object2;
            KtScript ktScript = environment2.getSourceFiles().get(0).getScript();
            if (ktScript == null) {
                String string = "Script must be parsed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtScript script = ktScript;
            return ((ClassLoader)classLoader).loadClass(script.getFqName().asString());
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Failed to evaluate script: " + e, e);
        }
    }

    @Nullable
    public final GenerationState analyzeAndGenerate(@NotNull KotlinCoreEnvironment environment2, @NotNull GenerationStateEventCallback onIndependentPartCompilationEnd) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(onIndependentPartCompilationEnd, "onIndependentPartCompilationEnd");
        AnalysisResult analysisResult = this.analyze(environment2, null);
        if (analysisResult == null) {
            return null;
        }
        AnalysisResult result2 = analysisResult;
        if (!result2.getShouldGenerateCode()) {
            return null;
        }
        result2.throwIfError();
        return this.generate(environment2, result2, environment2.getSourceFiles(), null, null, null, onIndependentPartCompilationEnd);
    }

    private final AnalysisResult analyze(KotlinCoreEnvironment environment2, String targetDescription2) {
        MessageCollector collector2 = this.getMessageCollector(environment2);
        long analysisStart = PerformanceCounter.Companion.currentTime();
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(collector2);
        analyzerWithCompilerReport.analyzeAndReport((Collection<? extends KtFile>)environment2.getSourceFiles(), new AnalyzerWithCompilerReport.Analyzer(environment2, collector2){
            final /* synthetic */ KotlinCoreEnvironment $environment;
            final /* synthetic */ MessageCollector $collector;

            @NotNull
            public AnalysisResult analyze() {
                CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace sharedTrace = new CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace();
                MutableModuleContext moduleContext = TopDownAnalyzerFacadeForJVM.createContextWithSealedModule(this.$environment.getProject(), ModuleNameKt.getModuleName(this.$environment));
                AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegrationWithCustomContext(moduleContext, (Collection<KtFile>)this.$environment.getSourceFiles(), sharedTrace, this.$environment.getConfiguration().get(JVMConfigurationKeys.MODULES), this.$environment.getConfiguration().get(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS), new JvmPackagePartProvider(this.$environment));
                Intrinsics.checkExpressionValueIsNotNull(analysisResult, "TopDownAnalyzerFacadeFor\u2026artProvider(environment))");
                return analysisResult;
            }

            public void reportEnvironmentErrors() {
                KotlinToJVMBytecodeCompiler.access$reportRuntimeConflicts(KotlinToJVMBytecodeCompiler.INSTANCE, this.$collector, JvmContentRootsKt.getJvmClasspathRoots(this.$environment.getConfiguration()));
            }
            {
                this.$environment = $captured_local_variable$0;
                this.$collector = $captured_local_variable$1;
            }
        });
        long analysisNanos = PerformanceCounter.Companion.currentTime() - analysisStart;
        int sourceLinesOfCode2 = environment2.getSourceLinesOfCode();
        int numberOfFiles = environment2.getSourceFiles().size();
        long time = TimeUnit.NANOSECONDS.toMillis(analysisNanos);
        float speed = (float)sourceLinesOfCode2 * (float)1000 / (float)time;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder().append("ANALYZE: ").append(numberOfFiles).append(" files (").append(sourceLinesOfCode2).append(" lines) ");
        String string = targetDescription2;
        if (string == null) {
            string = "";
        }
        String string2 = "%.3f";
        Object[] objectArray = new Object[]{Float.valueOf(speed)};
        StringBuilder stringBuilder3 = new StringBuilder().append("in ").append(time).append(" ms - ");
        StringBuilder stringBuilder4 = stringBuilder.append(stringBuilder2.append(string).toString());
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(this, *args)");
        String string4 = string3;
        String message = stringBuilder4.append(stringBuilder3.append(string4).append(" loc/s").toString()).toString();
        K2JVMCompiler.Companion.reportPerf(environment2.getConfiguration(), message);
        return analyzerWithCompilerReport.hasErrors() ? (AnalysisResult)null : analyzerWithCompilerReport.getAnalysisResult();
    }

    private final GenerationState generate(KotlinCoreEnvironment environment2, AnalysisResult result2, List<? extends KtFile> sourceFiles, Module module, File outputDirectory, String moduleName, GenerationStateEventCallback onIndependentPartCompilationEnd) {
        File file;
        Object object;
        Object object2;
        GenerationState generationState;
        CompilerConfiguration configuration = environment2.getConfiguration();
        IncrementalCompilationComponents incrementalCompilationComponents = configuration.get(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS);
        HashSet<FqName> packagesWithObsoleteParts = SetsKt.hashSetOf(new FqName[0]);
        ArrayList<FqName> obsoleteMultifileClasses = CollectionsKt.arrayListOf(new FqName[0]);
        TargetId targetId = null;
        if (module != null && incrementalCompilationComponents != null) {
            targetId = TargetIdKt.TargetId(module);
            IncrementalCache incrementalCache = incrementalCompilationComponents.getIncrementalCache(targetId);
            for (String internalName : incrementalCache.getObsoletePackageParts()) {
                packagesWithObsoleteParts.add(JvmClassName.byInternalName(internalName).getPackageFqName());
            }
            for (String obsoleteFacadeInternalName : incrementalCache.getObsoleteMultifileClasses()) {
                obsoleteMultifileClasses.add(JvmClassName.byInternalName(obsoleteFacadeInternalName).getFqNameForClassNameWithoutDollars());
            }
        }
        GenerationState generationState2 = generationState;
        GenerationState generationState3 = generationState;
        Project project = environment2.getProject();
        ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.BINARIES;
        ClassBuilderFactory classBuilderFactory2 = classBuilderFactory;
        Intrinsics.checkExpressionValueIsNotNull(classBuilderFactory, "ClassBuilderFactories.BINARIES");
        ModuleDescriptor moduleDescriptor = result2.getModuleDescriptor();
        BindingContext bindingContext = result2.getBindingContext();
        List<? extends KtFile> list2 = sourceFiles;
        boolean bl = configuration.getBoolean(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS);
        boolean bl2 = configuration.getBoolean(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS);
        GenerationState.GenerateClassFilter generateClassFilter2 = GenerationState.GenerateClassFilter.GENERATE_ALL;
        boolean bl3 = configuration.getBoolean(JVMConfigurationKeys.DISABLE_INLINE);
        boolean bl4 = configuration.getBoolean(JVMConfigurationKeys.DISABLE_OPTIMIZATION);
        boolean bl5 = false;
        boolean bl6 = configuration.getBoolean(JVMConfigurationKeys.INHERIT_MULTIFILE_PARTS);
        Collection collection = packagesWithObsoleteParts;
        Collection collection2 = obsoleteMultifileClasses;
        TargetId targetId2 = targetId;
        String string = moduleName;
        File file2 = outputDirectory;
        IncrementalCompilationComponents incrementalCompilationComponents2 = incrementalCompilationComponents;
        Progress progress = null;
        GenerationStateEventCallback generationStateEventCallback = onIndependentPartCompilationEnd;
        String string2 = configuration.get(JVMConfigurationKeys.DECLARATIONS_JSON_PATH);
        if (string2 != null) {
            String string3 = string2;
            GenerationStateEventCallback generationStateEventCallback2 = generationStateEventCallback;
            Progress progress2 = progress;
            IncrementalCompilationComponents incrementalCompilationComponents3 = incrementalCompilationComponents2;
            File file3 = file2;
            String string4 = string;
            TargetId targetId3 = targetId2;
            Collection collection3 = collection2;
            Collection collection4 = collection;
            boolean bl7 = bl6;
            boolean bl8 = bl5;
            boolean bl9 = bl4;
            boolean bl10 = bl3;
            GenerationState.GenerateClassFilter generateClassFilter3 = generateClassFilter2;
            boolean bl11 = bl2;
            boolean bl12 = bl;
            List<? extends KtFile> list3 = list2;
            BindingContext bindingContext2 = bindingContext;
            ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
            ClassBuilderFactory classBuilderFactory3 = classBuilderFactory2;
            Project project2 = project;
            object2 = generationState2;
            object = generationState3;
            String it = string3;
            File file4 = new File(it);
            generationState3 = object;
            generationState2 = object2;
            project = project2;
            classBuilderFactory2 = classBuilderFactory3;
            moduleDescriptor = moduleDescriptor2;
            bindingContext = bindingContext2;
            list2 = list3;
            bl = bl12;
            bl2 = bl11;
            generateClassFilter2 = generateClassFilter3;
            bl3 = bl10;
            bl4 = bl9;
            bl5 = bl8;
            bl6 = bl7;
            collection = collection4;
            collection2 = collection3;
            targetId2 = targetId3;
            string = string4;
            file2 = file3;
            incrementalCompilationComponents2 = incrementalCompilationComponents3;
            progress = progress2;
            generationStateEventCallback = generationStateEventCallback2;
            file = file4;
        } else {
            file = null;
        }
        generationState2(project, classBuilderFactory2, moduleDescriptor, bindingContext, list2, bl, bl2, generateClassFilter2, bl3, bl4, bl5, bl6, collection, collection2, targetId2, string, file2, incrementalCompilationComponents2, progress, generationStateEventCallback, file, 262144, null);
        GenerationState generationState4 = generationState3;
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        long generationStart = PerformanceCounter.Companion.currentTime();
        KotlinCodegenFacade.compileCorrectFiles(generationState4, CompilationErrorHandler.THROW_EXCEPTION);
        long generationNanos = PerformanceCounter.Companion.currentTime() - generationStart;
        String desc = module != null ? "target " + module.getModuleName() + "-" + module.getModuleType() + " " : "";
        int numberOfSourceFiles = sourceFiles.size();
        int numberOfLines = environment2.countLinesOfCode(sourceFiles);
        long time = TimeUnit.NANOSECONDS.toMillis(generationNanos);
        float speed = (float)numberOfLines * (float)1000 / (float)time;
        String string5 = "%.3f";
        Object[] objectArray = new Object[]{Float.valueOf(speed)};
        object = new StringBuilder().append("GENERATE: ").append(numberOfSourceFiles).append(" files (").append(numberOfLines).append(" lines) ").append(desc).append("in ").append(time).append(" ms - ");
        String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string6, "java.lang.String.format(this, *args)");
        object2 = string6;
        String message = ((StringBuilder)object).append((String)object2).append(" loc/s").toString();
        K2JVMCompiler.Companion.reportPerf(environment2.getConfiguration(), message);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        Diagnostics diagnostics2 = generationState4.getCollectedExtraJvmDiagnostics();
        Diagnostics diagnostics3 = result2.getBindingContext().getDiagnostics();
        Intrinsics.checkExpressionValueIsNotNull(diagnostics3, "result.bindingContext.diagnostics");
        AnalyzerWithCompilerReport.Companion.reportDiagnostics(new FilteredJvmDiagnostics(diagnostics2, diagnostics3), this.getMessageCollector(environment2));
        BindingContext bindingContext3 = generationState4.getExtraJvmDiagnosticsTrace().getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext3, "generationState.extraJvm\u2026sticsTrace.bindingContext");
        AnalyzerWithCompilerReport.Companion.reportBytecodeVersionErrors(bindingContext3, this.getMessageCollector(environment2));
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        return generationState4;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkKotlinPackageUsage(KotlinCoreEnvironment environment2, Collection<? extends KtFile> files) {
        void $receiver$iv;
        if (environment2.getConfiguration().getBoolean(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE)) {
            return true;
        }
        MessageCollector messageCollector = environment2.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
        FqName kotlinPackage = FqName.topLevel(Name.identifier("kotlin"));
        Iterable iterable = files;
        for (Object element$iv : $receiver$iv) {
            KtFile it = (KtFile)element$iv;
            FqName fqName2 = it.getPackageFqName();
            FqName fqName3 = kotlinPackage;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "kotlinPackage");
            if (!FqNamesUtilKt.isSubpackageOf(fqName2, fqName3)) continue;
            KtPackageDirective ktPackageDirective = it.getPackageDirective();
            if (ktPackageDirective == null) {
                Intrinsics.throwNpe();
            }
            messageCollector.report(CompilerMessageSeverity.ERROR, "Only the Kotlin standard library is allowed to use the 'kotlin' package", MessageUtil.psiElementToMessageLocation(ktPackageDirective));
            return false;
        }
        return true;
    }

    private final MessageCollector getMessageCollector(@NotNull KotlinCoreEnvironment $receiver) {
        MessageCollector messageCollector = $receiver.getConfiguration().getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull(messageCollector, "configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        return messageCollector;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportRuntimeConflicts(MessageCollector messageCollector, List<? extends File> jvmClasspathRoots) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Object object;
        File it;
        void var10_10;
        Collection destination$iv$iv2;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        reportRuntimeConflicts.1 removeIdeaVersionSuffix$ = reportRuntimeConflicts.1.INSTANCE;
        Iterable iterable = jvmClasspathRoots;
        void var5_5 = $receiver$iv2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            File file;
            File file2 = (File)item$iv$iv;
            var10_10 = destination$iv$iv2;
            try {
                file = it.getCanonicalFile();
            }
            catch (IOException e) {
                file = it;
            }
            object = file;
            var10_10.add(object);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (File)element$iv$iv;
            if (!(Intrinsics.areEqual(it.getName(), "kotlin-runtime.jar") && it.exists())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List runtimes = (List)destination$iv$iv2;
        $receiver$iv$iv2 = runtimes;
        destination$iv$iv2 = $receiver$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            File $i$a$2$filter = (File)item$iv$iv;
            var10_10 = destination$iv$iv;
            String string = JarUtil.getJarAttribute((File)it2, Attributes.Name.IMPLEMENTATION_VERSION);
            reportRuntimeConflicts.1 var15_16 = reportRuntimeConflicts.1.INSTANCE;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            String string3 = string2;
            object = var15_16.invoke(string3);
            var10_10.add(object);
        }
        List runtimeVersions = (List)destination$iv$iv;
        if (CollectionsKt.toSet(runtimeVersions).size() > 1) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Conflicting versions of Kotlin runtime on classpath: " + CollectionsKt.joinToString$default(runtimes, null, null, null, 0, null, reportRuntimeConflicts.2.INSTANCE, 31, null), CompilerMessageLocation.NO_LOCATION);
        }
    }

    private KotlinToJVMBytecodeCompiler() {
        INSTANCE = this;
    }

    static {
        new KotlinToJVMBytecodeCompiler();
    }

    public static final /* synthetic */ void access$writeOutput(KotlinToJVMBytecodeCompiler $this, @NotNull CompilerConfiguration configuration, @NotNull OutputFileCollection outputFiles, @Nullable File outputDir2, @Nullable File jarPath, boolean jarRuntime, @Nullable FqName mainClass) {
        $this.writeOutput(configuration, outputFiles, outputDir2, jarPath, jarRuntime, mainClass);
    }

    public static final /* synthetic */ void access$reportRuntimeConflicts(KotlinToJVMBytecodeCompiler $this, @NotNull MessageCollector messageCollector, @NotNull List jvmClasspathRoots) {
        $this.reportRuntimeConflicts(messageCollector, jvmClasspathRoots);
    }
}

