/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class ReifiedTypeParameterSubstitutionChecker
implements CallChecker {
    private static final FqName PURE_REIFIABLE_ANNOTATION_FQ_NAME = new FqName("kotlin.internal.PureReifiable");

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BasicCallResolutionContext context) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "check"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "check"));
        }
        Map<TypeParameterDescriptor, KotlinType> typeArguments2 = resolvedCall2.getTypeArguments();
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : typeArguments2.entrySet()) {
            TypeParameterDescriptor parameter = entry.getKey();
            KotlinType argument = entry.getValue();
            ClassifierDescriptor argumentDeclarationDescriptor = argument.getConstructor().getDeclarationDescriptor();
            if (!parameter.isReified() && !ReifiedTypeParameterSubstitutionChecker.isTypeParameterOfKotlinArray(parameter)) continue;
            if (argumentDeclarationDescriptor instanceof TypeParameterDescriptor && !((TypeParameterDescriptor)argumentDeclarationDescriptor).isReified()) {
                context.trace.report(Errors.TYPE_PARAMETER_AS_REIFIED.on(ReifiedTypeParameterSubstitutionChecker.getElementToReport(context, parameter.getIndex()), parameter));
                continue;
            }
            if (!TypeUtilsKt.cannotBeReified(argument)) continue;
            context.trace.report(Errors.REIFIED_TYPE_FORBIDDEN_SUBSTITUTION.on(ReifiedTypeParameterSubstitutionChecker.getElementToReport(context, parameter.getIndex()), argument));
        }
    }

    private static boolean isTypeParameterOfKotlinArray(@NotNull TypeParameterDescriptor parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "isTypeParameterOfKotlinArray"));
        }
        DeclarationDescriptor container2 = parameter.getContainingDeclaration();
        return container2 instanceof ClassDescriptor && KotlinBuiltIns.isNonPrimitiveArray((ClassDescriptor)container2);
    }

    @NotNull
    private static PsiElement getElementToReport(@NotNull BasicCallResolutionContext context, int parameterIndex) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "getElementToReport"));
        }
        if (context.call.getTypeArguments().size() > parameterIndex) {
            PsiElement psiElement = context.call.getTypeArguments().get(parameterIndex);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "getElementToReport"));
            }
            return psiElement;
        }
        KtExpression callee = context.call.getCalleeExpression();
        KtElement ktElement = callee != null ? callee : context.call.getCallElement();
        if (ktElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "getElementToReport"));
        }
        return ktElement;
    }
}

