/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.addRemoveModifier;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0000\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0002\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"0\u0010\u0004\u001a$\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0012\u0012\u0012\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"MODIFIERS_ORDER", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "MODIFIERS_TO_REPLACE", "", "addAnnotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "owner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "annotationEntry", "addModifier", "", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "modifier", "createModifierList", "text", "", "removeModifier", "kotlin-compiler"})
public final class AddRemoveModifierKt {
    private static final Map<KtModifierKeywordToken, List<KtModifierKeywordToken>> MODIFIERS_TO_REPLACE = MapsKt.mapOf(TuplesKt.to(KtTokens.OVERRIDE_KEYWORD, CollectionsKt.listOf(KtTokens.OPEN_KEYWORD)), TuplesKt.to(KtTokens.ABSTRACT_KEYWORD, CollectionsKt.listOf(new KtModifierKeywordToken[]{KtTokens.OPEN_KEYWORD, KtTokens.FINAL_KEYWORD})), TuplesKt.to(KtTokens.OPEN_KEYWORD, CollectionsKt.listOf(new KtModifierKeywordToken[]{KtTokens.FINAL_KEYWORD, KtTokens.ABSTRACT_KEYWORD})), TuplesKt.to(KtTokens.FINAL_KEYWORD, CollectionsKt.listOf(new KtModifierKeywordToken[]{KtTokens.ABSTRACT_KEYWORD, KtTokens.OPEN_KEYWORD})), TuplesKt.to(KtTokens.PUBLIC_KEYWORD, CollectionsKt.listOf(new KtModifierKeywordToken[]{KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD})), TuplesKt.to(KtTokens.PROTECTED_KEYWORD, CollectionsKt.listOf(new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD})), TuplesKt.to(KtTokens.PRIVATE_KEYWORD, CollectionsKt.listOf(new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.INTERNAL_KEYWORD})), TuplesKt.to(KtTokens.INTERNAL_KEYWORD, CollectionsKt.listOf(new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD})));
    private static final List<KtModifierKeywordToken> MODIFIERS_ORDER = CollectionsKt.listOf(new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD, KtTokens.FINAL_KEYWORD, KtTokens.OPEN_KEYWORD, KtTokens.ABSTRACT_KEYWORD, KtTokens.OVERRIDE_KEYWORD, KtTokens.INNER_KEYWORD, KtTokens.ENUM_KEYWORD, KtTokens.COMPANION_KEYWORD, KtTokens.INFIX_KEYWORD, KtTokens.OPERATOR_KEYWORD});

    private static final KtModifierList createModifierList(String text, KtModifierListOwner owner) {
        KtModifierList newModifierList = KtPsiFactoryKt.KtPsiFactory(owner).createModifierList(text);
        PsiElement psiElement = owner.getFirstChild();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        PsiElement anchor2 = (PsiElement)SequencesKt.first(SequencesKt.dropWhile(PsiUtilsKt.siblings$default(psiElement, true, false, 2, null), createModifierList.anchor.1.INSTANCE));
        PsiElement psiElement2 = owner.addBefore(newModifierList, anchor2);
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtModifierList");
        }
        return (KtModifierList)psiElement2;
    }

    public static final void addModifier(@NotNull KtModifierListOwner owner, @NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull(owner, "owner");
        Intrinsics.checkParameterIsNotNull(modifier, "modifier");
        KtModifierList modifierList = owner.getModifierList();
        if (modifierList == null) {
            String string = modifier.getValue();
            Intrinsics.checkExpressionValueIsNotNull(string, "modifier.value");
            AddRemoveModifierKt.createModifierList(string, owner);
        } else {
            AddRemoveModifierKt.addModifier(modifierList, modifier);
        }
    }

    @NotNull
    public static final KtAnnotationEntry addAnnotationEntry(@NotNull KtModifierListOwner owner, @NotNull KtAnnotationEntry annotationEntry) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkParameterIsNotNull(owner, "owner");
        Intrinsics.checkParameterIsNotNull(annotationEntry, "annotationEntry");
        KtModifierList modifierList = owner.getModifierList();
        if (modifierList == null) {
            String string = annotationEntry.getText();
            Intrinsics.checkExpressionValueIsNotNull(string, "annotationEntry.text");
            KtAnnotationEntry ktAnnotationEntry2 = CollectionsKt.first(AddRemoveModifierKt.createModifierList(string, owner).getAnnotationEntries());
            ktAnnotationEntry = ktAnnotationEntry2;
            Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry2, "createModifierList(annot\u2026annotationEntries.first()");
        } else {
            PsiElement psiElement = modifierList.addBefore(annotationEntry, modifierList.getFirstChild());
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            }
            ktAnnotationEntry = (KtAnnotationEntry)psiElement;
        }
        return ktAnnotationEntry;
    }

    /*
     * WARNING - void declaration
     */
    public static final void addModifier(@NotNull KtModifierList modifierList, @NotNull KtModifierKeywordToken modifier) {
        PsiElement modifierToReplace;
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull(modifierList, "modifierList");
        Intrinsics.checkParameterIsNotNull(modifier, "modifier");
        if (modifierList.hasModifier(modifier)) {
            return;
        }
        PsiElement newModifier = KtPsiFactoryKt.KtPsiFactory(modifierList).createModifier(modifier);
        List<KtModifierKeywordToken> list2 = MODIFIERS_TO_REPLACE.get(modifier);
        if (list2 != null) {
            void destination$iv$iv;
            void $receiver$iv$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = list2;
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList();
            void var6_7 = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Boolean bl;
                Object element$iv$iv = element$iv$iv$iv;
                KtModifierKeywordToken it = (KtModifierKeywordToken)element$iv$iv;
                if (modifierList.getModifier(it) != null) {
                    PsiElement psiElement2;
                    PsiElement it$iv$iv = psiElement2;
                    bl = destination$iv$iv.add(it$iv$iv);
                    continue;
                }
                bl = null;
            }
            psiElement = (PsiElement)CollectionsKt.firstOrNull((List)destination$iv$iv);
        } else {
            psiElement = modifierToReplace = null;
        }
        if (Intrinsics.areEqual(modifier, KtTokens.FINAL_KEYWORD) && !modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            if (modifierToReplace != null) {
                modifierToReplace.delete();
                if (modifierList.getFirstChild() == null) {
                    modifierList.delete();
                }
            }
            return;
        }
        if (modifierToReplace != null) {
            modifierToReplace.replace(newModifier);
        } else {
            PsiElement psiElement3;
            int newModifierOrder = MODIFIERS_ORDER.indexOf(modifier);
            Function1<PsiElement, Boolean> placeAfter$ = new Function1<PsiElement, Boolean>(newModifierOrder){
                final /* synthetic */ int $newModifierOrder;

                public final boolean invoke(@NotNull PsiElement child) {
                    Intrinsics.checkParameterIsNotNull(child, "child");
                    if (child instanceof PsiWhiteSpace) {
                        return false;
                    }
                    if (child instanceof KtAnnotation) {
                        return true;
                    }
                    ASTNode aSTNode = child.getNode();
                    if (aSTNode == null) {
                        Intrinsics.throwNpe();
                    }
                    IElementType elementType = aSTNode.getElementType();
                    int order = CollectionsKt.indexOf(AddRemoveModifierKt.access$getMODIFIERS_ORDER$p(), elementType);
                    return this.$newModifierOrder > order;
                }
                {
                    this.$newModifierOrder = n;
                    super(1);
                }
            };
            PsiElement lastChild = modifierList.getLastChild();
            Object object = lastChild;
            if (object != null && (object = PsiUtilsKt.siblings$default((PsiElement)object, false, false, 2, null)) != null) {
                Object v4;
                block16: {
                    void $receiver$iv;
                    Object object2 = object;
                    for (Object element$iv : $receiver$iv) {
                        PsiElement p1 = (PsiElement)element$iv;
                        if (!placeAfter$.invoke(p1)) continue;
                        v4 = element$iv;
                        break block16;
                    }
                    v4 = null;
                }
                psiElement3 = v4;
            } else {
                psiElement3 = null;
            }
            PsiElement anchor2 = psiElement3;
            modifierList.addAfter(newModifier, anchor2);
            if (Intrinsics.areEqual(anchor2, lastChild)) {
                PsiWhiteSpace whiteSpace;
                PsiElement psiElement4 = modifierList.getNextSibling();
                if (!(psiElement4 instanceof PsiWhiteSpace)) {
                    psiElement4 = null;
                }
                if ((whiteSpace = (PsiWhiteSpace)psiElement4) != null && StringsKt.contains$default((CharSequence)whiteSpace.getText(), '\n', false, 2, null)) {
                    modifierList.addAfter(whiteSpace, anchor2);
                    whiteSpace.delete();
                }
            }
        }
    }

    public static final void removeModifier(@NotNull KtModifierListOwner owner, @NotNull KtModifierKeywordToken modifier) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(owner, "owner");
        Intrinsics.checkParameterIsNotNull(modifier, "modifier");
        KtModifierList ktModifierList = owner.getModifierList();
        if (ktModifierList != null) {
            Unit unit2;
            KtModifierList ktModifierList2 = ktModifierList;
            KtModifierList it = ktModifierList2;
            PsiElement psiElement = it.getModifier(modifier);
            if (psiElement != null) {
                psiElement.delete();
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            if (it.getFirstChild() == null) {
                it.delete();
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    @NotNull
    public static final /* synthetic */ List access$getMODIFIERS_ORDER$p() {
        return MODIFIERS_ORDER;
    }
}

