/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.reference.VariableAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public final class QualifiedExpressionTranslator {
    private QualifiedExpressionTranslator() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtQualifiedExpression expression, @NotNull TranslationContext context, boolean forceOrderOfEvaluation) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "getAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "getAccessTranslator"));
        }
        JsExpression receiver = QualifiedExpressionTranslator.translateReceiver(expression, context);
        if (forceOrderOfEvaluation && receiver != null) {
            TemporaryVariable temporaryVariable = context.declareTemporary(null);
            context.addStatementToCurrentBlock(JsAstUtils.assignment(temporaryVariable.reference(), receiver).makeStmt());
            receiver = temporaryVariable.reference();
        }
        VariableAccessTranslator variableAccessTranslator = VariableAccessTranslator.newInstance(context, PsiUtils.getNotNullSimpleNameSelector(expression), receiver);
        if (variableAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "getAccessTranslator"));
        }
        return variableAccessTranslator;
    }

    @NotNull
    public static JsNode translateQualifiedExpression(@NotNull KtQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "translateQualifiedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "translateQualifiedExpression"));
        }
        ResolvedCall<? extends CallableDescriptor> call = CallUtilKt.getResolvedCall(expression, context.bindingContext());
        JsExpression receiver = null;
        if (call != null) {
            receiver = QualifiedExpressionTranslator.translateReceiver(expression, context);
        }
        KtExpression selector = PsiUtils.getSelector(expression);
        JsNode jsNode = QualifiedExpressionTranslator.dispatchToCorrectTranslator(receiver, selector, context);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "translateQualifiedExpression"));
        }
        return jsNode;
    }

    @NotNull
    private static JsNode dispatchToCorrectTranslator(@Nullable JsExpression receiver, @NotNull KtExpression selector, @NotNull TranslationContext context) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
        }
        if (ReferenceTranslator.canBePropertyAccess(selector, context)) {
            assert (selector instanceof KtSimpleNameExpression) : "Selectors for properties must be simple names.";
            JsExpression jsExpression = VariableAccessTranslator.newInstance(context, (KtSimpleNameExpression)selector, receiver).translateAsGet();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
            }
            return jsExpression;
        }
        if (selector instanceof KtCallExpression) {
            JsNode jsNode = QualifiedExpressionTranslator.invokeCallExpressionTranslator(receiver, selector, context);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
            }
            return jsNode;
        }
        if (selector instanceof KtSimpleNameExpression) {
            JsExpression jsExpression = ReferenceTranslator.translateSimpleName((KtSimpleNameExpression)selector, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
            }
            return jsExpression;
        }
        throw new AssertionError((Object)("Unexpected qualified expression: " + selector.getText()));
    }

    @NotNull
    private static JsNode invokeCallExpressionTranslator(@Nullable JsExpression receiver, @NotNull KtExpression selector, @NotNull TranslationContext context) {
        JsNode jsNode;
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "invokeCallExpressionTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "invokeCallExpressionTranslator"));
        }
        try {
            jsNode = CallExpressionTranslator.translate((KtCallExpression)selector, receiver, context);
        }
        catch (RuntimeException e) {
            throw ErrorReportingUtils.reportErrorWithLocation(selector, e);
        }
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "invokeCallExpressionTranslator"));
        }
        return jsNode;
    }

    @Nullable
    private static JsExpression translateReceiver(@NotNull KtQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "translateReceiver"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "translateReceiver"));
        }
        KtExpression receiverExpression = expression.getReceiverExpression();
        if (QualifiedExpressionTranslator.isFullQualifierForExpression(receiverExpression, context)) {
            return null;
        }
        return Translation.translateAsExpression(receiverExpression, context);
    }

    private static boolean isFullQualifierForExpression(@Nullable KtExpression receiverExpression, @NotNull TranslationContext context) {
        DeclarationDescriptor descriptorForReferenceExpression;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "isFullQualifierForExpression"));
        }
        if (receiverExpression == null) {
            return false;
        }
        if (receiverExpression instanceof KtReferenceExpression && (descriptorForReferenceExpression = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), (KtReferenceExpression)receiverExpression)) instanceof PackageViewDescriptor) {
            return true;
        }
        if (receiverExpression instanceof KtQualifiedExpression) {
            return QualifiedExpressionTranslator.isFullQualifierForExpression(((KtQualifiedExpression)receiverExpression).getSelectorExpression(), context);
        }
        return false;
    }
}

