/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.InlineableResult;
import org.jetbrains.kotlin.js.inline.clean.RemoveDefaultInitializersKt;
import org.jetbrains.kotlin.js.inline.context.FunctionContext;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.inline.util.NamingUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.ReturnReplacingVisitor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLabel;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u0006\u0010\u001e\u001a\u00020\u001bJ\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0019H\u0002J\b\u0010!\u001a\u00020\u001bH\u0002J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\b\u0010$\u001a\u00020\u001bH\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010'\u001a\u00020\u0015H\u0002J\b\u0010(\u001a\u00020\u0015H\u0002J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\bH\u0002J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/js/inline/FunctionInlineMutator;", "", "call", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "(Lcom/google/dart/compiler/backend/js/ast/JsInvocation;Lorg/jetbrains/kotlin/js/inline/context/InliningContext;)V", "body", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsBlock;", "breakLabel", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsLabel;", "currentStatement", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "Lorg/jetbrains/annotations/Nullable;", "invokedFunction", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunction;", "namingContext", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "resultExpr", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "applyCapturedArgs", "", "inner", "outer", "getArguments", "", "getBreakLabel", "", "getInnerCall", "qualifier", "getLabelPrefix", "getParameters", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsParameter;", "getResultLabel", "getResultReference", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef;", "getThisAlias", "isResultNeeded", "", "process", "processReturns", "replaceThis", "block", "uncoverClosure", "Companion", "kotlin-compiler"})
public final class FunctionInlineMutator {
    private final JsFunction invokedFunction;
    private final NamingContext namingContext;
    private final JsBlock body;
    private JsExpression resultExpr;
    private JsLabel breakLabel;
    private final JsStatement currentStatement;
    private final JsInvocation call;
    private final InliningContext inliningContext;
    public static final Companion Companion = new Companion(null);

    private final void process() {
        JsExpression jsExpression;
        List<JsExpression> arguments2 = this.getArguments();
        List<JsParameter> parameters2 = this.getParameters();
        RemoveDefaultInitializersKt.removeDefaultInitializers(arguments2, parameters2, this.body);
        NamingUtilsKt.aliasArgumentsIfNeeded(this.namingContext, arguments2, parameters2);
        NamingUtilsKt.renameLocalNames(this.namingContext, this.invokedFunction);
        this.processReturns();
        this.namingContext.applyRenameTo(this.body);
        FunctionInlineMutator functionInlineMutator = this;
        JsExpression jsExpression2 = this.resultExpr;
        if (jsExpression2 != null) {
            JsExpression jsExpression3 = jsExpression2;
            FunctionInlineMutator functionInlineMutator2 = functionInlineMutator;
            JsExpression it = jsExpression3;
            JsNode jsNode = this.namingContext.applyRenameTo(it);
            if (jsNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsExpression");
            }
            JsExpression jsExpression4 = (JsExpression)jsNode;
            functionInlineMutator = functionInlineMutator2;
            jsExpression = jsExpression4;
        } else {
            jsExpression = null;
        }
        functionInlineMutator.resultExpr = jsExpression;
    }

    private final JsFunction uncoverClosure(JsFunction invokedFunction) {
        JsFunction jsFunction;
        JsFunction innerFunction = FunctionUtilsKt.getInnerFunction(invokedFunction);
        JsExpression jsExpression = this.call.getQualifier();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "call.qualifier");
        JsInvocation innerCall = this.getInnerCall(jsExpression);
        if (innerCall != null && innerFunction != null) {
            JsFunction jsFunction2 = innerFunction;
            JsFunction $receiver = jsFunction2;
            JsBlock jsBlock = $receiver.getBody();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "body");
            this.replaceThis(jsBlock);
            this.applyCapturedArgs(innerCall, $receiver, invokedFunction);
            jsFunction = jsFunction2;
        } else {
            JsFunction jsFunction3 = invokedFunction;
            JsFunction $receiver = jsFunction3;
            JsBlock jsBlock = $receiver.getBody();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "body");
            this.replaceThis(jsBlock);
            jsFunction = jsFunction3;
        }
        return jsFunction;
    }

    private final JsInvocation getInnerCall(JsExpression qualifier2) {
        JsInvocation jsInvocation;
        JsExpression jsExpression = qualifier2;
        if (jsExpression instanceof JsInvocation) {
            jsInvocation = (JsInvocation)qualifier2;
        } else if (jsExpression instanceof JsNameRef) {
            JsExpression callee;
            JsExpression jsExpression2;
            if (Intrinsics.areEqual(((JsNameRef)qualifier2).getIdent(), "call")) {
                jsExpression2 = ((JsNameRef)qualifier2).getQualifier();
            } else {
                JsName jsName = ((JsNameRef)qualifier2).getName();
                JsNode jsNode = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
                if (!(jsNode instanceof JsExpression)) {
                    jsNode = null;
                }
                jsExpression2 = (JsExpression)jsNode;
            }
            JsExpression jsExpression3 = callee = jsExpression2;
            if (jsExpression3 != null) {
                JsExpression it;
                JsExpression jsExpression4 = jsExpression3;
                JsExpression jsExpression5 = it = jsExpression4;
                Intrinsics.checkExpressionValueIsNotNull(jsExpression5, "it");
                jsInvocation = this.getInnerCall(jsExpression5);
            } else {
                jsInvocation = null;
            }
        } else {
            jsInvocation = null;
        }
        return jsInvocation;
    }

    private final void applyCapturedArgs(JsInvocation call, JsFunction inner, JsFunction outer) {
        NamingContext namingContext = this.inliningContext.newNamingContext();
        List<JsExpression> arguments2 = call.getArguments();
        List<JsParameter> parameters2 = outer.getParameters();
        List<JsExpression> list2 = arguments2;
        Intrinsics.checkExpressionValueIsNotNull(list2, "arguments");
        List<JsParameter> list3 = parameters2;
        Intrinsics.checkExpressionValueIsNotNull(list3, "parameters");
        NamingUtilsKt.aliasArgumentsIfNeeded(namingContext, list2, list3);
        namingContext.applyRenameTo(inner);
    }

    private final void replaceThis(JsBlock block) {
        if (!FunctionInlineMutator.Companion.hasThisReference(block)) {
            return;
        }
        JsExpression thisReplacement = FunctionInlineMutator.Companion.getThisReplacement(this.call);
        if (thisReplacement == null || thisReplacement instanceof JsLiteral.JsThisRef) {
            return;
        }
        if (SideEffectUtilsKt.needToAlias(thisReplacement)) {
            JsName thisName = this.namingContext.getFreshName(this.getThisAlias());
            this.namingContext.newVar(thisName, thisReplacement);
            thisReplacement = thisName.makeRef();
        }
        RewriteUtilsKt.replaceThisReference((JsNode)block, thisReplacement);
    }

    private final void processReturns() {
        JsLabel jsLabel;
        Unit unit;
        JsNameRef resultReference = this.getResultReference();
        if (resultReference != null) {
            this.resultExpr = resultReference;
        }
        boolean bl = this.resultExpr == null || this.resultExpr instanceof JsNameRef;
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        JsName breakName = this.namingContext.getFreshName(this.getBreakLabel());
        JsLabel jsLabel2 = new JsLabel(breakName);
        FunctionInlineMutator functionInlineMutator = this;
        JsLabel $receiver = jsLabel2;
        MetadataProperties.setSynthetic($receiver, true);
        functionInlineMutator.breakLabel = jsLabel = jsLabel2;
        JsExpression jsExpression = this.resultExpr;
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        ReturnReplacingVisitor visitor2 = new ReturnReplacingVisitor((JsNameRef)jsExpression, breakName.makeRef(), this.invokedFunction);
        visitor2.accept((JsNode)this.body);
    }

    private final JsNameRef getResultReference() {
        if (!this.isResultNeeded(this.call)) {
            return null;
        }
        JsName resultName = this.namingContext.getFreshName(this.getResultLabel());
        this.namingContext.newVar(resultName, null);
        return resultName.makeRef();
    }

    private final List<JsExpression> getArguments() {
        List<JsExpression> arguments2 = this.call.getArguments();
        if (InvocationUtilsKt.isCallInvocation(this.call)) {
            return arguments2.subList(1, arguments2.size());
        }
        List<JsExpression> list2 = arguments2;
        Intrinsics.checkExpressionValueIsNotNull(list2, "arguments");
        return list2;
    }

    private final boolean isResultNeeded(JsInvocation call) {
        return !(this.currentStatement instanceof JsExpressionStatement) || Intrinsics.areEqual(call, ((JsExpressionStatement)this.currentStatement).getExpression()) ^ true;
    }

    private final List<JsParameter> getParameters() {
        List<JsParameter> list2 = this.invokedFunction.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "invokedFunction.parameters");
        return list2;
    }

    private final String getResultLabel() {
        return this.getLabelPrefix() + "result";
    }

    private final String getBreakLabel() {
        return this.getLabelPrefix() + "break";
    }

    private final String getThisAlias() {
        return "$this";
    }

    @NotNull
    public final String getLabelPrefix() {
        String labelPrefix;
        String ident = InvocationUtilsKt.getSimpleIdent(this.call);
        String string = ident;
        if (string == null) {
            string = labelPrefix = "inline$";
        }
        if (StringsKt.endsWith$default(labelPrefix, "$", false, 2, null)) {
            return labelPrefix;
        }
        return labelPrefix + "$";
    }

    private FunctionInlineMutator(JsInvocation call, InliningContext inliningContext) {
        this.call = call;
        this.inliningContext = inliningContext;
        this.currentStatement = this.inliningContext.getStatementContext().getCurrentNode();
        this.namingContext = this.inliningContext.newNamingContext();
        FunctionContext functionContext = this.inliningContext.getFunctionContext();
        JsFunction jsFunction = functionContext.getFunctionDefinition(this.call).deepCopy();
        Intrinsics.checkExpressionValueIsNotNull(jsFunction, "functionContext.getFunct\u2026finition(call).deepCopy()");
        this.invokedFunction = this.uncoverClosure(jsFunction);
        JsBlock jsBlock = this.invokedFunction.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "invokedFunction.body");
        this.body = jsBlock;
    }

    public /* synthetic */ FunctionInlineMutator(@NotNull JsInvocation call, @NotNull InliningContext inliningContext, DefaultConstructorMarker $constructor_marker) {
        this(call, inliningContext);
    }

    public static final /* synthetic */ void access$setBreakLabel$p(FunctionInlineMutator $this, @Nullable JsLabel jsLabel) {
        $this.breakLabel = jsLabel;
    }

    public static final /* synthetic */ void access$setResultExpr$p(FunctionInlineMutator $this, @Nullable JsExpression jsExpression) {
        $this.resultExpr = jsExpression;
    }

    @JvmStatic
    @NotNull
    public static final InlineableResult getInlineableCallReplacement(@NotNull JsInvocation call, @NotNull InliningContext inliningContext) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        Intrinsics.checkParameterIsNotNull(inliningContext, "inliningContext");
        return Companion.getInlineableCallReplacement(call, inliningContext);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/FunctionInlineMutator$Companion;", "", "()V", "getInlineableCallReplacement", "Lorg/jetbrains/kotlin/js/inline/InlineableResult;", "call", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "getThisReplacement", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "hasThisReference", "", "body", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsBlock;", "kotlin-compiler"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final InlineableResult getInlineableCallReplacement(@NotNull JsInvocation call, @NotNull InliningContext inliningContext) {
            Intrinsics.checkParameterIsNotNull(call, "call");
            Intrinsics.checkParameterIsNotNull(inliningContext, "inliningContext");
            FunctionInlineMutator mutator = new FunctionInlineMutator(call, inliningContext, null);
            mutator.process();
            JsStatement inlineableBody = mutator.body;
            JsLabel breakLabel = mutator.breakLabel;
            if (breakLabel != null) {
                breakLabel.setStatement(inlineableBody);
                inlineableBody = breakLabel;
            }
            return new InlineableResult(inlineableBody, mutator.resultExpr);
        }

        @JvmStatic
        private final JsExpression getThisReplacement(JsInvocation call) {
            if (InvocationUtilsKt.isCallInvocation(call)) {
                return call.getArguments().get(0);
            }
            if (InvocationUtilsKt.hasCallerQualifier(call)) {
                return InvocationUtilsKt.getCallerQualifier(call);
            }
            return null;
        }

        private final boolean hasThisReference(JsBlock body) {
            List<JsLiteral.JsThisRef> thisRefs = CollectUtilsKt.collectInstances(JsLiteral.JsThisRef.class, body);
            return !thisRefs.isEmpty();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

