/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.testFramework.LightVirtualFile;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.UninitializedPropertyAccessException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.DiagnosticMessageReporter;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.ModuleNameKt;
import org.jetbrains.kotlin.cli.jvm.repl.DelegatePackageMemberDeclarationProvider;
import org.jetbrains.kotlin.cli.jvm.repl.EarlierLine;
import org.jetbrains.kotlin.cli.jvm.repl.ReplClassLoader;
import org.jetbrains.kotlin.cli.jvm.repl.ReplInterpreter;
import org.jetbrains.kotlin.cli.jvm.repl.di.ContainerForReplWithJava;
import org.jetbrains.kotlin.cli.jvm.repl.di.InjectionKt;
import org.jetbrains.kotlin.cli.jvm.repl.di.ReplLastLineScopeProvider;
import org.jetbrains.kotlin.cli.jvm.repl.messages.DiagnosticMessageHolder;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplIdeDiagnosticMessageHolder;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplSystemInWrapper;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplTerminalDiagnosticMessageHolder;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.impl.CompositePackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.relocated.com.google.common.base.Throwables;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzerForTopLevel;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.CombinedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyScriptDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.ScriptParameter;
import org.jetbrains.kotlin.script.ScriptPriorities;
import org.jetbrains.kotlin.script.StandardScriptDefinition;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 32\u00020\u0001:\u00043456B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010$\u001a\u00020%H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0017R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter;", "", "disposable", "Lcom/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "ideMode", "", "replReader", "Lorg/jetbrains/kotlin/cli/jvm/repl/messages/ReplSystemInWrapper;", "(Lcom/intellij/openapi/Disposable;Lorg/jetbrains/kotlin/config/CompilerConfiguration;ZLorg/jetbrains/kotlin/cli/jvm/repl/messages/ReplSystemInWrapper;)V", "classLoader", "Lorg/jetbrains/kotlin/cli/jvm/repl/ReplClassLoader;", "earlierLines", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/cli/jvm/repl/EarlierLine;", "lastLineScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "lineNumber", "", "module", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "previousIncompleteLines", "", "psiFileFactory", "Lcom/intellij/psi/impl/PsiFileFactoryImpl;", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "scriptDeclarationFactory", "Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$ScriptMutableDeclarationProviderFactory;", "topDownAnalysisContext", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "topDownAnalyzer", "Lorg/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTraceContext;", "createDiagnosticHolder", "Lorg/jetbrains/kotlin/cli/jvm/repl/messages/DiagnosticMessageHolder;", "doAnalyze", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "errorReporter", "Lorg/jetbrains/kotlin/cli/common/messages/DiagnosticMessageReporter;", "dumpClasses", "", "out", "Ljava/io/PrintWriter;", "eval", "Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult;", "line", "Companion", "LineResult", "LineResultType", "ScriptMutableDeclarationProviderFactory", "kotlin-compiler"})
public final class ReplInterpreter {
    private int lineNumber;
    private LexicalScope lastLineScope;
    private final ArrayList<EarlierLine> earlierLines;
    private final ArrayList<String> previousIncompleteLines;
    private final ReplClassLoader classLoader;
    private final PsiFileFactoryImpl psiFileFactory;
    private final BindingTraceContext trace;
    private final ModuleDescriptorImpl module;
    private final TopDownAnalysisContext topDownAnalysisContext;
    private final LazyTopDownAnalyzerForTopLevel topDownAnalyzer;
    private final ResolveSession resolveSession;
    private final ScriptMutableDeclarationProviderFactory scriptDeclarationFactory;
    private final boolean ideMode;
    private final ReplSystemInWrapper replReader;
    private static final String SCRIPT_RESULT_FIELD_NAME = "$$result";
    private static final Companion.REPL_LINE_AS_SCRIPT_DEFINITION.1 REPL_LINE_AS_SCRIPT_DEFINITION;
    public static final Companion Companion;

    private final DiagnosticMessageHolder createDiagnosticHolder() {
        return this.ideMode ? (DiagnosticMessageHolder)new ReplIdeDiagnosticMessageHolder() : (DiagnosticMessageHolder)new ReplTerminalDiagnosticMessageHolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final LineResult eval(@NotNull String line) {
        Collection p1;
        List list2;
        Object destination$iv$iv;
        Object item$iv$iv;
        Iterator<OutputFile> $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(line, "line");
        ReplInterpreter replInterpreter = this;
        ++replInterpreter.lineNumber;
        int cfr_ignored_0 = replInterpreter.lineNumber;
        String fullText = CollectionsKt.joinToString$default(CollectionsKt.plus((Collection)this.previousIncompleteLines, line), "\n", null, null, 0, null, null, 62, null);
        LightVirtualFile lightVirtualFile = new LightVirtualFile("line" + this.lineNumber + KotlinParserDefinition.STD_SCRIPT_EXT, KotlinLanguage.INSTANCE, (CharSequence)fullText);
        Object $receiver = lightVirtualFile;
        ((VirtualFile)$receiver).setCharset(CharsetToolkit.UTF8_CHARSET);
        LightVirtualFile virtualFile = lightVirtualFile;
        KtFile ktFile = (KtFile)this.psiFileFactory.trySetupPsiForFile(virtualFile, KotlinLanguage.INSTANCE, true, false);
        if (ktFile == null) {
            $receiver = "Script file not analyzed at line " + this.lineNumber + ": " + fullText;
            throw (Throwable)new IllegalStateException($receiver.toString());
        }
        KtFile psiFile = ktFile;
        DiagnosticMessageHolder errorHolder = this.createDiagnosticHolder();
        AnalyzerWithCompilerReport.SyntaxErrorReport syntaxErrorReport = AnalyzerWithCompilerReport.Companion.reportSyntaxErrors((PsiElement)psiFile, errorHolder);
        if (syntaxErrorReport.isHasErrors() && syntaxErrorReport.isAllErrorsAtEof()) {
            LineResult lineResult;
            if (this.ideMode) {
                lineResult = LineResult.Companion.compileError(errorHolder.getRenderedDiagnostics());
            } else {
                this.previousIncompleteLines.add(line);
                lineResult = LineResult.Companion.incomplete();
            }
            return lineResult;
        }
        this.previousIncompleteLines.clear();
        if (syntaxErrorReport.isHasErrors()) {
            return LineResult.Companion.compileError(errorHolder.getRenderedDiagnostics());
        }
        ReplInterpreter.Companion.prepareForTheNextReplLine(this.topDownAnalysisContext);
        this.trace.clearDiagnostics();
        KtScript ktScript = psiFile.getScript();
        if (ktScript == null) {
            Intrinsics.throwNpe();
        }
        ktScript.putUserData(ScriptPriorities.PRIORITY_KEY, this.lineNumber);
        ScriptDescriptor scriptDescriptor = this.doAnalyze(psiFile, errorHolder);
        if (scriptDescriptor == null) {
            return LineResult.Companion.compileError(errorHolder.getRenderedDiagnostics());
        }
        ScriptDescriptor scriptDescriptor2 = scriptDescriptor;
        Project project = psiFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "psiFile.project");
        ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.BINARIES;
        Intrinsics.checkExpressionValueIsNotNull(classBuilderFactory, "ClassBuilderFactories.BINARIES");
        ModuleDescriptor moduleDescriptor = this.module;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        GenerationState state2 = new GenerationState(project, classBuilderFactory, moduleDescriptor, bindingContext, CollectionsKt.listOf(psiFile), false, false, null, false, false, false, false, null, null, null, null, null, null, null, null, null, 2097120, null);
        KtScript ktScript2 = psiFile.getScript();
        if (ktScript2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(ktScript2, "psiFile.script!!");
        Iterable iterable = this.earlierLines;
        Object object = ktScript2;
        Object object2 = Companion;
        void var12_13 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Object object3 = $receiver$iv$iv.iterator();
        while (object3.hasNext()) {
            item$iv$iv = object3.next();
            EarlierLine earlierLine = (EarlierLine)item$iv$iv;
            list2 = destination$iv$iv;
            ScriptDescriptor scriptDescriptor3 = ((EarlierLine)((Object)p1)).getScriptDescriptor();
            list2.add(scriptDescriptor3);
        }
        list2 = (List)destination$iv$iv;
        CompilationErrorHandler compilationErrorHandler = CompilationErrorHandler.THROW_EXCEPTION;
        Intrinsics.checkExpressionValueIsNotNull(compilationErrorHandler, "CompilationErrorHandler.THROW_EXCEPTION");
        ((Companion)object2).compileScript((KtScript)object, list2, state2, compilationErrorHandler);
        for (OutputFile outputFile : state2.getFactory().asList()) {
            if (!StringsKt.endsWith$default(outputFile.getRelativePath(), ".class", false, 2, null)) continue;
            destination$iv$iv = outputFile.getRelativePath();
            object3 = "\\.class$";
            object2 = this.classLoader;
            object3 = object = new Regex((String)object3);
            item$iv$iv = "";
            object = ((Regex)object3).replaceFirst((CharSequence)destination$iv$iv, (String)item$iv$iv);
            ((ReplClassLoader)object2).addClass(JvmClassName.byInternalName((String)object), outputFile.asByteArray());
        }
        try {
            Object $i$f$toTypedArray;
            void destination$iv$iv2;
            void $receiver$iv$iv2;
            Collection $receiver$iv2;
            void destination$iv$iv3;
            void $receiver$iv$iv3;
            Collection $receiver$iv3;
            Class<?> scriptClass = this.classLoader.loadClass("Line" + this.lineNumber);
            destination$iv$iv = this.earlierLines;
            object3 = $receiver$iv3;
            item$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv3, 10));
            for (Object item$iv$iv2 : $receiver$iv$iv3) {
                void p12;
                EarlierLine $i$f$mapTo = (EarlierLine)item$iv$iv2;
                object2 = destination$iv$iv3;
                object = p12.getScriptClass();
                object2.add(object);
            }
            $receiver$iv3 = (List)destination$iv$iv3;
            Iterable thisCollection$iv = $receiver$iv3;
            Class[] classArray = thisCollection$iv.toArray(new Class[thisCollection$iv.size()]);
            if (classArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Class[] constructorParams = (Class[])((Object[])classArray);
            thisCollection$iv = this.earlierLines;
            void $i$f$toTypedArray2 = $receiver$iv2;
            p1 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
            for (Object item$iv$iv3 : $receiver$iv$iv2) {
                void p13;
                EarlierLine $i$a$1$unknown = (EarlierLine)item$iv$iv3;
                object2 = destination$iv$iv2;
                object = p13.getScriptInstance();
                object2.add(object);
            }
            $receiver$iv2 = (List)destination$iv$iv2;
            Collection thisCollection$iv2 = $receiver$iv2;
            Object[] objectArray = thisCollection$iv2.toArray(new Object[thisCollection$iv2.size()]);
            if (objectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] constructorArgs = objectArray;
            Constructor<?> scriptInstanceConstructor = scriptClass.getConstructor(Arrays.copyOf(constructorParams, constructorParams.length));
            try {
                ReplSystemInWrapper replSystemInWrapper = this.replReader;
                if (replSystemInWrapper != null) {
                    replSystemInWrapper.setReplScriptExecuting(true);
                }
                $i$f$toTypedArray = scriptInstanceConstructor.newInstance(Arrays.copyOf(constructorArgs, constructorArgs.length));
            }
            catch (Throwable e) {
                Object item$iv$iv3;
                Throwable throwable = e.getCause();
                if (throwable == null) {
                    Intrinsics.throwNpe();
                }
                item$iv$iv3 = LineResult.Companion.runtimeError(ReplInterpreter.Companion.renderStackTrace(throwable));
                return item$iv$iv3;
            }
            finally {
                ReplSystemInWrapper replSystemInWrapper = this.replReader;
                if (replSystemInWrapper != null) {
                    replSystemInWrapper.setReplScriptExecuting(false);
                }
            }
            Object scriptInstance = $i$f$toTypedArray;
            Field e = scriptClass.getDeclaredField(ReplInterpreter.Companion.getSCRIPT_RESULT_FIELD_NAME());
            Field $receiver2 = e;
            $receiver2.setAccessible(true);
            Field rvField = e;
            Object rv = rvField.get(scriptInstance);
            this.earlierLines.add(new EarlierLine(line, scriptDescriptor2, scriptClass, scriptInstance));
            return LineResult.Companion.successful(rv, !state2.getReplSpecific().getHasResult());
        }
        catch (Throwable e) {
            PrintWriter writer = new PrintWriter(System.err);
            this.classLoader.dumpClasses(writer);
            writer.flush();
            throw e;
        }
    }

    private final ScriptDescriptor doAnalyze(KtFile psiFile, DiagnosticMessageReporter errorReporter) {
        LazyScriptDescriptor lazyScriptDescriptor;
        this.scriptDeclarationFactory.setDelegateFactory(new FileBasedDeclarationProviderFactory(this.resolveSession.getStorageManager(), (Collection<KtFile>)CollectionsKt.listOf(psiFile)));
        TopDownAnalysisContext context = this.topDownAnalyzer.analyzeDeclarations(this.topDownAnalysisContext.getTopDownAnalysisMode(), (Collection<? extends PsiElement>)CollectionsKt.listOf(psiFile));
        if (this.trace.get(BindingContext.FILE_TO_PACKAGE_FRAGMENT, psiFile) == null) {
            this.trace.record(BindingContext.FILE_TO_PACKAGE_FRAGMENT, psiFile, this.resolveSession.getPackageFragment(FqName.ROOT));
        }
        Diagnostics diagnostics2 = this.trace.getBindingContext().getDiagnostics();
        Intrinsics.checkExpressionValueIsNotNull(diagnostics2, "trace.bindingContext.diagnostics");
        boolean hasErrors = AnalyzerWithCompilerReport.Companion.reportDiagnostics(diagnostics2, errorReporter, false);
        if (hasErrors) {
            return null;
        }
        LazyScriptDescriptor lazyScriptDescriptor2 = context.getScripts().get(psiFile.getScript());
        if (lazyScriptDescriptor2 != null) {
            LazyScriptDescriptor lazyScriptDescriptor3 = lazyScriptDescriptor2;
            LazyScriptDescriptor $receiver = lazyScriptDescriptor3;
            this.lastLineScope = $receiver.getScopeForInitializerResolution();
            lazyScriptDescriptor = lazyScriptDescriptor3;
        } else {
            lazyScriptDescriptor = null;
        }
        return lazyScriptDescriptor;
    }

    public final void dumpClasses(@NotNull PrintWriter out) {
        Intrinsics.checkParameterIsNotNull(out, "out");
        this.classLoader.dumpClasses(out);
    }

    /*
     * WARNING - void declaration
     */
    public ReplInterpreter(@NotNull Disposable disposable, @NotNull CompilerConfiguration configuration, boolean ideMode, @Nullable ReplSystemInWrapper replReader) {
        ReplClassLoader replClassLoader;
        URLClassLoader uRLClassLoader;
        Object object;
        ReplInterpreter replInterpreter;
        void destination$iv$iv;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(disposable, "disposable");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        this.ideMode = ideMode;
        this.replReader = replReader;
        this.earlierLines = CollectionsKt.arrayListOf(new EarlierLine[0]);
        this.previousIncompleteLines = CollectionsKt.arrayListOf(new String[0]);
        configuration.add(CommonConfigurationKeys.SCRIPT_DEFINITIONS_KEY, ReplInterpreter.Companion.getREPL_LINE_AS_SCRIPT_DEFINITION());
        List<String> list2 = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        Intrinsics.checkExpressionValueIsNotNull(list2, "EnvironmentConfigFiles.JVM_CONFIG_FILES");
        KotlinCoreEnvironment environment2 = KotlinCoreEnvironment.Companion.createForProduction(disposable, configuration, list2);
        Project project = environment2.getProject();
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance(project);
        if (psiFileFactory == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.PsiFileFactoryImpl");
        }
        this.psiFileFactory = (PsiFileFactoryImpl)psiFileFactory;
        this.trace = new CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace();
        MutableModuleContext moduleContext = TopDownAnalyzerFacadeForJVM.createContextWithSealedModule(project, ModuleNameKt.getModuleName(environment2));
        this.module = moduleContext.getModule();
        this.scriptDeclarationFactory = new ScriptMutableDeclarationProviderFactory();
        ModuleContext moduleContext2 = moduleContext;
        Intrinsics.checkExpressionValueIsNotNull(moduleContext2, "moduleContext");
        BindingTrace bindingTrace = this.trace;
        DeclarationProviderFactory declarationProviderFactory2 = this.scriptDeclarationFactory;
        GlobalSearchScope globalSearchScope = ProjectScope.getAllScope(project);
        Intrinsics.checkExpressionValueIsNotNull(globalSearchScope, "ProjectScope.getAllScope(project)");
        ContainerForReplWithJava container2 = InjectionKt.createContainerForReplWithJava(moduleContext2, bindingTrace, declarationProviderFactory2, globalSearchScope, new ReplLastLineScopeProvider(this){
            final /* synthetic */ ReplInterpreter this$0;

            @Nullable
            public LexicalScope getLastLineScope() {
                return ReplInterpreter.access$getLastLineScope$p(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        }, new JvmPackagePartProvider(environment2));
        this.topDownAnalysisContext = new TopDownAnalysisContext(TopDownAnalysisMode.LocalDeclarations, DataFlowInfoFactory.EMPTY, container2.getResolveSession().getDeclarationScopeProvider());
        this.topDownAnalyzer = container2.getLazyTopDownAnalyzerForTopLevel();
        this.resolveSession = container2.getResolveSession();
        moduleContext.initializeModuleContents(new CompositePackageFragmentProvider(CollectionsKt.listOf(new PackageFragmentProvider[]{container2.getResolveSession().getPackageFragmentProvider(), container2.getJavaDescriptorResolver().getPackageFragmentProvider()})));
        Iterable iterable = JvmContentRootsKt.getJvmClasspathRoots(configuration);
        void var10_10 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            replInterpreter = destination$iv$iv;
            object = it.toURI().toURL();
            replInterpreter.add(object);
        }
        List classpath = (List)destination$iv$iv;
        $receiver$iv = classpath;
        URLClassLoader uRLClassLoader2 = uRLClassLoader;
        URLClassLoader uRLClassLoader3 = uRLClassLoader;
        ReplClassLoader replClassLoader2 = replClassLoader;
        object = replClassLoader;
        replInterpreter = this;
        Collection thisCollection$iv = $receiver$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[thisCollection$iv.size()]);
        if (uRLArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = uRLArray;
        uRLClassLoader2((URL[])objectArray, (ClassLoader)null);
        replClassLoader2(uRLClassLoader3);
        replInterpreter.classLoader = object;
    }

    static {
        Companion = new Companion(null);
        SCRIPT_RESULT_FIELD_NAME = SCRIPT_RESULT_FIELD_NAME;
        REPL_LINE_AS_SCRIPT_DEFINITION = new KotlinScriptDefinition(){

            @NotNull
            public List<ScriptParameter> getScriptParameters(@NotNull ScriptDescriptor scriptDescriptor) {
                Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
                return CollectionsKt.emptyList();
            }

            public boolean isScript(@NotNull PsiFile file) {
                Intrinsics.checkParameterIsNotNull(file, "file");
                return StandardScriptDefinition.INSTANCE.isScript(file);
            }

            @NotNull
            public Name getScriptName(@NotNull KtScript script) {
                Intrinsics.checkParameterIsNotNull(script, "script");
                return StandardScriptDefinition.INSTANCE.getScriptName(script);
            }
        };
    }

    @Nullable
    public static final /* synthetic */ LexicalScope access$getLastLineScope$p(ReplInterpreter $this) {
        return $this.lastLineScope;
    }

    public static final /* synthetic */ void access$setLastLineScope$p(ReplInterpreter $this, @Nullable LexicalScope lexicalScope) {
        $this.lastLineScope = lexicalScope;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResultType;", "", "(Ljava/lang/String;I)V", "SUCCESS", "COMPILE_ERROR", "RUNTIME_ERROR", "INCOMPLETE", "kotlin-compiler"})
    public static final class LineResultType
    extends Enum<LineResultType> {
        public static final /* enum */ LineResultType SUCCESS;
        public static final /* enum */ LineResultType COMPILE_ERROR;
        public static final /* enum */ LineResultType RUNTIME_ERROR;
        public static final /* enum */ LineResultType INCOMPLETE;
        private static final /* synthetic */ LineResultType[] $VALUES;

        static {
            LineResultType[] lineResultTypeArray = new LineResultType[4];
            LineResultType[] lineResultTypeArray2 = lineResultTypeArray;
            lineResultTypeArray[0] = SUCCESS = new LineResultType();
            lineResultTypeArray[1] = COMPILE_ERROR = new LineResultType();
            lineResultTypeArray[2] = RUNTIME_ERROR = new LineResultType();
            lineResultTypeArray[3] = INCOMPLETE = new LineResultType();
            $VALUES = lineResultTypeArray;
        }

        public static LineResultType[] values() {
            return (LineResultType[])$VALUES.clone();
        }

        public static LineResultType valueOf(String string) {
            return Enum.valueOf(LineResultType.class, string);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B+\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult;", "", "resultingValue", "unit", "", "errorText", "", "type", "Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResultType;", "(Ljava/lang/Object;ZLjava/lang/String;Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResultType;)V", "getErrorText", "()Ljava/lang/String;", "isUnit", "()Z", "getType", "()Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResultType;", "value", "getValue", "()Ljava/lang/Object;", "checkSuccessful", "", "Companion", "kotlin-compiler"})
    public static final class LineResult {
        private final Object resultingValue;
        private final boolean unit;
        @Nullable
        private final String errorText;
        @NotNull
        private final LineResultType type;
        public static final Companion Companion = new Companion(null);

        @Nullable
        public final Object getValue() {
            this.checkSuccessful();
            return this.resultingValue;
        }

        public final boolean isUnit() {
            this.checkSuccessful();
            return this.unit;
        }

        private final void checkSuccessful() {
            if (Intrinsics.areEqual((Object)this.type, (Object)LineResultType.SUCCESS) ^ true) {
                String string = "it is error";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }

        @Nullable
        public final String getErrorText() {
            return this.errorText;
        }

        @NotNull
        public final LineResultType getType() {
            return this.type;
        }

        private LineResult(Object resultingValue, boolean unit, String errorText, LineResultType type2) {
            this.resultingValue = resultingValue;
            this.unit = unit;
            this.errorText = errorText;
            this.type = type2;
        }

        public /* synthetic */ LineResult(@Nullable Object resultingValue, boolean unit, @Nullable String errorText, @NotNull LineResultType type2, DefaultConstructorMarker $constructor_marker) {
            this(resultingValue, unit, errorText, type2);
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult$Companion;", "", "()V", "compileError", "Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult;", "errorText", "", "error", "errorType", "Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResultType;", "incomplete", "runtimeError", "successful", "value", "unit", "", "kotlin-compiler"})
        public static final class Companion {
            private final LineResult error(String errorText, LineResultType errorType) {
                CharSequence charSequence = errorText;
                String resultingErrorText = charSequence.length() == 0 ? "<unknown error>" : (!StringsKt.endsWith$default(errorText, "\n", false, 2, null) ? errorText + "\n" : errorText);
                return new LineResult(null, false, resultingErrorText, errorType, null);
            }

            @NotNull
            public final LineResult successful(@Nullable Object value, boolean unit) {
                return new LineResult(value, unit, null, LineResultType.SUCCESS, null);
            }

            @NotNull
            public final LineResult compileError(@NotNull String errorText) {
                Intrinsics.checkParameterIsNotNull(errorText, "errorText");
                return this.error(errorText, LineResultType.COMPILE_ERROR);
            }

            @NotNull
            public final LineResult runtimeError(@NotNull String errorText) {
                Intrinsics.checkParameterIsNotNull(errorText, "errorText");
                return this.error(errorText, LineResultType.RUNTIME_ERROR);
            }

            @NotNull
            public final LineResult incomplete() {
                return new LineResult(null, false, null, LineResultType.INCOMPLETE, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$ScriptMutableDeclarationProviderFactory;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/DeclarationProviderFactory;", "()V", "delegateFactory", "rootPackageProvider", "Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$ScriptMutableDeclarationProviderFactory$AdaptablePackageMemberDeclarationProvider;", "diagnoseMissingPackageFragment", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getClassMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/ClassMemberDeclarationProvider;", "classLikeInfo", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtClassLikeInfo;", "getPackageMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "setDelegateFactory", "AdaptablePackageMemberDeclarationProvider", "kotlin-compiler"})
    private static final class ScriptMutableDeclarationProviderFactory
    implements DeclarationProviderFactory {
        private DeclarationProviderFactory delegateFactory;
        private AdaptablePackageMemberDeclarationProvider rootPackageProvider;

        public final void setDelegateFactory(@NotNull DeclarationProviderFactory delegateFactory) {
            Intrinsics.checkParameterIsNotNull(delegateFactory, "delegateFactory");
            this.delegateFactory = delegateFactory;
            PackageMemberDeclarationProvider packageMemberDeclarationProvider = delegateFactory.getPackageMemberDeclarationProvider(FqName.ROOT);
            if (packageMemberDeclarationProvider == null) {
                Intrinsics.throwNpe();
            }
            PackageMemberDeclarationProvider provider = packageMemberDeclarationProvider;
            try {
                AdaptablePackageMemberDeclarationProvider adaptablePackageMemberDeclarationProvider = this.rootPackageProvider;
                if (adaptablePackageMemberDeclarationProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("rootPackageProvider");
                }
                PackageMemberDeclarationProvider packageMemberDeclarationProvider2 = provider;
                Intrinsics.checkExpressionValueIsNotNull(packageMemberDeclarationProvider2, "provider");
                adaptablePackageMemberDeclarationProvider.addDelegateProvider(packageMemberDeclarationProvider2);
            }
            catch (UninitializedPropertyAccessException e) {
                PackageMemberDeclarationProvider packageMemberDeclarationProvider3 = provider;
                Intrinsics.checkExpressionValueIsNotNull(packageMemberDeclarationProvider3, "provider");
                this.rootPackageProvider = new AdaptablePackageMemberDeclarationProvider(packageMemberDeclarationProvider3);
            }
        }

        @Override
        @NotNull
        public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull KtClassLikeInfo classLikeInfo) {
            Intrinsics.checkParameterIsNotNull(classLikeInfo, "classLikeInfo");
            DeclarationProviderFactory declarationProviderFactory2 = this.delegateFactory;
            if (declarationProviderFactory2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("delegateFactory");
            }
            ClassMemberDeclarationProvider classMemberDeclarationProvider = declarationProviderFactory2.getClassMemberDeclarationProvider(classLikeInfo);
            Intrinsics.checkExpressionValueIsNotNull(classMemberDeclarationProvider, "delegateFactory.getClass\u2026onProvider(classLikeInfo)");
            return classMemberDeclarationProvider;
        }

        @Override
        @Nullable
        public PackageMemberDeclarationProvider getPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
            Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
            if (packageFqName.isRoot()) {
                AdaptablePackageMemberDeclarationProvider adaptablePackageMemberDeclarationProvider = this.rootPackageProvider;
                if (adaptablePackageMemberDeclarationProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("rootPackageProvider");
                }
                return adaptablePackageMemberDeclarationProvider;
            }
            DeclarationProviderFactory declarationProviderFactory2 = this.delegateFactory;
            if (declarationProviderFactory2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("delegateFactory");
            }
            return declarationProviderFactory2.getPackageMemberDeclarationProvider(packageFqName);
        }

        @Override
        public void diagnoseMissingPackageFragment(@NotNull KtFile file) {
            Intrinsics.checkParameterIsNotNull(file, "file");
            DeclarationProviderFactory declarationProviderFactory2 = this.delegateFactory;
            if (declarationProviderFactory2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("delegateFactory");
            }
            declarationProviderFactory2.diagnoseMissingPackageFragment(file);
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$ScriptMutableDeclarationProviderFactory$AdaptablePackageMemberDeclarationProvider;", "Lorg/jetbrains/kotlin/cli/jvm/repl/DelegatePackageMemberDeclarationProvider;", "delegateProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "(Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;)V", "addDelegateProvider", "", "provider", "kotlin-compiler"})
        public static final class AdaptablePackageMemberDeclarationProvider
        extends DelegatePackageMemberDeclarationProvider {
            private PackageMemberDeclarationProvider delegateProvider;

            public final void addDelegateProvider(@NotNull PackageMemberDeclarationProvider provider) {
                Intrinsics.checkParameterIsNotNull(provider, "provider");
                this.delegateProvider = new CombinedPackageMemberDeclarationProvider((Collection<? extends PackageMemberDeclarationProvider>)CollectionsKt.listOf(new PackageMemberDeclarationProvider[]{provider, this.delegateProvider}));
                this.setDelegate(this.delegateProvider);
            }

            public AdaptablePackageMemberDeclarationProvider(@NotNull PackageMemberDeclarationProvider delegateProvider) {
                Intrinsics.checkParameterIsNotNull(delegateProvider, "delegateProvider");
                super(delegateProvider);
                this.delegateProvider = delegateProvider;
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000M\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$Companion;", "", "()V", "REPL_LINE_AS_SCRIPT_DEFINITION", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$Companion$REPL_LINE_AS_SCRIPT_DEFINITION$1", "getREPL_LINE_AS_SCRIPT_DEFINITION", "()Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$Companion$REPL_LINE_AS_SCRIPT_DEFINITION$1;", "Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$Companion$REPL_LINE_AS_SCRIPT_DEFINITION$1;", "SCRIPT_RESULT_FIELD_NAME", "", "getSCRIPT_RESULT_FIELD_NAME", "()Ljava/lang/String;", "compileScript", "", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "earlierScripts", "", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "errorHandler", "Lorg/jetbrains/kotlin/codegen/CompilationErrorHandler;", "prepareForTheNextReplLine", "c", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "renderStackTrace", "cause", "", "kotlin-compiler"})
    public static final class Companion {
        private final String getSCRIPT_RESULT_FIELD_NAME() {
            return SCRIPT_RESULT_FIELD_NAME;
        }

        private final REPL_LINE_AS_SCRIPT_DEFINITION.1 getREPL_LINE_AS_SCRIPT_DEFINITION() {
            return REPL_LINE_AS_SCRIPT_DEFINITION;
        }

        private final void prepareForTheNextReplLine(TopDownAnalysisContext c) {
            c.getScripts().clear();
        }

        /*
         * WARNING - void declaration
         */
        private final String renderStackTrace(Throwable cause) {
            void $receiver$iv;
            ArrayList<StackTraceElement> newTrace = CollectionsKt.arrayListOf(new StackTraceElement[0]);
            boolean skip2 = true;
            for (IndexedValue<Object> indexedValue : CollectionsKt.reversed(ArraysKt.withIndex((Object[])ExceptionsKt.getStackTrace(cause)))) {
                int i = indexedValue.component1();
                StackTraceElement element = (StackTraceElement)indexedValue.component2();
                if (Intrinsics.areEqual(element.getMethodName(), "<init>")) {
                    skip2 = false;
                }
                if (skip2) continue;
                newTrace.add(element);
            }
            List resultingTrace = CollectionsKt.dropLast(CollectionsKt.reversed((Iterable)newTrace), 1);
            Throwable throwable = cause;
            if (throwable == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
            }
            Collection collection = resultingTrace;
            Throwable throwable2 = throwable;
            void v1 = $receiver$iv;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v1;
            StackTraceElement[] stackTraceElementArray = thisCollection$iv.toArray(new StackTraceElement[thisCollection$iv.size()]);
            if (stackTraceElementArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray = stackTraceElementArray;
            throwable2.setStackTrace((StackTraceElement[])objectArray);
            String string = Throwables.getStackTraceAsString(cause);
            Intrinsics.checkExpressionValueIsNotNull(string, "Throwables.getStackTraceAsString(cause)");
            return string;
        }

        public final void compileScript(@NotNull KtScript script, @NotNull List<? extends ScriptDescriptor> earlierScripts, @NotNull GenerationState state2, @NotNull CompilationErrorHandler errorHandler) {
            Intrinsics.checkParameterIsNotNull(script, "script");
            Intrinsics.checkParameterIsNotNull(earlierScripts, "earlierScripts");
            Intrinsics.checkParameterIsNotNull(state2, "state");
            Intrinsics.checkParameterIsNotNull(errorHandler, "errorHandler");
            state2.getReplSpecific().setScriptResultFieldName(this.getSCRIPT_RESULT_FIELD_NAME());
            state2.getReplSpecific().setEarlierScriptsForReplInterpreter(CollectionsKt.toList((Iterable)earlierScripts));
            state2.beforeCompile();
            KotlinCodegenFacade.generatePackage(state2, script.getContainingKtFile().getPackageFqName(), (Collection<KtFile>)SetsKt.setOf(script.getContainingKtFile()), errorHandler);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

