/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceFile;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.UtilKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPackage;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KotlinJvmBinaryPackageSourceElement
implements SourceElement {
    private final HashMap<String, KotlinJvmBinaryClass> implClassNameToBinaryClass;
    private final JavaPackage jPackage;

    @NotNull
    public String toString() {
        return "Binary package " + this.jPackage.getFqName() + ": " + this.implClassNameToBinaryClass.keySet();
    }

    @Override
    @NotNull
    public SourceFile getContainingFile() {
        SourceFile sourceFile = SourceFile.NO_SOURCE_FILE;
        Intrinsics.checkExpressionValueIsNotNull(sourceFile, "SourceFile.NO_SOURCE_FILE");
        return sourceFile;
    }

    @NotNull
    public final KotlinJvmBinaryClass getRepresentativeBinaryClass() {
        KotlinJvmBinaryClass kotlinJvmBinaryClass = (KotlinJvmBinaryClass)CollectionsKt.first((Iterable)this.implClassNameToBinaryClass.values());
        Intrinsics.checkExpressionValueIsNotNull(kotlinJvmBinaryClass, "implClassNameToBinaryClass.values.first()");
        return kotlinJvmBinaryClass;
    }

    @Nullable
    public final KotlinJvmBinaryClass getContainingBinaryClass(@NotNull DeserializedCallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Name name = UtilKt.getImplClassNameForDeserialized(descriptor2);
        if (name == null) {
            return null;
        }
        Name name2 = name;
        return this.implClassNameToBinaryClass.get(name2.asString());
    }

    public KotlinJvmBinaryPackageSourceElement(@NotNull JavaPackage jPackage, @NotNull List<? extends KotlinJvmBinaryClass> kotlinBinaryClasses2) {
        Intrinsics.checkParameterIsNotNull(jPackage, "jPackage");
        Intrinsics.checkParameterIsNotNull(kotlinBinaryClasses2, "kotlinBinaryClasses");
        this.jPackage = jPackage;
        KotlinJvmBinaryPackageSourceElement kotlinJvmBinaryPackageSourceElement = this;
        KotlinJvmBinaryPackageSourceElement kotlinJvmBinaryPackageSourceElement2 = this;
        KotlinJvmBinaryPackageSourceElement $receiver = kotlinJvmBinaryPackageSourceElement;
        HashMap result2 = MapsKt.hashMapOf(new Pair[0]);
        for (KotlinJvmBinaryClass kotlinJvmBinaryClass : kotlinBinaryClasses2) {
            String string;
            Map map2 = result2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinJvmBinaryClass.getClassId().getShortClassName().asString(), "kotlinBinaryClass.classI\u2026shortClassName.asString()");
            KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
            map2.put(string, kotlinJvmBinaryClass2);
        }
        HashMap hashMap = result2;
        kotlinJvmBinaryPackageSourceElement2.implClassNameToBinaryClass = hashMap;
    }
}

