/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.load.java.components.JavaAnnotationMapper;
import org.jetbrains.kotlin.load.java.descriptors.JavaConstructorDescriptor;
import org.jetbrains.kotlin.load.kotlin.AnnotationUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\n\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J2\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/JavaAnnotationCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "reportDeprecatedJavaAnnotation", "reportErrorsOnPositionedArguments", "reportOnValueArgument", "argument", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin-compiler"})
public final class JavaAnnotationCallChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        CallableDescriptor resultingDescriptor = resolvedCall2.getResultingDescriptor().getOriginal();
        if (!(resultingDescriptor instanceof JavaConstructorDescriptor) || Intrinsics.areEqual((Object)((JavaConstructorDescriptor)resultingDescriptor).getContainingDeclaration().getKind(), (Object)ClassKind.ANNOTATION_CLASS) ^ true) {
            return;
        }
        this.reportErrorsOnPositionedArguments(resolvedCall2, context);
        this.reportDeprecatedJavaAnnotation(resolvedCall2, context);
    }

    private final void reportDeprecatedJavaAnnotation(ResolvedCall<?> resolvedCall2, BasicCallResolutionContext context) {
        Unit unit;
        FqName fqName2;
        ClassifierDescriptor classifierDescriptor;
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        if (!(ktElement instanceof KtAnnotationEntry)) {
            ktElement = null;
        }
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)ktElement;
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        KotlinType kotlinType = (KotlinType)context.trace.get(BindingContext.TYPE, annotationEntry.getTypeReference());
        if (kotlinType == null) {
            return;
        }
        KotlinType type2 = kotlinType;
        Object object = JavaAnnotationMapper.INSTANCE.getJavaToKotlinNameMap();
        ClassifierDescriptor classifierDescriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor2 != null) {
            classifierDescriptor = classifierDescriptor2;
            ClassifierDescriptor it = classifierDescriptor;
            fqName2 = DescriptorUtils.getFqNameSafe(it);
        } else {
            fqName2 = null;
        }
        classifierDescriptor = fqName2;
        Map<FqName, FqName> map2 = object;
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        FqName fqName3 = map2.get(classifierDescriptor);
        if (fqName3 != null) {
            object = fqName3;
            FqName it = (FqName)object;
            context.trace.report(ErrorsJvm.DEPRECATED_JAVA_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry), it));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    private final void reportErrorsOnPositionedArguments(ResolvedCall<?> resolvedCall2, BasicCallResolutionContext context) {
        Map<ValueParameterDescriptor, ResolvedValueArgument> $receiver$iv = AnnotationUtilKt.getJavaAnnotationCallValueArgumentsThatShouldBeNamed(resolvedCall2);
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = $receiver$iv;
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> element$iv;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> it = element$iv = iterator2.next();
            DiagnosticFactory0<KtExpression> diagnosticFactory0 = ErrorsJvm.POSITIONED_VALUE_ARGUMENT_FOR_JAVA_ANNOTATION;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "ErrorsJvm.POSITIONED_VAL\u2026UMENT_FOR_JAVA_ANNOTATION");
            this.reportOnValueArgument(context, it, diagnosticFactory0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportOnValueArgument(BasicCallResolutionContext context, Map.Entry<? extends ValueParameterDescriptor, ? extends ResolvedValueArgument> argument, DiagnosticFactory0<KtExpression> diagnostic) {
        void $receiver$iv;
        Iterable iterable = argument.getValue().getArguments();
        for (Object element$iv : $receiver$iv) {
            ValueArgument it = (ValueArgument)element$iv;
            if (it.getArgumentExpression() == null) continue;
            BindingTrace bindingTrace = context.trace;
            KtExpression ktExpression = it.getArgumentExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            bindingTrace.report(diagnostic.on((KtExpression)((PsiElement)ktExpression)));
        }
    }
}

