/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression.loopTranslator;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBreak;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsDoWhile;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsEmpty;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFor;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsWhile;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.loopTranslator.LoopTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TemporariesUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtWhileExpressionBase;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"createWhile", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsNode;", "doWhile", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhileExpressionBase;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "translateForExpression", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsStatement;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "kotlin-compiler"})
@JvmName(name="LoopTranslator")
public final class LoopTranslator {
    @NotNull
    public static final JsNode createWhile(boolean doWhile, @NotNull KtWhileExpressionBase expression, @NotNull TranslationContext context) {
        JsStatement bodyStatement;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtExpression ktExpression = expression.getCondition();
        if (ktExpression == null) {
            throw (Throwable)new IllegalArgumentException("condition expression should not be null: " + expression.getText());
        }
        KtExpression conditionExpression = ktExpression;
        JsBlock conditionBlock = new JsBlock();
        JsExpression jsCondition = Translation.translateAsExpression(conditionExpression, context, conditionBlock);
        boolean isEmptyLoopCondition = JsAstUtils.isEmptyExpression(jsCondition);
        KtExpression body = expression.getBody();
        JsStatement jsStatement = bodyStatement = body != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(body, context) : (JsStatement)JsEmpty.INSTANCE;
        if (!conditionBlock.isEmpty()) {
            JsIf breakIfConditionIsFalseStatement = new JsIf(JsAstUtils.not(jsCondition), new JsBreak());
            JsBlock bodyBlock = JsAstUtils.convertToBlock(bodyStatement);
            jsCondition = JsLiteral.TRUE;
            if (doWhile) {
                TemporaryVariable secondRun = context.declareTemporary(JsLiteral.FALSE);
                context.addStatementToCurrentBlock(secondRun.assignmentExpression().makeStmt());
                if (!isEmptyLoopCondition) {
                    conditionBlock.getStatements().add(breakIfConditionIsFalseStatement);
                }
                JsIf ifStatement = new JsIf(secondRun.reference(), conditionBlock, JsAstUtils.assignment(secondRun.reference(), JsLiteral.TRUE).makeStmt());
                bodyBlock.getStatements().add(0, ifStatement);
            } else if (isEmptyLoopCondition) {
                bodyBlock.getStatements().clear();
                context.addStatementsToCurrentBlockFrom(conditionBlock);
            } else {
                conditionBlock.getStatements().add(breakIfConditionIsFalseStatement);
                List<JsStatement> list2 = bodyBlock.getStatements();
                Collection collection = conditionBlock.getStatements();
                Intrinsics.checkExpressionValueIsNotNull(collection, "conditionBlock.statements");
                list2.addAll(0, collection);
            }
            bodyStatement = bodyBlock;
        } else if (isEmptyLoopCondition) {
            jsCondition = JsLiteral.FALSE;
        }
        JsWhile result2 = doWhile ? (JsWhile)new JsDoWhile() : new JsWhile();
        result2.setCondition(jsCondition);
        result2.setBody(bodyStatement);
        JsNode jsNode = result2.source(expression);
        if (jsNode == null) {
            Intrinsics.throwNpe();
        }
        return jsNode;
    }

    @NotNull
    public static final JsStatement translateForExpression(@NotNull KtForExpression expression, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtExpression loopRange = PsiUtils.getLoopRange(expression);
        KotlinType rangeType = BindingUtils.getTypeForExpression(context.bindingContext(), loopRange);
        Function0<Boolean> isForOverRange$ = new Function0<Boolean>(rangeType){
            final /* synthetic */ KotlinType $rangeType;

            public final boolean invoke() {
                return Intrinsics.areEqual(DescriptorUtils.getClassDescriptorForType(this.$rangeType).getName().asString(), "IntRange");
            }
            {
                this.$rangeType = kotlinType;
                super(0);
            }
        };
        Function0<Boolean> isForOverRangeLiteral$ = new Function0<Boolean>(loopRange, isForOverRange$){
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.1 $isForOverRange;

            public final boolean invoke() {
                return this.$loopRange instanceof KtBinaryExpression && Intrinsics.areEqual(((KtBinaryExpression)this.$loopRange).getOperationToken(), KtTokens.RANGE) && this.$isForOverRange.invoke();
            }
            {
                this.$loopRange = ktExpression;
                this.$isForOverRange = var2_2;
                super(0);
            }
        };
        Function0<Boolean> isForOverArray$ = new Function0<Boolean>(rangeType){
            final /* synthetic */ KotlinType $rangeType;

            public final boolean invoke() {
                return Intrinsics.areEqual(DescriptorUtils.getClassDescriptorForType(this.$rangeType).getName().asString(), "Array") || Intrinsics.areEqual(DescriptorUtils.getClassDescriptorForType(this.$rangeType).getName().asString(), "IntArray");
            }
            {
                this.$rangeType = kotlinType;
                super(0);
            }
        };
        KtDestructuringDeclaration destructuringParameter = expression.getDestructuringParameter();
        Function0<JsName> declareParameter$ = new Function0<JsName>(expression, context, destructuringParameter){
            final /* synthetic */ KtForExpression $expression;
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtDestructuringDeclaration $destructuringParameter;

            @NotNull
            public final JsName invoke() {
                Unit unit;
                KtParameter loopParameter = PsiUtils.getLoopParameter(this.$expression);
                if (loopParameter != null) {
                    JsName jsName = this.$context.getNameForElement(loopParameter);
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForElement(loopParameter)");
                    return jsName;
                }
                boolean bl = this.$destructuringParameter != null;
                if (_Assertions.ENABLED) {
                    if (!bl) {
                        String string = "If loopParameter is null, multi parameter must be not null " + this.$expression.getText();
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                JsName jsName = this.$context.scope().declareTemporary();
                Intrinsics.checkExpressionValueIsNotNull(jsName, "context.scope().declareTemporary()");
                return jsName;
            }
            {
                this.$expression = ktForExpression;
                this.$context = translationContext;
                this.$destructuringParameter = ktDestructuringDeclaration;
                super(0);
            }
        };
        Object parameterName = declareParameter$.invoke();
        Function1<JsExpression, JsStatement> translateBody$ = new Function1<JsExpression, JsStatement>(expression, context, destructuringParameter, (JsName)parameterName){
            final /* synthetic */ KtForExpression $expression;
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtDestructuringDeclaration $destructuringParameter;
            final /* synthetic */ JsName $parameterName;

            @Nullable
            public final JsStatement invoke(@Nullable JsExpression itemValue) {
                JsVars currentVarInit;
                JsStatement realBody;
                JsStatement jsStatement;
                KtExpression ktExpression = this.$expression.getBody();
                if (ktExpression != null) {
                    KtExpression ktExpression2 = ktExpression;
                    KtExpression it = ktExpression2;
                    jsStatement = Translation.translateAsStatementAndMergeInBlockIfNeeded(it, this.$context);
                } else {
                    jsStatement = realBody = null;
                }
                if (itemValue == null && this.$destructuringParameter == null) {
                    return realBody;
                }
                JsVars jsVars = currentVarInit = this.$destructuringParameter == null ? JsAstUtils.newVar(this.$parameterName, itemValue) : DestructuringDeclarationTranslator.translate(this.$destructuringParameter, this.$parameterName, itemValue, this.$context);
                if (realBody == null) {
                    return new JsBlock(currentVarInit);
                }
                JsBlock block = JsAstUtils.convertToBlock(realBody);
                block.getStatements().add(0, currentVarInit);
                return block;
            }
            {
                this.$expression = ktForExpression;
                this.$context = translationContext;
                this.$destructuringParameter = ktDestructuringDeclaration;
                this.$parameterName = jsName;
                super(1);
            }
        };
        Function0<JsStatement> translateForOverLiteralRange$ = new Function0<JsStatement>(loopRange, context, translateBody$, (JsName)parameterName){
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ translateForExpression.5 $translateBody;
            final /* synthetic */ JsName $parameterName;

            @NotNull
            public final JsStatement invoke() {
                JsExpression jsExpression;
                if (!(this.$loopRange instanceof KtBinaryExpression)) {
                    throw (Throwable)new IllegalStateException("expected JetBinaryExpression, but " + this.$loopRange.getText());
                }
                JsBlock startBlock = new JsBlock();
                JsExpression leftExpression = TranslationUtils.translateLeftExpression(this.$context, (KtBinaryExpression)this.$loopRange, startBlock);
                JsBlock endBlock = new JsBlock();
                JsExpression rightExpression = TranslationUtils.translateRightExpression(this.$context, (KtBinaryExpression)this.$loopRange, endBlock);
                if (TranslationUtils.isCacheNeeded(leftExpression)) {
                    TemporaryVariable startVar = this.$context.declareTemporary(leftExpression);
                    this.$context.addStatementToCurrentBlock(startVar.assignmentExpression().makeStmt());
                    jsExpression = startVar.reference();
                } else {
                    jsExpression = leftExpression;
                }
                JsExpression rangeStart = jsExpression;
                this.$context.addStatementsToCurrentBlockFrom(startBlock);
                this.$context.addStatementsToCurrentBlockFrom(endBlock);
                TemporaryVariable rangeEnd = this.$context.declareTemporary(rightExpression);
                JsStatement body = this.$translateBody.invoke((JsExpression)null);
                JsVars initExpression = JsAstUtils.newVar(this.$parameterName, rangeStart);
                JsBinaryOperation conditionExpression = JsAstUtils.lessThanEq(this.$parameterName.makeRef(), rangeEnd.reference());
                JsPostfixOperation incrementExpression = new JsPostfixOperation(JsUnaryOperator.INC, this.$parameterName.makeRef());
                this.$context.addStatementToCurrentBlock(TemporariesUtils.temporariesInitialization(rangeEnd).makeStmt());
                return new JsFor(initExpression, (JsExpression)conditionExpression, (JsExpression)incrementExpression, body);
            }
            {
                this.$loopRange = ktExpression;
                this.$context = translationContext;
                this.$translateBody = var3_3;
                this.$parameterName = jsName;
                super(0);
            }
        };
        Function0<JsStatement> translateForOverRange$ = new Function0<JsStatement>(context, loopRange, translateBody$, (JsName)parameterName){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.5 $translateBody;
            final /* synthetic */ JsName $parameterName;

            @NotNull
            public final JsStatement invoke() {
                TemporaryVariable rangeExpression = this.$context.declareTemporary(Translation.translateAsExpression(this.$loopRange, this.$context));
                Function1<String, JsExpression> getProperty$ = new Function1<String, JsExpression>(rangeExpression){
                    final /* synthetic */ TemporaryVariable $rangeExpression;

                    @NotNull
                    public final JsExpression invoke(@NotNull String funName) {
                        Intrinsics.checkParameterIsNotNull(funName, "funName");
                        return new JsNameRef(funName, (JsExpression)this.$rangeExpression.reference());
                    }
                    {
                        this.$rangeExpression = temporaryVariable;
                        super(1);
                    }
                };
                TemporaryVariable start = this.$context.declareTemporary(getProperty$.invoke("first"));
                TemporaryVariable end = this.$context.declareTemporary(getProperty$.invoke("last"));
                TemporaryVariable increment = this.$context.declareTemporary(getProperty$.invoke("step"));
                JsStatement body = this.$translateBody.invoke((JsExpression)null);
                JsVars initExpression = JsAstUtils.newVar(this.$parameterName, start.reference());
                JsBinaryOperation conditionExpression = JsAstUtils.lessThanEq(this.$parameterName.makeRef(), end.reference());
                JsBinaryOperation incrementExpression = JsAstUtils.addAssign(this.$parameterName.makeRef(), increment.reference());
                this.$context.addStatementToCurrentBlock(TemporariesUtils.temporariesInitialization(rangeExpression, start, end, increment).makeStmt());
                return new JsFor(initExpression, (JsExpression)conditionExpression, (JsExpression)incrementExpression, body);
            }
            {
                this.$context = translationContext;
                this.$loopRange = ktExpression;
                this.$translateBody = var3_3;
                this.$parameterName = jsName;
                super(0);
            }
        };
        Function0<JsStatement> translateForOverArray$ = new Function0<JsStatement>(context, loopRange, translateBody$){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.5 $translateBody;

            @NotNull
            public final JsStatement invoke() {
                TemporaryVariable rangeExpression = this.$context.declareTemporary(Translation.translateAsExpression(this.$loopRange, this.$context));
                JsExpression jsExpression = rangeExpression.reference();
                FunctionIntrinsic functionIntrinsic = CompositeFIF.LENGTH_PROPERTY_INTRINSIC;
                List<JsExpression> list2 = CollectionsKt.emptyList();
                JsExpression length = functionIntrinsic.apply(jsExpression, list2, this.$context);
                TemporaryVariable end = this.$context.declareTemporary(length);
                TemporaryVariable index2 = this.$context.declareTemporary(this.$context.program().getNumberLiteral(0));
                JsArrayAccess arrayAccess = new JsArrayAccess(rangeExpression.reference(), index2.reference());
                JsStatement body = this.$translateBody.invoke(arrayAccess);
                JsVars initExpression = JsAstUtils.newVar(index2.name(), this.$context.program().getNumberLiteral(0));
                JsBinaryOperation conditionExpression = JsAstUtils.inequality(index2.reference(), end.reference());
                JsPrefixOperation incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, index2.reference());
                this.$context.addStatementToCurrentBlock(TemporariesUtils.temporariesInitialization(rangeExpression, end).makeStmt());
                return new JsFor(initExpression, (JsExpression)conditionExpression, (JsExpression)incrementExpression, body);
            }
            {
                this.$context = translationContext;
                this.$loopRange = ktExpression;
                this.$translateBody = var3_3;
                super(0);
            }
        };
        Function0<JsStatement> translateForOverIterator$ = new Function0<JsStatement>(context, loopRange, translateBody$){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.5 $translateBody;

            @NotNull
            public final JsStatement invoke() {
                Function2<JsExpression, ResolvedCall<FunctionDescriptor>, JsExpression> translateMethodInvocation$ = new Function2<JsExpression, ResolvedCall<FunctionDescriptor>, JsExpression>(this){
                    final /* synthetic */ translateForExpression.9 this$0;

                    @NotNull
                    public final JsExpression invoke(@Nullable JsExpression receiver, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall2) {
                        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
                        return CallTranslator.translate(this.this$0.$context, resolvedCall2, receiver);
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                };
                Function0<JsExpression> iteratorMethodInvocation$ = new Function0<JsExpression>(this, translateMethodInvocation$){
                    final /* synthetic */ translateForExpression.9 this$0;
                    final /* synthetic */ translateForExpression.1 $translateMethodInvocation;

                    @NotNull
                    public final JsExpression invoke() {
                        ResolvedCall<FunctionDescriptor> resolvedCall2;
                        JsExpression range = Translation.translateAsExpression(this.this$0.$loopRange, this.this$0.$context);
                        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = BindingUtils.getIteratorFunction(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                        Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, "resolvedCall");
                        return this.$translateMethodInvocation.invoke(range, resolvedCall3);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$translateMethodInvocation = var2_2;
                        super(0);
                    }
                };
                TemporaryVariable temporaryVariable = this.$context.declareTemporary((JsExpression)iteratorMethodInvocation$.invoke());
                Intrinsics.checkExpressionValueIsNotNull(temporaryVariable, "context.declareTemporary\u2026eratorMethodInvocation())");
                TemporaryVariable iteratorVar = temporaryVariable;
                Function0<JsExpression> nextMethodInvocation$ = new Function0<JsExpression>(this, translateMethodInvocation$, iteratorVar){
                    final /* synthetic */ translateForExpression.9 this$0;
                    final /* synthetic */ translateForExpression.1 $translateMethodInvocation;
                    final /* synthetic */ TemporaryVariable $iteratorVar;

                    @NotNull
                    public final JsExpression invoke() {
                        JsExpression jsExpression = this.$iteratorVar.reference();
                        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getNextFunction(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                        Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, "getNextFunction(context.\u2026dingContext(), loopRange)");
                        return this.$translateMethodInvocation.invoke(jsExpression, resolvedCall2);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$translateMethodInvocation = var2_2;
                        this.$iteratorVar = temporaryVariable;
                        super(0);
                    }
                };
                Function0<JsExpression> hasNextMethodInvocation$ = new Function0<JsExpression>(this, translateMethodInvocation$, iteratorVar){
                    final /* synthetic */ translateForExpression.9 this$0;
                    final /* synthetic */ translateForExpression.1 $translateMethodInvocation;
                    final /* synthetic */ TemporaryVariable $iteratorVar;

                    @NotNull
                    public final JsExpression invoke() {
                        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getHasNextCallable(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                        JsExpression jsExpression = this.$iteratorVar.reference();
                        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
                        Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, "resolvedCall");
                        return this.$translateMethodInvocation.invoke(jsExpression, resolvedCall3);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$translateMethodInvocation = var2_2;
                        this.$iteratorVar = temporaryVariable;
                        super(0);
                    }
                };
                this.$context.addStatementToCurrentBlock(iteratorVar.assignmentExpression().makeStmt());
                Object nextInvoke = nextMethodInvocation$.invoke();
                JsStatement body = this.$translateBody.invoke((JsExpression)nextInvoke);
                Object object = hasNextMethodInvocation$.invoke();
                JsStatement jsStatement = body;
                if (jsStatement == null) {
                    jsStatement = nextInvoke.makeStmt();
                }
                return new JsWhile((JsExpression)object, jsStatement);
            }
            {
                this.$context = translationContext;
                this.$loopRange = ktExpression;
                this.$translateBody = var3_3;
                super(0);
            }
        };
        return isForOverRangeLiteral$.invoke() ? translateForOverLiteralRange$.invoke() : (isForOverRange$.invoke() ? translateForOverRange$.invoke() : (isForOverArray$.invoke() ? translateForOverArray$.invoke() : translateForOverIterator$.invoke()));
    }
}

