/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gnu.trove;

import java.io.IOException;
import java.io.ObjectOutputStream;
import org.jetbrains.kotlin.gnu.trove.TByteProcedure;
import org.jetbrains.kotlin.gnu.trove.TDoubleObjectProcedure;
import org.jetbrains.kotlin.gnu.trove.TIntIntProcedure;
import org.jetbrains.kotlin.gnu.trove.TIntObjectProcedure;
import org.jetbrains.kotlin.gnu.trove.TIntProcedure;
import org.jetbrains.kotlin.gnu.trove.TLongObjectProcedure;
import org.jetbrains.kotlin.gnu.trove.TLongProcedure;
import org.jetbrains.kotlin.gnu.trove.TObjectIntProcedure;
import org.jetbrains.kotlin.gnu.trove.TObjectObjectProcedure;
import org.jetbrains.kotlin.gnu.trove.TObjectProcedure;

class SerializationProcedure
implements TByteProcedure,
TDoubleObjectProcedure,
TIntIntProcedure,
TIntObjectProcedure,
TIntProcedure,
TLongObjectProcedure,
TLongProcedure,
TObjectIntProcedure,
TObjectObjectProcedure,
TObjectProcedure {
    private final ObjectOutputStream stream;
    IOException exception;

    SerializationProcedure(ObjectOutputStream stream2) {
        this.stream = stream2;
    }

    @Override
    public boolean execute(int val) {
        try {
            this.stream.writeInt(val);
        }
        catch (IOException e) {
            this.exception = e;
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(byte val) {
        try {
            this.stream.writeByte(val);
        }
        catch (IOException e) {
            this.exception = e;
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(long val) {
        try {
            this.stream.writeLong(val);
        }
        catch (IOException e) {
            this.exception = e;
            return false;
        }
        return true;
    }

    public boolean execute(Object val) {
        try {
            this.stream.writeObject(val);
        }
        catch (IOException e) {
            this.exception = e;
            return false;
        }
        return true;
    }

    public boolean execute(Object key, Object val) {
        try {
            this.stream.writeObject(key);
            this.stream.writeObject(val);
        }
        catch (IOException e) {
            this.exception = e;
            return false;
        }
        return true;
    }

    public boolean execute(Object key, int val) {
        try {
            this.stream.writeObject(key);
            this.stream.writeInt(val);
        }
        catch (IOException e) {
            this.exception = e;
            return false;
        }
        return true;
    }

    public boolean execute(int key, Object val) {
        try {
            this.stream.writeInt(key);
            this.stream.writeObject(val);
        }
        catch (IOException e) {
            this.exception = e;
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(int key, int val) {
        try {
            this.stream.writeInt(key);
            this.stream.writeInt(val);
        }
        catch (IOException e) {
            this.exception = e;
            return false;
        }
        return true;
    }

    public boolean execute(long key, Object val) {
        try {
            this.stream.writeLong(key);
            this.stream.writeObject(val);
        }
        catch (IOException e) {
            this.exception = e;
            return false;
        }
        return true;
    }

    public boolean execute(double key, Object val) {
        try {
            this.stream.writeDouble(key);
            this.stream.writeObject(val);
        }
        catch (IOException e) {
            this.exception = e;
            return false;
        }
        return true;
    }
}

