/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.Message;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusConnectionImpl;

public class MessageBusImpl
implements MessageBus {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusImpl");
    private static final Comparator<MessageBusImpl> MESSAGE_BUS_COMPARATOR = new Comparator<MessageBusImpl>(){

        @Override
        public int compare(MessageBusImpl bus1, MessageBusImpl bus2) {
            return ContainerUtil.compareLexicographically((List)bus1.myOrderRef.get(), (List)bus2.myOrderRef.get());
        }
    };
    private final ThreadLocal<Queue<DeliveryJob>> myMessageQueue = MessageBusImpl.createThreadLocalQueue();
    private final AtomicReference<List<Integer>> myOrderRef = new AtomicReference();
    private final ConcurrentMap<Topic, Object> mySyncPublishers = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<Topic, Object> myAsyncPublishers = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscribers = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscriberCache = ContainerUtil.newConcurrentMap();
    private final Deque<MessageBusImpl> myChildBuses = new LinkedBlockingDeque<MessageBusImpl>();
    private final ConcurrentMap<List<Integer>, Boolean> myChildOrders = ContainerUtil.newConcurrentMap();
    private static final Object NA = new Object();
    private MessageBusImpl myParentBus;
    private final Object myOwner;
    private boolean myDisposed;

    private MessageBusImpl(Object owner) {
        this.myOwner = owner.toString() + " of " + owner.getClass();
        this.myOrderRef.set(Collections.emptyList());
    }

    @NotNull
    private RootBus getRootBus() {
        RootBus rootBus = this.myParentBus != null ? this.myParentBus.getRootBus() : this.asRoot();
        if (rootBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl", "getRootBus"));
        }
        return rootBus;
    }

    private RootBus asRoot() {
        if (this instanceof RootBus) {
            return (RootBus)this;
        }
        throw new AssertionError((Object)("Accessing disposed message bus " + this));
    }

    public String toString() {
        return super.toString() + "; owner=" + this.myOwner + (this.myDisposed ? "; disposed" : "");
    }

    private void onChildBusDisposed(MessageBusImpl childBus) {
        boolean removed = this.myChildBuses.remove(childBus);
        this.myChildOrders.remove(childBus.myOrderRef.get());
        Map map2 = (Map)this.getRootBus().myWaitingBuses.get();
        if (map2 != null) {
            map2.remove(childBus);
        }
        this.getRootBus().clearSubscriberCache();
        LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public MessageBusConnection connect() {
        this.checkNotDisposed();
        MessageBusConnectionImpl messageBusConnectionImpl = new MessageBusConnectionImpl(this);
        if (messageBusConnectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl", "connect"));
        }
        return messageBusConnectionImpl;
    }

    @Override
    @NotNull
    public MessageBusConnection connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl", "connect"));
        }
        MessageBusConnection connection = this.connect();
        Disposer.register(parentDisposable, connection);
        MessageBusConnection messageBusConnection = connection;
        if (messageBusConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl", "connect"));
        }
        return messageBusConnection;
    }

    @Override
    @NotNull
    public <L> L syncPublisher(final @NotNull Topic<L> topic) {
        if (topic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topic", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl", "syncPublisher"));
        }
        this.checkNotDisposed();
        Object publisher = this.mySyncPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler2 = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    MessageBusImpl.this.sendMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler2);
            publisher = ConcurrencyUtil.cacheOrGet(this.mySyncPublishers, topic, publisher);
        }
        Object v = publisher;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl", "syncPublisher"));
        }
        return (L)v;
    }

    @Override
    public void dispose() {
        this.checkNotDisposed();
        Queue<DeliveryJob> jobs = this.myMessageQueue.get();
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        this.myMessageQueue.remove();
        if (this.myParentBus != null) {
            this.myParentBus.onChildBusDisposed(this);
            this.myParentBus = null;
        } else {
            this.asRoot().myWaitingBuses.remove();
        }
        this.myDisposed = true;
    }

    private void checkNotDisposed() {
        if (this.myDisposed) {
            LOG.error("Already disposed: " + this);
        }
    }

    private void calcSubscribers(Topic topic, List<MessageBusConnectionImpl> result2) {
        Topic.BroadcastDirection direction;
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers != null) {
            result2.addAll(topicSubscribers);
        }
        if ((direction = topic.getBroadcastDirection()) == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.myChildBuses) {
                childBus.calcSubscribers(topic, result2);
            }
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT && this.myParentBus != null) {
            this.myParentBus.calcSubscribers(topic, result2);
        }
    }

    private void postMessage(Message message) {
        this.checkNotDisposed();
        Topic topic = message.getTopic();
        SmartList<MessageBusConnectionImpl> topicSubscribers = (SmartList<MessageBusConnectionImpl>)this.mySubscriberCache.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = new SmartList<MessageBusConnectionImpl>();
            this.calcSubscribers(topic, topicSubscribers);
            this.mySubscriberCache.put(topic, topicSubscribers);
        }
        if (!topicSubscribers.isEmpty()) {
            for (MessageBusConnectionImpl subscriber : topicSubscribers) {
                subscriber.getBus().myMessageQueue.get().offer(new DeliveryJob(subscriber, message));
                subscriber.getBus().notifyPendingJobChange(1);
                subscriber.scheduleMessageDelivery(message);
            }
        }
    }

    private void notifyPendingJobChange(int delta) {
        Integer countObject;
        int count;
        int newCount;
        ThreadLocal ref = this.getRootBus().myWaitingBuses;
        TreeMap<MessageBusImpl, Integer> map2 = (TreeMap<MessageBusImpl, Integer>)ref.get();
        if (map2 == null) {
            map2 = new TreeMap<MessageBusImpl, Integer>(MESSAGE_BUS_COMPARATOR);
            ref.set(map2);
        }
        if ((newCount = (count = (countObject = (Integer)map2.get(this)) == null ? 0 : countObject) + delta) > 0) {
            this.checkNotDisposed();
            map2.put(this, newCount);
        } else if (newCount == 0) {
            map2.remove(this);
        } else {
            LOG.error("Negative job count: " + this);
        }
    }

    private void sendMessage(Message message) {
        this.pumpMessages();
        this.postMessage(message);
        this.pumpMessages();
    }

    private void pumpMessages() {
        this.checkNotDisposed();
        if (this.myParentBus != null) {
            LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
            this.myParentBus.pumpMessages();
        } else {
            Set buses;
            Map map2 = (Map)this.asRoot().myWaitingBuses.get();
            if (map2 != null && !(buses = map2.keySet()).isEmpty()) {
                for (MessageBusImpl bus : new ArrayList(buses)) {
                    if (bus.myDisposed) {
                        map2.remove(bus);
                        LOG.error("Accessing disposed message bus " + bus);
                        continue;
                    }
                    bus.doPumpMessages();
                }
            }
        }
    }

    private void doPumpMessages() {
        DeliveryJob job;
        Queue<DeliveryJob> queue = this.myMessageQueue.get();
        while ((job = queue.poll()) != null) {
            this.notifyPendingJobChange(-1);
            job.connection.deliverMessage(job.message);
        }
    }

    void notifyOnSubscription(MessageBusConnectionImpl connection, Topic topic) {
        this.checkNotDisposed();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = ContainerUtil.createLockFreeCopyOnWriteList();
            topicSubscribers = ConcurrencyUtil.cacheOrGet(this.mySubscribers, topic, topicSubscribers);
        }
        topicSubscribers.add(connection);
        this.getRootBus().clearSubscriberCache();
    }

    void clearSubscriberCache() {
        this.mySubscriberCache.clear();
        for (MessageBusImpl bus : this.myChildBuses) {
            bus.clearSubscriberCache();
        }
    }

    void notifyConnectionTerminated(MessageBusConnectionImpl connection) {
        for (List topicSubscribers : this.mySubscribers.values()) {
            topicSubscribers.remove(connection);
        }
        if (this.myDisposed) {
            return;
        }
        this.getRootBus().clearSubscriberCache();
        Iterator i = this.myMessageQueue.get().iterator();
        while (i.hasNext()) {
            DeliveryJob job = (DeliveryJob)i.next();
            if (job.connection != connection) continue;
            i.remove();
            this.notifyPendingJobChange(-1);
        }
    }

    void deliverSingleMessage() {
        this.checkNotDisposed();
        DeliveryJob job = this.myMessageQueue.get().poll();
        if (job == null) {
            return;
        }
        this.notifyPendingJobChange(-1);
        job.connection.deliverMessage(job.message);
    }

    @NotNull
    static <T> ThreadLocal<Queue<T>> createThreadLocalQueue() {
        ThreadLocal threadLocal = new ThreadLocal<Queue<T>>(){

            @Override
            protected Queue<T> initialValue() {
                return new ConcurrentLinkedQueue();
            }
        };
        if (threadLocal == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl", "createThreadLocalQueue"));
        }
        return threadLocal;
    }

    public static class RootBus
    extends MessageBusImpl {
        private final ThreadLocal<SortedMap<MessageBusImpl, Integer>> myWaitingBuses;

        public RootBus(@NotNull Object owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl$RootBus", "<init>"));
            }
            super(owner);
            this.myWaitingBuses = new ThreadLocal();
        }
    }

    private static class DeliveryJob {
        public final MessageBusConnectionImpl connection;
        public final Message message;

        public DeliveryJob(MessageBusConnectionImpl connection, Message message) {
            this.connection = connection;
            this.message = message;
        }

        @NonNls
        public String toString() {
            return "{ DJob connection:" + this.connection.toString() + "; message: " + this.message + " }";
        }
    }
}

