/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.containers.RefHashMap;

public final class SoftHashMap<K, V>
extends RefHashMap<K, V> {
    @Override
    @NotNull
    protected <T> RefHashMap.Key<T> createKey(@NotNull T k, @NotNull ReferenceQueue<? super T> q) {
        if (k == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "org/jetbrains/kotlin/com/intellij/util/containers/SoftHashMap", "createKey"));
        }
        if (q == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "org/jetbrains/kotlin/com/intellij/util/containers/SoftHashMap", "createKey"));
        }
        SoftKey softKey = new SoftKey(k, q);
        if (softKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/SoftHashMap", "createKey"));
        }
        return softKey;
    }

    private static class SoftKey<T>
    extends SoftReference<T>
    implements RefHashMap.Key<T> {
        private final int myHash;

        private SoftKey(@NotNull T k, @NotNull ReferenceQueue<? super T> q) {
            if (k == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "org/jetbrains/kotlin/com/intellij/util/containers/SoftHashMap$SoftKey", "<init>"));
            }
            if (q == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "org/jetbrains/kotlin/com/intellij/util/containers/SoftHashMap$SoftKey", "<init>"));
            }
            super(k, q);
            this.myHash = k.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RefHashMap.Key)) {
                return false;
            }
            if (this.myHash != o.hashCode()) {
                return false;
            }
            Object t = this.get();
            Object u = ((RefHashMap.Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }

        @NonNls
        public String toString() {
            return "SoftHashMap.SoftKey(" + this.get() + ")";
        }
    }
}

