/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.CommonProcessors;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.FunctionUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.Query;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.gnu.trove.THashSet;
import org.jetbrains.kotlin.gnu.trove.TObjectHashingStrategy;

public class UniqueResultsQuery<T, M>
implements Query<T> {
    private final Query<T> myOriginal;
    private final TObjectHashingStrategy<M> myHashingStrategy;
    private final Function<T, M> myMapper;

    public UniqueResultsQuery(@NotNull Query<T> original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery", "<init>"));
        }
        this(original, ContainerUtil.canonicalStrategy(), FunctionUtil.id());
    }

    public UniqueResultsQuery(@NotNull Query<T> original, @NotNull TObjectHashingStrategy<M> hashingStrategy) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery", "<init>"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery", "<init>"));
        }
        this(original, hashingStrategy, FunctionUtil.id());
    }

    public UniqueResultsQuery(@NotNull Query<T> original, @NotNull TObjectHashingStrategy<M> hashingStrategy, @NotNull Function<T, M> mapper) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery", "<init>"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery", "<init>"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery", "<init>"));
        }
        this.myOriginal = original;
        this.myHashingStrategy = hashingStrategy;
        this.myMapper = mapper;
    }

    @Override
    public T findFirst() {
        return this.myOriginal.findFirst();
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery", "forEach"));
        }
        return this.process(consumer, Collections.synchronizedSet(new THashSet<M>(this.myHashingStrategy)));
    }

    private boolean process(@NotNull Processor<T> consumer, @NotNull Set<M> processedElements) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery", "process"));
        }
        if (processedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedElements", "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery", "process"));
        }
        return this.myOriginal.forEach(new MyProcessor(processedElements, consumer));
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(Collections.synchronizedList(new ArrayList()));
        this.forEach((Processor<T>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery", "findAll"));
        }
        return collection;
    }

    @Override
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }

    public String toString() {
        return "UniqueQuery: " + this.myOriginal;
    }

    private class MyProcessor
    implements Processor<T> {
        private final Set<M> myProcessedElements;
        private final Processor<T> myConsumer;

        public MyProcessor(@NotNull Set<M> processedElements, @NotNull Processor<T> consumer) {
            if (processedElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedElements", "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery$MyProcessor", "<init>"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/com/intellij/util/UniqueResultsQuery$MyProcessor", "<init>"));
            }
            this.myProcessedElements = processedElements;
            this.myConsumer = consumer;
        }

        @Override
        public boolean process(T t) {
            return !this.myProcessedElements.add(UniqueResultsQuery.this.myMapper.fun(t)) || this.myConsumer.process(t);
        }
    }
}

