/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import sun.reflect.ConstructorAccessor;

public class ReflectionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ReflectionUtil");
    private static final Method acquireConstructorAccessorMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, "acquireConstructorAccessor", new Class[0]);
    private static final Method getConstructorAccessorMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, "getConstructorAccessor", new Class[0]);

    private ReflectionUtil() {
    }

    @NotNull
    public static Field findField(@NotNull Class clazz, final @Nullable Class type2, final @NotNull String name) throws NoSuchFieldException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "findField"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "findField"));
        }
        Field result2 = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return name.equals(field.getName()) && (type2 == null || field.getType().equals(type2));
            }
        });
        if (result2 != null) {
            Field field = result2;
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "findField"));
            }
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type2);
    }

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, final @Nullable(value="null means any type") Class<?> fieldType, final @NotNull String fieldName) throws NoSuchFieldException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "findAssignableField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "findAssignableField"));
        }
        Field result2 = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return fieldName.equals(field.getName()) && (fieldType == null || fieldType.isAssignableFrom(field.getType()));
            }
        });
        if (result2 != null) {
            Field field = result2;
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "findAssignableField"));
            }
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    private static Field processFields(@NotNull Class clazz, @NotNull Condition<Field> checker) {
        Class<?>[] interfaces;
        Field result2;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "processFields"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "processFields"));
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!checker.value(field)) continue;
            field.setAccessible(true);
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && (result2 = ReflectionUtil.processFields(superClass, checker)) != null) {
            return result2;
        }
        for (Class<?> each : interfaces = clazz.getInterfaces()) {
            Field result3 = ReflectionUtil.processFields(each, checker);
            if (result3 == null) continue;
            return result3;
        }
        return null;
    }

    public static void resetField(@NotNull Class clazz, @Nullable(value="null means of any type") Class type2, @NotNull String name) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "resetField"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "resetField"));
        }
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type2, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(@Nullable Object object, @NotNull Field field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "resetField"));
        }
        field.setAccessible(true);
        Class<?> type2 = field.getType();
        try {
            if (type2.isPrimitive()) {
                if (Boolean.TYPE.equals(type2)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type2)) {
                    field.set(object, 0);
                } else if (Double.TYPE.equals(type2)) {
                    field.set(object, 0.0);
                } else if (Float.TYPE.equals(type2)) {
                    field.set(object, Float.valueOf(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            LOG.info(e);
        }
    }

    @Nullable
    public static Method findMethod(@NotNull Collection<Method> methods2, @NonNls @NotNull String name, Class ... parameters2) {
        if (methods2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "findMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "findMethod"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "findMethod"));
        }
        for (Method method : methods2) {
            if (!name.equals(method.getName()) || !Arrays.equals(parameters2, method.getParameterTypes())) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@NotNull Class aClass2, @NonNls @NotNull String name, Class ... parameters2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getMethod"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getMethod"));
        }
        return ReflectionUtil.findMethod(ReflectionUtil.getClassPublicMethods(aClass2, false), name, parameters2);
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class aClass2, @NonNls @NotNull String name, Class ... parameters2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        return ReflectionUtil.findMethod(ReflectionUtil.getClassDeclaredMethods(aClass2, false), name, parameters2);
    }

    @Nullable
    public static Field getDeclaredField(@NotNull Class aClass2, final @NonNls @NotNull String name) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getDeclaredField"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getDeclaredField"));
        }
        return ReflectionUtil.processFields(aClass2, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return name.equals(field.getName());
            }
        });
    }

    @NotNull
    public static List<Method> getClassPublicMethods(@NotNull Class aClass2, boolean includeSynthetic) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getClassPublicMethods"));
        }
        Method[] methods2 = aClass2.getMethods();
        List<Method> list2 = includeSynthetic ? Arrays.asList(methods2) : ReflectionUtil.filterRealMethods(methods2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getClassPublicMethods"));
        }
        return list2;
    }

    @NotNull
    public static List<Method> getClassDeclaredMethods(@NotNull Class aClass2, boolean includeSynthetic) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getClassDeclaredMethods"));
        }
        Method[] methods2 = aClass2.getDeclaredMethods();
        List<Method> list2 = includeSynthetic ? Arrays.asList(methods2) : ReflectionUtil.filterRealMethods(methods2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getClassDeclaredMethods"));
        }
        return list2;
    }

    @NotNull
    private static List<Method> filterRealMethods(@NotNull Method[] methods2) {
        if (methods2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "filterRealMethods"));
        }
        ArrayList<Method> result2 = ContainerUtil.newArrayList();
        for (Method method : methods2) {
            if (method.isSynthetic()) continue;
            result2.add(method);
        }
        ArrayList<Method> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "filterRealMethods"));
        }
        return arrayList;
    }

    @Nullable
    public static Class getMethodDeclaringClass(@NotNull Class<?> instanceClass, @NonNls @NotNull String methodName, Class ... parameters2) {
        if (instanceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceClass", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        Method method = ReflectionUtil.getMethod(instanceClass, methodName, parameters2);
        return method == null ? null : method.getDeclaringClass();
    }

    public static <T> T getField(@NotNull Class objectClass, @Nullable Object object, @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getField"));
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            return (T)field.get(object);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static <T> T getStaticFieldValue(@NotNull Class objectClass, @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getStaticFieldValue"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getStaticFieldValue"));
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Field " + objectClass + "." + fieldName + " is not static");
            }
            return (T)field.get(null);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    @NotNull
    public static <T> Constructor<T> getDefaultConstructor(@NotNull Class<T> aClass2) {
        Constructor<T> constructor;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getDefaultConstructor"));
        }
        try {
            Constructor<T> constructor2 = aClass2.getConstructor(new Class[0]);
            constructor2.setAccessible(true);
            constructor = constructor2;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No default constructor in " + aClass2, e);
        }
        if (constructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getDefaultConstructor"));
        }
        return constructor;
    }

    @NotNull
    public static ConstructorAccessor getConstructorAccessor(@NotNull Constructor constructor) {
        ConstructorAccessor constructorAccessor;
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getConstructorAccessor"));
        }
        constructor.setAccessible(true);
        try {
            acquireConstructorAccessorMethod.invoke((Object)constructor, new Object[0]);
            constructorAccessor = (ConstructorAccessor)getConstructorAccessorMethod.invoke((Object)constructor, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (constructorAccessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "getConstructorAccessor"));
        }
        return constructorAccessor;
    }

    @NotNull
    public static <T> T createInstanceViaConstructorAccessor(@NotNull ConstructorAccessor constructorAccessor, Object ... arguments2) {
        Object object;
        if (constructorAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorAccessor", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "createInstanceViaConstructorAccessor"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "createInstanceViaConstructorAccessor"));
        }
        try {
            object = constructorAccessor.newInstance(arguments2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "createInstanceViaConstructorAccessor"));
        }
        return (T)object;
    }

    @NotNull
    public static <T> T createInstanceViaConstructorAccessor(@NotNull ConstructorAccessor constructorAccessor) {
        Object object;
        if (constructorAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorAccessor", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "createInstanceViaConstructorAccessor"));
        }
        try {
            object = constructorAccessor.newInstance(ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "createInstanceViaConstructorAccessor"));
        }
        return (T)object;
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass2) {
        Constructor<T> constructor;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "newInstance"));
        }
        try {
            constructor = aClass2.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException e) {
                T t = aClass2.newInstance();
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "newInstance"));
                }
                return t;
            }
        }
        catch (Exception e) {
            for (Annotation annotation2 : aClass2.getAnnotations()) {
                if (!annotation2.annotationType().getName().equals("kotlin.jvm.internal.KotlinClass")) continue;
                Constructor<?>[] constructors2 = aClass2.getDeclaredConstructors();
                Exception exception = e;
                block10: for (int i = 0; i < constructors2.length; ++i) {
                    Object obj;
                    try {
                        Class<?>[] parameterTypes;
                        Constructor<?> constructor2 = constructors2[i];
                        try {
                            constructor2.setAccessible(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        for (Class<?> type2 : parameterTypes = constructor2.getParameterTypes()) {
                            if (type2.getName().equals("kotlin.jvm.internal.DefaultConstructorMarker")) continue block10;
                        }
                        obj = constructor2.newInstance(new Object[parameterTypes.length]);
                    }
                    catch (Exception e1) {
                        exception = e1;
                    }
                    if (obj == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "newInstance"));
                    }
                    return (T)obj;
                }
                throw new RuntimeException(exception);
            }
            throw new RuntimeException(e);
        }
        T t = constructor.newInstance(new Object[0]);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "newInstance"));
        }
        return t;
    }

    @NotNull
    public static <T> T createInstance(@NotNull Constructor<T> constructor, Object ... args) {
        T t;
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "createInstance"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "createInstance"));
        }
        try {
            t = constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "createInstance"));
        }
        return t;
    }

    @Nullable
    public static Class getGrandCallerClass() {
        int stackFrameCount = 3;
        Class callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(++stackFrameCount);
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(2);
        }
        return callerClass;
    }

    @Nullable
    public static Class findCallerClass(int framesToSkip) {
        try {
            Class[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    public static boolean isAssignable(@NotNull Class<?> ancestor, @NotNull Class<?> descendant) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "isAssignable"));
        }
        if (descendant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descendant", "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil", "isAssignable"));
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    private static class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        public Class[] getStack() {
            return this.getClassContext();
        }
    }
}

