/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.util.RetinaImage;
import org.jetbrains.kotlin.com.intellij.util.io.URLUtil;
import org.jetbrains.kotlin.com.intellij.util.ui.ImageUtil;
import org.jetbrains.kotlin.com.intellij.util.ui.JBUI;
import org.jetbrains.kotlin.com.intellij.util.ui.UIUtil;

@Deprecated
public class ImageLoader
implements Serializable {
    public static final Component ourComponent = new Component(){};
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ImageLoader");

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            LOG.info(ex);
        }
        return !mediatracker.isErrorID(1);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/com/intellij/util/ImageLoader", "loadFromUrl"));
        }
        return ImageLoader.loadFromUrl(url, true);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling) {
        float scaleFactor;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/com/intellij/util/ImageLoader", "loadFromUrl"));
        }
        float f = allowFloatScaling ? JBUI.scale(1.0f) : (scaleFactor = JBUI.scale(1.0f) > 1.5f ? 2.0f : 1.0f);
        assert (scaleFactor >= 1.0f) : "By design, only scale factors >= 1.0 are supported";
        boolean scaleImages = scaleFactor > 1.0f && !UIUtil.isRetina();
        boolean loadRetinaImages = UIUtil.isRetina() || scaleImages;
        for (Pair<String, Integer> each : ImageLoader.getFileNames(url.toString(), UIUtil.isUnderDarcula(), loadRetinaImages)) {
            try {
                Image image = ImageLoader.loadFromStream(URLUtil.openStream(new URL((String)each.first)), (Integer)each.second);
                if (image != null && scaleImages) {
                    image = ((String)each.first).contains("@2x") ? ImageLoader.scaleImage(image, scaleFactor / 2.0f) : ImageLoader.scaleImage(image, scaleFactor);
                }
                return image;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    @NotNull
    private static Image scaleImage(Image image, float scale) {
        int width = (int)(scale * (float)image.getWidth(null));
        int height = (int)(scale * (float)image.getHeight(null));
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ImageLoader", "scaleImage"));
        }
        return bufferedImage;
    }

    public static List<Pair<String, Integer>> getFileNames(@NotNull String file, boolean dark, boolean retina) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/ImageLoader", "getFileNames"));
        }
        if (retina || dark) {
            ArrayList<Pair<String, Integer>> answer = new ArrayList<Pair<String, Integer>>(4);
            String name = FileUtil.getNameWithoutExtension(file);
            String ext = FileUtilRt.getExtension(file);
            if (dark && retina) {
                answer.add(Pair.create(name + "@2x_dark." + ext, 2));
            }
            if (dark) {
                answer.add(Pair.create(name + "_dark." + ext, 1));
            }
            if (retina) {
                answer.add(Pair.create(name + "@2x." + ext, 2));
            }
            answer.add(Pair.create(file, 1));
            return answer;
        }
        return Collections.singletonList(Pair.create(file, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadFromStream(@NotNull InputStream inputStream, int scale) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "org/jetbrains/kotlin/com/intellij/util/ImageLoader", "loadFromStream"));
        }
        if (scale <= 0) {
            throw new IllegalArgumentException("Scale must 1 or more");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream2 = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream2.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream2.getInternalBuffer(), 0, outputStream2.size());
            ImageLoader.waitForImage(image);
            if (UIUtil.isRetina() && scale > 1) {
                image = RetinaImage.createFrom(image, scale, ourComponent);
            }
            return image;
        }
        catch (Exception ex) {
            LOG.error(ex);
            return null;
        }
    }
}

