/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;

public class PsiClassUtil {
    private PsiClassUtil() {
    }

    public static boolean isRunnableClass(PsiClass aClass2, boolean mustBePublic) {
        return PsiClassUtil.isRunnableClass(aClass2, mustBePublic, true);
    }

    public static boolean isRunnableClass(PsiClass aClass2, boolean mustBePublic, boolean mustNotBeAbstract) {
        if (aClass2 instanceof PsiAnonymousClass) {
            return false;
        }
        if (aClass2.isInterface()) {
            return false;
        }
        if (mustBePublic && !aClass2.hasModifierProperty("public")) {
            return false;
        }
        if (aClass2.hasModifierProperty("private")) {
            return false;
        }
        if (mustNotBeAbstract && aClass2.hasModifierProperty("abstract")) {
            return false;
        }
        return aClass2.getContainingClass() == null || aClass2.hasModifierProperty("static");
    }
}

