/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubTree;

public abstract class StubTreeLoader {
    public static StubTreeLoader getInstance() {
        return ServiceManager.getService(StubTreeLoader.class);
    }

    @Nullable
    public abstract ObjectStubTree readOrBuild(Project var1, VirtualFile var2, @Nullable PsiFile var3);

    @Nullable
    public abstract ObjectStubTree readFromVFile(Project var1, VirtualFile var2);

    public abstract void rebuildStubTree(VirtualFile var1);

    public abstract boolean canHaveStub(VirtualFile var1);

    public String getStubAstMismatchDiagnostics(@NotNull VirtualFile file, @NotNull PsiFile psiFile, @NotNull ObjectStubTree stubTree, @Nullable Document prevCachedDocument) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "getStubAstMismatchDiagnostics"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "getStubAstMismatchDiagnostics"));
        }
        if (stubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubTree", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "getStubAstMismatchDiagnostics"));
        }
        String msg2 = "";
        msg2 = msg2 + "\n file=" + psiFile;
        msg2 = msg2 + ", file.class=" + psiFile.getClass();
        msg2 = msg2 + ", file.lang=" + psiFile.getLanguage();
        msg2 = msg2 + ", modStamp=" + psiFile.getModificationStamp();
        if (!(psiFile instanceof PsiCompiledElement)) {
            String text = psiFile.getText();
            PsiFile fromText = PsiFileFactory.getInstance(psiFile.getProject()).createFileFromText(psiFile.getName(), psiFile.getFileType(), (CharSequence)text);
            if (fromText.getLanguage().equals(psiFile.getLanguage())) {
                boolean consistent = DebugUtil.psiToString(psiFile, true).equals(DebugUtil.psiToString(fromText, true));
                msg2 = consistent ? msg2 + "\n tree consistent" : msg2 + "\n AST INCONSISTENT, perhaps after incremental reparse; " + fromText;
            }
        }
        msg2 = msg2 + "\n stub debugInfo=" + stubTree.getDebugInfo();
        msg2 = msg2 + "\n document before=" + prevCachedDocument;
        ObjectStubTree latestIndexedStub = this.readFromVFile(psiFile.getProject(), file);
        msg2 = msg2 + "\nlatestIndexedStub=" + latestIndexedStub;
        if (latestIndexedStub != null) {
            msg2 = msg2 + "\n   same size=" + (stubTree.getPlainList().size() == latestIndexedStub.getPlainList().size());
            msg2 = msg2 + "\n   debugInfo=" + latestIndexedStub.getDebugInfo();
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        msg2 = msg2 + "\n viewProvider=" + viewProvider;
        msg2 = msg2 + "\n viewProvider stamp: " + viewProvider.getModificationStamp();
        msg2 = msg2 + "; file stamp: " + file.getModificationStamp();
        msg2 = msg2 + "; file modCount: " + file.getModificationCount();
        msg2 = msg2 + "; file length: " + file.getLength();
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document != null) {
            msg2 = msg2 + "\n doc saved: " + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
            msg2 = msg2 + "; doc stamp: " + document.getModificationStamp();
            msg2 = msg2 + "; doc size: " + document.getTextLength();
            msg2 = msg2 + "; committed: " + PsiDocumentManager.getInstance(psiFile.getProject()).isCommitted(document);
        }
        return msg2;
    }
}

