/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class PsiNewExpressionImpl
extends ExpressionPsiElement
implements PsiNewExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiNewExpressionImpl");
    private static final TokenSet CLASS_REF = TokenSet.create(JavaElementType.JAVA_CODE_REFERENCE, JavaElementType.ANONYMOUS_CLASS);

    public PsiNewExpressionImpl() {
        super(JavaElementType.NEW_EXPRESSION);
    }

    @Override
    public PsiType getType() {
        return this.doGetType(null);
    }

    @Override
    public PsiType getOwner(@NotNull PsiAnnotation annotation2) {
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "getOwner"));
        }
        assert (annotation2.getParent() == this) : annotation2.getParent() + " != " + this;
        return this.doGetType(annotation2);
    }

    @Nullable
    private PsiType doGetType(@Nullable PsiAnnotation stopAt) {
        PsiType type2 = null;
        SmartList<PsiAnnotation> annotations2 = new SmartList<PsiAnnotation>();
        boolean stop = false;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PsiElementFactory factory;
            IElementType elementType = child.getElementType();
            if (elementType == JavaElementType.ANNOTATION) {
                PsiAnnotation annotation2 = (PsiAnnotation)child.getPsi();
                annotations2.add(annotation2);
                if (annotation2 != stopAt) continue;
                stop = true;
                continue;
            }
            if (elementType == JavaElementType.JAVA_CODE_REFERENCE) {
                assert (type2 == null) : this;
                type2 = new PsiClassReferenceType((PsiJavaCodeReferenceElement)child.getPsi(), null);
                if (!stop) continue;
                return type2;
            }
            if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(elementType)) {
                assert (type2 == null) : this;
                factory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
                type2 = factory.createPrimitiveType(child.getText(), ContainerUtil.copyAndClear(annotations2, PsiAnnotation.ARRAY_FACTORY, true));
                if (!stop) continue;
                return type2;
            }
            if (elementType == JavaTokenType.LBRACKET) {
                assert (type2 != null) : this;
                type2 = type2.createArrayType(ContainerUtil.copyAndClear(annotations2, PsiAnnotation.ARRAY_FACTORY, true));
                if (!stop) continue;
                return type2;
            }
            if (elementType != JavaElementType.ANONYMOUS_CLASS) continue;
            factory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
            PsiClass aClass2 = (PsiClass)child.getPsi();
            PsiSubstitutor substitutor2 = aClass2 instanceof PsiTypeParameter ? PsiSubstitutor.EMPTY : factory.createRawSubstitutor(aClass2);
            type2 = factory.createType(aClass2, substitutor2, PsiUtil.getLanguageLevel(aClass2), ContainerUtil.copyAndClear(annotations2, PsiAnnotation.ARRAY_FACTORY, true));
            if (!stop) continue;
            return type2;
        }
        return stop ? null : type2;
    }

    @Override
    public PsiExpressionList getArgumentList() {
        PsiExpressionList list2 = (PsiExpressionList)this.findChildByRoleAsPsiElement(73);
        if (list2 != null) {
            return list2;
        }
        CompositeElement anonymousClass = (CompositeElement)SourceTreeToPsiMap.psiElementToTree(this.findChildByRoleAsPsiElement(70));
        if (anonymousClass != null) {
            return (PsiExpressionList)anonymousClass.findChildByRoleAsPsiElement(73);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiExpression[] getArrayDimensions() {
        PsiExpression[] expressions = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.ARRAY_DIMENSION_BIT_SET, PsiExpression.ARRAY_FACTORY);
        PsiExpression qualifier2 = this.getQualifier();
        if (qualifier2 == null) {
            if (expressions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "getArrayDimensions"));
            }
            return expressions;
        }
        LOG.assertTrue(expressions[0] == qualifier2);
        PsiExpression[] expressions1 = new PsiExpression[expressions.length - 1];
        System.arraycopy(expressions, 1, expressions1, 0, expressions1.length);
        if (expressions1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "getArrayDimensions"));
        }
        return expressions1;
    }

    @Override
    public PsiArrayInitializerExpression getArrayInitializer() {
        return (PsiArrayInitializerExpression)this.findChildByRoleAsPsiElement(77);
    }

    @Override
    public PsiMethod resolveMethod() {
        return this.resolveConstructor();
    }

    private PsiPolyVariantCachingReference getConstructorFakeReference() {
        return new PsiPolyVariantCachingReference(){

            @NotNull
            public JavaResolveResult[] resolveInner(boolean incompleteCode, @NotNull PsiFile containingFile) {
                if (containingFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1", "resolveInner"));
                }
                ASTNode classRef = PsiNewExpressionImpl.this.findChildByRole(71);
                if (classRef != null) {
                    ASTNode argumentList2 = PsiImplUtil.skipWhitespaceAndComments(classRef.getTreeNext());
                    if (argumentList2 != null && argumentList2.getElementType() == JavaElementType.EXPRESSION_LIST) {
                        JavaPsiFacade facade = JavaPsiFacade.getInstance(containingFile.getProject());
                        PsiClassType aClass2 = facade.getElementFactory().createType((PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(classRef));
                        JavaResolveResult[] javaResolveResultArray = facade.getResolveHelper().multiResolveConstructor(aClass2, (PsiExpressionList)SourceTreeToPsiMap.treeElementToPsi(argumentList2), PsiNewExpressionImpl.this);
                        if (javaResolveResultArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1", "resolveInner"));
                        }
                        return javaResolveResultArray;
                    }
                } else {
                    ASTNode anonymousClassElement = PsiNewExpressionImpl.this.findChildByType(JavaElementType.ANONYMOUS_CLASS);
                    if (anonymousClassElement != null) {
                        JavaPsiFacade facade = JavaPsiFacade.getInstance(containingFile.getProject());
                        PsiAnonymousClass anonymousClass = (PsiAnonymousClass)SourceTreeToPsiMap.treeElementToPsi(anonymousClassElement);
                        PsiClassType aClass3 = anonymousClass.getBaseClassType();
                        ASTNode argumentList3 = anonymousClassElement.findChildByType(JavaElementType.EXPRESSION_LIST);
                        JavaResolveResult[] javaResolveResultArray = facade.getResolveHelper().multiResolveConstructor(aClass3, (PsiExpressionList)SourceTreeToPsiMap.treeElementToPsi(argumentList3), anonymousClass);
                        if (javaResolveResultArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1", "resolveInner"));
                        }
                        return javaResolveResultArray;
                    }
                }
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1", "resolveInner"));
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }

            @Override
            public PsiElement getElement() {
                return PsiNewExpressionImpl.this;
            }

            @Override
            public TextRange getRangeInElement() {
                return null;
            }

            @Override
            @NotNull
            public String getCanonicalText() {
                throw new UnsupportedOperationException();
            }

            @Override
            public PsiElement handleElementRename(String newElementName) {
                return null;
            }

            @Override
            public PsiElement bindToElement(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1", "bindToElement"));
                }
                return null;
            }

            @Override
            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            public int hashCode() {
                return this.getElement().hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof PsiPolyVariantCachingReference && this.getElement() == ((PsiReference)obj).getElement();
            }
        };
    }

    @Override
    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        ResolveResult[] results = this.getConstructorFakeReference().multiResolve(false);
        JavaResolveResult javaResolveResult = results.length == 1 ? (JavaResolveResult)results[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "resolveMethodGenerics"));
        }
        return javaResolveResult;
    }

    @Override
    public PsiExpression getQualifier() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    @NotNull
    public PsiReferenceParameterList getTypeArgumentList() {
        PsiReferenceParameterList psiReferenceParameterList = (PsiReferenceParameterList)this.findChildByRoleAsPsiElement(246);
        if (psiReferenceParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "getTypeArgumentList"));
        }
        return psiReferenceParameterList;
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] psiTypeArray = this.getTypeArgumentList().getTypeArguments();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "getTypeArguments"));
        }
        return psiTypeArray;
    }

    @Override
    public PsiMethod resolveConstructor() {
        return (PsiMethod)this.resolveMethodGenerics().getElement();
    }

    @Override
    public PsiJavaCodeReferenceElement getClassReference() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(71);
    }

    @Override
    public PsiAnonymousClass getAnonymousClass() {
        ASTNode anonymousClass = this.findChildByType(JavaElementType.ANONYMOUS_CLASS);
        if (anonymousClass == null) {
            return null;
        }
        return (PsiAnonymousClass)SourceTreeToPsiMap.treeElementToPsi(anonymousClass);
    }

    @Override
    @Nullable
    public PsiJavaCodeReferenceElement getClassOrAnonymousClassReference() {
        ASTNode ref = this.findChildByType(CLASS_REF);
        if (ref == null) {
            return null;
        }
        if (ref instanceof PsiJavaCodeReferenceElement) {
            return (PsiJavaCodeReferenceElement)((Object)ref);
        }
        PsiAnonymousClass anonymousClass = (PsiAnonymousClass)ref.getPsi();
        return anonymousClass.getBaseClassReference();
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "deleteChildInternal"));
        }
        if (this.getChildRole(child) == 54) {
            ASTNode dot = this.findChildByRole(55);
            super.deleteChildInternal(child);
            this.deleteChildInternal(dot);
        } else {
            super.deleteChildInternal(child);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 246: {
                return this.findChildByType(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            case 54: {
                TreeElement firstChild = this.getFirstChildNode();
                if (firstChild != null && firstChild.getElementType() != JavaTokenType.NEW_KEYWORD) {
                    return firstChild;
                }
                return null;
            }
            case 55: {
                return this.findChildByType(JavaTokenType.DOT);
            }
            case 69: {
                return this.findChildByType(JavaTokenType.NEW_KEYWORD);
            }
            case 70: {
                return this.findChildByType(JavaElementType.ANONYMOUS_CLASS);
            }
            case 71: {
                return this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
            }
            case 72: {
                return this.findChildByType(ElementType.PRIMITIVE_TYPE_BIT_SET);
            }
            case 73: {
                return this.findChildByType(JavaElementType.EXPRESSION_LIST);
            }
            case 74: {
                return this.findChildByType(JavaTokenType.LBRACKET);
            }
            case 75: {
                return this.findChildByType(JavaTokenType.RBRACKET);
            }
            case 77: 
        }
        if (this.getLastChildNode().getElementType() == JavaElementType.ARRAY_INITIALIZER_EXPRESSION) {
            return this.getLastChildNode();
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i == JavaTokenType.NEW_KEYWORD) {
            return 69;
        }
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return 71;
        }
        if (i == JavaElementType.EXPRESSION_LIST) {
            return 73;
        }
        if (i == JavaTokenType.LBRACKET) {
            return 74;
        }
        if (i == JavaTokenType.RBRACKET) {
            return 75;
        }
        if (i == JavaElementType.ARRAY_INITIALIZER_EXPRESSION) {
            if (child == this.getLastChildNode()) {
                return 77;
            }
            if (child == this.getFirstChildNode()) {
                return 54;
            }
            return 76;
        }
        if (i == JavaElementType.ANONYMOUS_CLASS) {
            return 70;
        }
        if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(child.getElementType())) {
            return 72;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return child == this.getFirstChildNode() ? 54 : 76;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitNewExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiNewExpression:" + this.getText();
    }
}

