/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiFunctionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public abstract class InputOutputConstraintFormula
implements ConstraintFormula {
    public abstract PsiExpression getExpression();

    protected abstract PsiType getT();

    protected abstract void setT(PsiType var1);

    protected abstract InputOutputConstraintFormula createSelfConstraint(PsiType var1, PsiExpression var2);

    protected abstract void collectReturnTypeVariables(InferenceSession var1, PsiExpression var2, PsiType var3, Set<InferenceVariable> var4);

    public Set<InferenceVariable> getInputVariables(InferenceSession session) {
        PsiExpression psiExpression = this.getExpression();
        PsiType type2 = this.getT();
        if (psiExpression instanceof PsiFunctionalExpression) {
            PsiType functionType;
            PsiClassType.ClassResolveResult resolveResult;
            PsiMethod interfaceMethod;
            InferenceVariable inferenceVariable = session.getInferenceVariable(type2);
            if (inferenceVariable != null) {
                return Collections.singleton(inferenceVariable);
            }
            if (LambdaUtil.isFunctionalType(type2) && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(functionType = psiExpression instanceof PsiLambdaExpression ? FunctionalInterfaceParameterizationUtil.getGroundTargetType(type2, (PsiLambdaExpression)psiExpression, false) : type2))) != null) {
                PsiType returnType2;
                HashSet<InferenceVariable> result2 = new HashSet<InferenceVariable>();
                PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
                if (psiExpression instanceof PsiLambdaExpression && !((PsiLambdaExpression)psiExpression).hasFormalParameterTypes() || psiExpression instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)psiExpression).isExact()) {
                    for (PsiParameter parameter : interfaceMethod.getParameterList().getParameters()) {
                        session.collectDependencies(substitutor2.substitute(parameter.getType()), result2);
                    }
                }
                if ((returnType2 = interfaceMethod.getReturnType()) != null) {
                    this.collectReturnTypeVariables(session, psiExpression, substitutor2.substitute(returnType2), result2);
                }
                return result2;
            }
        }
        if (psiExpression instanceof PsiParenthesizedExpression) {
            PsiExpression expression = ((PsiParenthesizedExpression)psiExpression).getExpression();
            return expression != null ? this.createSelfConstraint(type2, expression).getInputVariables(session) : null;
        }
        if (psiExpression instanceof PsiConditionalExpression) {
            Set<InferenceVariable> elseResult;
            PsiExpression thenExpression = ((PsiConditionalExpression)psiExpression).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)psiExpression).getElseExpression();
            Set<InferenceVariable> thenResult = thenExpression != null ? this.createSelfConstraint(type2, thenExpression).getInputVariables(session) : null;
            Set<InferenceVariable> set = elseResult = elseExpression != null ? this.createSelfConstraint(type2, elseExpression).getInputVariables(session) : null;
            if (thenResult == null) {
                return elseResult;
            }
            if (elseResult == null) {
                return thenResult;
            }
            thenResult.addAll(elseResult);
            return thenResult;
        }
        return null;
    }

    @Nullable
    public Set<InferenceVariable> getOutputVariables(Set<InferenceVariable> inputVariables, InferenceSession session) {
        HashSet<InferenceVariable> mentionedVariables = new HashSet<InferenceVariable>();
        session.collectDependencies(this.getT(), mentionedVariables);
        if (inputVariables != null) {
            mentionedVariables.removeAll(inputVariables);
        }
        return mentionedVariables.isEmpty() ? null : mentionedVariables;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.setT(substitutor2.substitute(this.getT()));
        if (cache2) {
            LambdaUtil.getFunctionalTypeMap().put(this.getExpression(), this.getT());
        }
    }

    public String toString() {
        return this.getExpression().getText() + " -> " + this.getT().getPresentableText();
    }
}

