/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFunctionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public class PsiPolyExpressionUtil {
    public static boolean hasStandaloneForm(PsiExpression expression) {
        return !(expression instanceof PsiFunctionalExpression) && !(expression instanceof PsiParenthesizedExpression) && !(expression instanceof PsiConditionalExpression) && !(expression instanceof PsiCallExpression);
    }

    public static boolean isPolyExpression(PsiExpression expression) {
        if (expression instanceof PsiFunctionalExpression) {
            return true;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isPolyExpression(((PsiParenthesizedExpression)expression).getExpression());
        }
        if (expression instanceof PsiNewExpression) {
            PsiTypeElement[] typeElements;
            PsiReferenceParameterList parameterList;
            PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)expression).getClassOrAnonymousClassReference();
            if (classReference != null && (parameterList = classReference.getParameterList()) != null && (typeElements = parameterList.getTypeParameterElements()).length == 1 && typeElements[0].getType() instanceof PsiDiamondType) {
                return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression);
            }
        } else {
            ConditionalKind conditionalKind;
            if (expression instanceof PsiMethodCallExpression) {
                MethodCandidateInfo.CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(((PsiMethodCallExpression)expression).getArgumentList());
                return PsiPolyExpressionUtil.isMethodCallPolyExpression(expression, candidateProperties != null ? candidateProperties.getMethod() : ((PsiMethodCallExpression)expression).resolveMethod());
            }
            if (expression instanceof PsiConditionalExpression && (conditionalKind = PsiPolyExpressionUtil.isBooleanOrNumeric(expression)) == null) {
                return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression);
            }
        }
        return false;
    }

    public static boolean isMethodCallPolyExpression(PsiExpression expression, PsiMethod method) {
        if (PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression) && ((PsiCallExpression)expression).getTypeArguments().length == 0) {
            if (method != null) {
                PsiTypeElement[] parameterElements;
                PsiReferenceParameterList parameterList;
                PsiJavaCodeReferenceElement classReference;
                HashSet<PsiTypeParameter> typeParameters = new HashSet<PsiTypeParameter>(Arrays.asList(method.getTypeParameters()));
                if (!typeParameters.isEmpty()) {
                    PsiType returnType2 = method.getReturnType();
                    if (returnType2 != null) {
                        return PsiPolyExpressionUtil.mentionsTypeParameters(returnType2, typeParameters);
                    }
                } else if (method.isConstructor() && expression instanceof PsiNewExpression && (classReference = ((PsiNewExpression)expression).getClassOrAnonymousClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (parameterElements = parameterList.getTypeParameterElements()).length == 1 && parameterElements[0].getType() instanceof PsiDiamondType) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static Boolean mentionsTypeParameters(@Nullable PsiType returnType2, final Set<PsiTypeParameter> typeParameters) {
        if (returnType2 == null) {
            return false;
        }
        return returnType2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitType(PsiType type2) {
                return false;
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound != null) {
                    return bound.accept(this);
                }
                return false;
            }

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                for (PsiType type2 : classType.getParameters()) {
                    if (!type2.accept(this).booleanValue()) continue;
                    return true;
                }
                PsiClass psiClass = classType.resolve();
                return psiClass instanceof PsiTypeParameter && typeParameters.contains(psiClass);
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }
        });
    }

    private static boolean isInAssignmentOrInvocationContext(PsiExpression expr) {
        PsiElement context = PsiUtil.skipParenthesizedExprUp(expr.getParent());
        return context instanceof PsiExpressionList || context instanceof PsiArrayInitializerExpression || context instanceof PsiConditionalExpression && (expr instanceof PsiCallExpression || PsiPolyExpressionUtil.isPolyExpression((PsiExpression)context)) || PsiPolyExpressionUtil.isAssignmentContext(expr, context);
    }

    private static boolean isAssignmentContext(PsiExpression expr, PsiElement context) {
        return PsiUtil.isCondition(expr, context) || context instanceof PsiReturnStatement || context instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)context).getOperationTokenType() == JavaTokenType.EQ || context instanceof PsiVariable || context instanceof PsiLambdaExpression;
    }

    private static ConditionalKind isBooleanOrNumeric(PsiExpression expr) {
        PsiMethod method;
        if (expr instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(((PsiParenthesizedExpression)expr).getExpression());
        }
        if (expr == null) {
            return null;
        }
        PsiType type2 = null;
        if (expr instanceof PsiNewExpression || PsiPolyExpressionUtil.hasStandaloneForm(expr)) {
            type2 = expr.getType();
        } else if (expr instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)expr).resolveMethod()) != null) {
            type2 = method.getReturnType();
        }
        if (TypeConversionUtil.isNumericType(type2)) {
            return ConditionalKind.NUMERIC;
        }
        if (TypeConversionUtil.isBooleanType(type2)) {
            return ConditionalKind.BOOLEAN;
        }
        if (expr instanceof PsiConditionalExpression) {
            ConditionalKind elseKind;
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            ConditionalKind thenKind = PsiPolyExpressionUtil.isBooleanOrNumeric(thenExpression);
            if (thenKind == (elseKind = PsiPolyExpressionUtil.isBooleanOrNumeric(elseExpression)) || elseKind == null) {
                return thenKind;
            }
            if (thenKind == null) {
                return elseKind;
            }
        }
        return null;
    }

    private static enum ConditionalKind {
        BOOLEAN,
        NUMERIC;

    }
}

