/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportHolder;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.NameHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.CharTable;

public class JavaDummyHolder
extends DummyHolder
implements PsiImportHolder {
    private static final Map<String, PsiClass> EMPTY = Collections.emptyMap();
    private Map<String, PsiClass> myPseudoImports;

    public JavaDummyHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaDummyHolder", "<init>"));
        }
        super(manager, contentElement, context, null, null, JavaDummyHolder.language(context, JavaLanguage.INSTANCE));
        this.myPseudoImports = EMPTY;
    }

    public JavaDummyHolder(@NotNull PsiManager manager, CharTable table, boolean validity) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaDummyHolder", "<init>"));
        }
        super(manager, null, null, table, validity, JavaLanguage.INSTANCE);
        this.myPseudoImports = EMPTY;
    }

    public JavaDummyHolder(@NotNull PsiManager manager, PsiElement context) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaDummyHolder", "<init>"));
        }
        super(manager, null, context, null, null, JavaDummyHolder.language(context, JavaLanguage.INSTANCE));
        this.myPseudoImports = EMPTY;
    }

    public JavaDummyHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context, CharTable table) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaDummyHolder", "<init>"));
        }
        super(manager, contentElement, context, table, null, JavaDummyHolder.language(context, JavaLanguage.INSTANCE));
        this.myPseudoImports = EMPTY;
    }

    public JavaDummyHolder(@NotNull PsiManager manager, PsiElement context, CharTable table) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaDummyHolder", "<init>"));
        }
        super(manager, null, context, table, null, JavaDummyHolder.language(context, JavaLanguage.INSTANCE));
        this.myPseudoImports = EMPTY;
    }

    public JavaDummyHolder(@NotNull PsiManager manager, CharTable table) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaDummyHolder", "<init>"));
        }
        super(manager, null, null, table, null, JavaLanguage.INSTANCE);
        this.myPseudoImports = EMPTY;
    }

    @Override
    public boolean importClass(PsiClass aClass2) {
        PsiClass resolved;
        if (this.myContext != null && (resolved = JavaPsiFacade.getInstance(this.getProject()).getResolveHelper().resolveReferencedClass(aClass2.getName(), this.myContext)) != null) {
            return this.getManager().areElementsEquivalent(aClass2, resolved);
        }
        String className2 = aClass2.getName();
        if (!this.myPseudoImports.containsKey(className2)) {
            if (this.myPseudoImports == EMPTY) {
                this.myPseudoImports = new LinkedHashMap<String, PsiClass>();
            }
            this.myPseudoImports.put(className2, aClass2);
            this.myManager.beforeChange(false);
            return true;
        }
        return true;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaDummyHolder", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaDummyHolder", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaDummyHolder", "processDeclarations"));
        }
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            String name;
            NameHint nameHint = processor.getHint(NameHint.KEY);
            String string = name = nameHint != null ? nameHint.getName(state2) : null;
            if (name != null) {
                PsiClass imported = this.myPseudoImports.get(name);
                if (imported != null && !processor.execute(imported, state2)) {
                    return false;
                }
            } else {
                for (PsiClass aClass2 : this.myPseudoImports.values()) {
                    if (processor.execute(aClass2, state2)) continue;
                    return false;
                }
            }
            if (this.myContext == null && !JavaResolveUtil.processImplicitlyImportedPackages(processor, state2, place, this.getManager())) {
                return false;
            }
        }
        return true;
    }

    public boolean isSamePackage(PsiElement other) {
        if (other instanceof DummyHolder) {
            PsiElement otherContext = ((DummyHolder)other).myContext;
            if (this.myContext == null) {
                return otherContext == null;
            }
            return JavaPsiFacade.getInstance(this.myContext.getProject()).arePackagesTheSame(this.myContext, otherContext);
        }
        if (other instanceof PsiJavaFile) {
            if (this.myContext != null) {
                return JavaPsiFacade.getInstance(this.myContext.getProject()).arePackagesTheSame(this.myContext, other);
            }
            String packageName = ((PsiJavaFile)other).getPackageName();
            return packageName.isEmpty();
        }
        return false;
    }

    public boolean isInPackage(PsiPackage aPackage) {
        if (this.myContext != null) {
            return JavaPsiFacade.getInstance(this.myContext.getProject()).isInPackage(this.myContext, aPackage);
        }
        return aPackage == null || aPackage.getQualifiedName().isEmpty();
    }

    @Override
    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaDummyHolder", "setOriginalFile"));
        }
        super.setOriginalFile(originalFile);
        this.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, PsiUtil.getLanguageLevel(originalFile));
    }
}

