/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.InheritanceImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaClassSupersImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.gnu.trove.TObjectHashingStrategy;

class ScopedClassHierarchy {
    private static final TObjectHashingStrategy<PsiClass> CLASS_HASHING_STRATEGY = new TObjectHashingStrategy<PsiClass>(){

        @Override
        public int computeHashCode(PsiClass object) {
            return StringUtil.notNullize(object.getQualifiedName()).hashCode();
        }

        @Override
        public boolean equals(PsiClass o1, PsiClass o2) {
            String qname1 = o1.getQualifiedName();
            if (qname1 != null) {
                return qname1.equals(o2.getQualifiedName());
            }
            return o1.getManager().areElementsEquivalent(o1, o2);
        }
    };
    private final Map<PsiClass, PsiClassType.ClassResolveResult> mySupersWithSubstitutors = ContainerUtil.newTroveMap(CLASS_HASHING_STRATEGY);

    private ScopedClassHierarchy(PsiClass psiClass, GlobalSearchScope resolveScope) {
        this.visitType(resolveScope, JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass, PsiSubstitutor.EMPTY));
    }

    private void visitType(GlobalSearchScope resolveScope, @NotNull PsiClassType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/ScopedClassHierarchy", "visitType"));
        }
        PsiClassType.ClassResolveResult resolveResult = type2.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass == null || InheritanceImplUtil.hasObjectQualifiedName(psiClass) || this.mySupersWithSubstitutors.containsKey(psiClass)) {
            return;
        }
        this.mySupersWithSubstitutors.put(psiClass, resolveResult);
        for (PsiType superType : ScopedClassHierarchy.getSuperTypes(psiClass)) {
            PsiType psiType = superType = type2.isRaw() && superType instanceof PsiClassType ? ((PsiClassType)superType).rawType() : resolveResult.getSubstitutor().substitute(superType);
            if (!((superType = PsiClassImplUtil.correctType(superType, resolveScope)) instanceof PsiClassType)) continue;
            this.visitType(resolveScope, (PsiClassType)superType);
        }
    }

    @NotNull
    private static List<PsiType> getSuperTypes(PsiClass psiClass) {
        ArrayList<PsiType> superTypes2 = ContainerUtil.newArrayList();
        if (psiClass instanceof PsiAnonymousClass) {
            ContainerUtil.addIfNotNull(superTypes2, ((PsiAnonymousClass)psiClass).getBaseClassType());
        }
        Collections.addAll(superTypes2, psiClass.getExtendsListTypes());
        Collections.addAll(superTypes2, psiClass.getImplementsListTypes());
        ArrayList<PsiType> arrayList = superTypes2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/ScopedClassHierarchy", "getSuperTypes"));
        }
        return arrayList;
    }

    @NotNull
    private static ScopedClassHierarchy getHierarchy(final @NotNull PsiClass psiClass, @NotNull GlobalSearchScope resolveScope) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/ScopedClassHierarchy", "getHierarchy"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/kotlin/com/intellij/psi/impl/ScopedClassHierarchy", "getHierarchy"));
        }
        ScopedClassHierarchy scopedClassHierarchy = CachedValuesManager.getCachedValue(psiClass, new CachedValueProvider<Map<GlobalSearchScope, ScopedClassHierarchy>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<Map<GlobalSearchScope, ScopedClassHierarchy>> compute() {
                ConcurrentFactoryMap<GlobalSearchScope, ScopedClassHierarchy> result2 = new ConcurrentFactoryMap<GlobalSearchScope, ScopedClassHierarchy>(){

                    @Override
                    @Nullable
                    protected ScopedClassHierarchy create(GlobalSearchScope resolveScope) {
                        return new ScopedClassHierarchy(psiClass, resolveScope);
                    }
                };
                return CachedValueProvider.Result.create(result2, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
            }
        }).get(resolveScope);
        if (scopedClassHierarchy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/ScopedClassHierarchy", "getHierarchy"));
        }
        return scopedClassHierarchy;
    }

    @Nullable
    static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope2, @NotNull PsiClass superClass) {
        if (derivedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "org/jetbrains/kotlin/com/intellij/psi/impl/ScopedClassHierarchy", "getSuperClassSubstitutor"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/ScopedClassHierarchy", "getSuperClassSubstitutor"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/kotlin/com/intellij/psi/impl/ScopedClassHierarchy", "getSuperClassSubstitutor"));
        }
        PsiClassType.ClassResolveResult resolveResult = ScopedClassHierarchy.getHierarchy((PsiClass)derivedClass, (GlobalSearchScope)scope2).mySupersWithSubstitutors.get(superClass);
        if (resolveResult == null) {
            return null;
        }
        PsiClass cachedClass = ObjectUtils.assertNotNull(resolveResult.getElement());
        PsiSubstitutor cachedSubstitutor = resolveResult.getSubstitutor();
        return cachedClass == superClass ? cachedSubstitutor : ScopedClassHierarchy.mirrorSubstitutor(superClass, cachedClass, cachedSubstitutor);
    }

    @NotNull
    private static PsiSubstitutor mirrorSubstitutor(@NotNull PsiClass from, @NotNull PsiClass to, @NotNull PsiSubstitutor substitutor2) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/com/intellij/psi/impl/ScopedClassHierarchy", "mirrorSubstitutor"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/com/intellij/psi/impl/ScopedClassHierarchy", "mirrorSubstitutor"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/ScopedClassHierarchy", "mirrorSubstitutor"));
        }
        Iterator<PsiTypeParameter> baseParams = PsiUtil.typeParametersIterator(to);
        Iterator<PsiTypeParameter> candidateParams = PsiUtil.typeParametersIterator(from);
        PsiSubstitutor answer = PsiSubstitutor.EMPTY;
        while (baseParams.hasNext()) {
            if (!candidateParams.hasNext()) {
                PsiSubstitutor psiSubstitutor = JavaClassSupersImpl.createRawSubstitutor(to);
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/ScopedClassHierarchy", "mirrorSubstitutor"));
                }
                return psiSubstitutor;
            }
            answer = answer.put(baseParams.next(), substitutor2.substitute(candidateParams.next()));
        }
        PsiSubstitutor psiSubstitutor = answer;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/ScopedClassHierarchy", "mirrorSubstitutor"));
        }
        return psiSubstitutor;
    }
}

