/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaClassSupers;
import org.jetbrains.kotlin.gnu.trove.THashSet;

public class InheritanceImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.InheritanceImplUtil");

    public static boolean isInheritor(@NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, boolean checkDeep) {
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (baseClass instanceof PsiAnonymousClass || baseClass.getManager().areElementsEquivalent(baseClass, candidateClass)) {
            return false;
        }
        if (!checkDeep) {
            return InheritanceImplUtil.isInheritor(candidateClass.getManager(), candidateClass, baseClass, false, null);
        }
        GlobalSearchScope scope2 = candidateClass.getResolveScope();
        return JavaClassSupers.getInstance().getSuperClassSubstitutor(baseClass, candidateClass, scope2, PsiSubstitutor.EMPTY) != null;
    }

    public static boolean hasObjectQualifiedName(@NotNull PsiClass candidateClass) {
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "hasObjectQualifiedName"));
        }
        if (!"Object".equals(candidateClass.getName())) {
            return false;
        }
        PsiElement parent2 = candidateClass.getParent();
        return parent2 instanceof PsiJavaFile && "java.lang".equals(((PsiJavaFile)parent2).getPackageName());
    }

    private static boolean isInheritor(@NotNull PsiManager manager, @NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, boolean checkDeep, @Nullable Set<PsiClass> checkedClasses) {
        PsiClass objectClass;
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (candidateClass instanceof PsiAnonymousClass) {
            PsiClass baseCandidateClass = ((PsiAnonymousClass)candidateClass).getBaseClassType().resolve();
            return baseCandidateClass != null && InheritanceUtil.isInheritorOrSelf(baseCandidateClass, baseClass, checkDeep);
        }
        if (checkDeep && LOG.isDebugEnabled()) {
            LOG.debug("Using uncached version for " + candidateClass.getQualifiedName() + " and " + baseClass);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
        if (InheritanceImplUtil.hasObjectQualifiedName(baseClass) && manager.areElementsEquivalent(baseClass, objectClass = facade.findClass("java.lang.Object", candidateClass.getResolveScope()))) {
            if (manager.areElementsEquivalent(candidateClass, objectClass)) {
                return false;
            }
            if (checkDeep || candidateClass.isInterface()) {
                return true;
            }
            return manager.areElementsEquivalent(candidateClass.getSuperClass(), objectClass);
        }
        if (!checkDeep) {
            boolean cInt = candidateClass.isInterface();
            boolean bInt = baseClass.isInterface();
            if (candidateClass instanceof PsiCompiledElement) {
                String baseQName = baseClass.getQualifiedName();
                if (baseQName == null) {
                    return false;
                }
                GlobalSearchScope scope2 = candidateClass.getResolveScope();
                if ("java.lang.Enum".equals(baseQName) && candidateClass.isEnum() && facade.findClass(baseQName, scope2) != null) {
                    return true;
                }
                if ("java.lang.annotation.Annotation".equals(baseQName) && candidateClass.isAnnotationType() && facade.findClass(baseQName, scope2) != null) {
                    return true;
                }
                if (cInt == bInt && InheritanceImplUtil.checkReferenceListWithQualifiedNames(baseQName, candidateClass.getExtendsList(), scope2, facade)) {
                    return true;
                }
                return bInt && !cInt && InheritanceImplUtil.checkReferenceListWithQualifiedNames(baseQName, candidateClass.getImplementsList(), scope2, facade);
            }
            String baseName = baseClass.getName();
            if (cInt == bInt) {
                for (PsiClassType type2 : candidateClass.getExtendsListTypes()) {
                    if (!Comparing.equal(type2.getClassName(), baseName) || !manager.areElementsEquivalent(baseClass, type2.resolve())) continue;
                    return true;
                }
            } else if (!cInt) {
                for (PsiClassType type3 : candidateClass.getImplementsListTypes()) {
                    if (!Comparing.equal(type3.getClassName(), baseName) || !manager.areElementsEquivalent(baseClass, type3.resolve())) continue;
                    return true;
                }
            }
            return false;
        }
        return InheritanceImplUtil.isInheritorWithoutCaching(manager, candidateClass, baseClass, checkedClasses);
    }

    private static boolean checkReferenceListWithQualifiedNames(@NotNull String baseQName, @Nullable PsiReferenceList extList, @NotNull GlobalSearchScope scope2, @NotNull JavaPsiFacade facade) {
        if (baseQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseQName", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "checkReferenceListWithQualifiedNames"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "checkReferenceListWithQualifiedNames"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "checkReferenceListWithQualifiedNames"));
        }
        if (extList != null) {
            for (PsiJavaCodeReferenceElement ref : extList.getReferenceElements()) {
                if (!Comparing.equal(PsiNameHelper.getQualifiedClassName(ref.getQualifiedName(), false), baseQName) || facade.findClass(baseQName, scope2) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isInheritorWithoutCaching(@NotNull PsiManager manager, @NotNull PsiClass aClass2, @NotNull PsiClass baseClass, @Nullable Set<PsiClass> checkedClasses) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "isInheritorWithoutCaching"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "isInheritorWithoutCaching"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "isInheritorWithoutCaching"));
        }
        if (manager.areElementsEquivalent(aClass2, baseClass)) {
            return false;
        }
        if (aClass2.isInterface() && !baseClass.isInterface()) {
            return false;
        }
        if (checkedClasses == null) {
            checkedClasses = new THashSet<PsiClass>();
        }
        checkedClasses.add(aClass2);
        return InheritanceImplUtil.checkInheritor(manager, aClass2.getExtendsListTypes(), baseClass, checkedClasses) || InheritanceImplUtil.checkInheritor(manager, aClass2.getImplementsListTypes(), baseClass, checkedClasses);
    }

    private static boolean checkInheritor(@NotNull PsiManager manager, @NotNull PsiClassType[] supers, @NotNull PsiClass baseClass, @NotNull Set<PsiClass> checkedClasses) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (supers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supers", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (checkedClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedClasses", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        for (PsiClassType aSuper : supers) {
            PsiClass aClass2 = aSuper.resolve();
            if (aClass2 == null || !InheritanceImplUtil.checkInheritor(manager, aClass2, baseClass, checkedClasses)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkInheritor(@NotNull PsiManager manager, @NotNull PsiClass aClass2, @NotNull PsiClass baseClass, @NotNull Set<PsiClass> checkedClasses) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (checkedClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedClasses", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        ProgressIndicatorProvider.checkCanceled();
        if (manager.areElementsEquivalent(baseClass, aClass2)) {
            return true;
        }
        if (checkedClasses.contains(aClass2)) {
            return false;
        }
        return InheritanceImplUtil.isInheritor(manager, aClass2, baseClass, true, checkedClasses);
    }

    public static boolean isInheritorDeep(@NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, @Nullable PsiClass classToByPass) {
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "isInheritorDeep"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "org/jetbrains/kotlin/com/intellij/psi/impl/InheritanceImplUtil", "isInheritorDeep"));
        }
        if (baseClass instanceof PsiAnonymousClass) {
            return false;
        }
        THashSet<PsiClass> checkedClasses = null;
        if (classToByPass != null) {
            checkedClasses = new THashSet<PsiClass>();
            checkedClasses.add(classToByPass);
        }
        return InheritanceImplUtil.isInheritor(candidateClass.getManager(), candidateClass, baseClass, true, checkedClasses);
    }
}

